/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sm;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.sm.ServiceSet;
import org.apache.uima.ducc.sm.SmConstants;
import org.apache.uima.ducc.transport.event.common.IDuccState;

class ServiceInstance
implements SmConstants {
    private DuccLogger logger = DuccLogger.getLogger((String)this.getClass().getName(), (String)"SM");
    long numeric_id = -1L;
    long share_id;
    int instance_id = 0;
    String host;
    ServiceSet sset;
    IDuccState.JobState state = IDuccState.JobState.Undefined;
    String user = null;
    boolean stopped;
    String ducc_home = System.getProperty("DUCC_HOME");
    String api_classpath = this.ducc_home + "/lib/uima-ducc-cli.jar" + ":" + System.getProperty("java.class.path");

    ServiceInstance(ServiceSet sset) {
        this.sset = sset;
        this.stopped = true;
        this.share_id = -1L;
        this.host = "<unknown>";
    }

    public int getInstanceId() {
        return this.instance_id;
    }

    public void setInstanceId(int id) {
        this.instance_id = id;
    }

    public long getId() {
        return this.numeric_id;
    }

    void setId(long id) {
        this.numeric_id = id;
    }

    public long getShareId() {
        return this.share_id;
    }

    public String getHost() {
        return this.host;
    }

    void setUser(String user) {
        this.user = user;
    }

    public void setState(IDuccState.JobState state) {
        this.state = state;
    }

    public IDuccState.JobState getState() {
        return this.state;
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public synchronized boolean isRunning() {
        switch (this.state) {
            case Completing: 
            case Completed: {
                return false;
            }
        }
        return !this.isStopped();
    }

    synchronized void update(long share_id, String host) {
        this.share_id = share_id;
        this.host = host;
    }

    synchronized void setStopped(boolean s) {
        this.stopped = s;
    }

    long start(String spec, DuccProperties meta_props) {
        String methodName = "start";
        this.logger.info(methodName, this.sset.getId(), new Object[]{"START INSTANCE"});
        this.setStopped(false);
        this.user = meta_props.getProperty("user");
        String[] args = new String[]{System.getProperty("ducc.agent.launcher.ducc_spawn_path"), "-u", this.user, "--", System.getProperty("ducc.jvm"), "-cp", this.api_classpath, "org.apache.uima.ducc.cli.DuccServiceSubmit", "--specification", spec, "--service_id", this.sset.getId().toString()};
        for (int i = 0; i < args.length; ++i) {
            if (i > 0 && args[i - 1].equals("-cp")) {
                this.logger.debug(methodName, this.sset.getId(), new Object[]{"Args[", i, "]: <CLASSPATH>"});
                continue;
            }
            this.logger.debug(methodName, this.sset.getId(), new Object[]{"Args[", i, "]:", args[i]});
        }
        ProcessBuilder pb = new ProcessBuilder(args);
        Map<String, String> env = pb.environment();
        env.put("DUCC_HOME", System.getProperty("DUCC_HOME"));
        env.put("DUCC_SERVICE_INSTANCE", Integer.toString(this.instance_id));
        ArrayList<String> stdout_lines = new ArrayList<String>();
        ArrayList<String> stderr_lines = new ArrayList<String>();
        try {
            Process p = pb.start();
            int rc = p.waitFor();
            this.logger.debug(methodName, null, new Object[]{"DuccServiceSubmit returns with rc", rc});
            InputStream stdout = p.getInputStream();
            InputStream stderr = p.getErrorStream();
            BufferedReader stdout_reader = new BufferedReader(new InputStreamReader(stdout));
            BufferedReader stderr_reader = new BufferedReader(new InputStreamReader(stderr));
            String line = null;
            while ((line = stdout_reader.readLine()) != null) {
                stdout_lines.add(line);
            }
            line = null;
            while ((line = stderr_reader.readLine()) != null) {
                stderr_lines.add(line);
            }
        }
        catch (Throwable t) {
            this.logger.error(methodName, this.sset.getId(), t, new Object[0]);
            this.sset.setErrorString(t.toString());
            return -1L;
        }
        for (String s : stderr_lines) {
            this.logger.info(methodName, this.sset.getId(), new Object[]{"Start stderr:", s});
        }
        boolean inhibit_cp = false;
        boolean started = false;
        StringBuffer submit_buffer = new StringBuffer();
        boolean recording = false;
        for (String s : stdout_lines) {
            if (inhibit_cp) {
                inhibit_cp = false;
                this.logger.info(methodName, this.sset.getId(), new Object[]{"<INHIBITED CP>"});
            } else {
                this.logger.info(methodName, this.sset.getId(), new Object[]{"Start stdout:", s});
            }
            if (s.indexOf("-cp") >= 0) {
                inhibit_cp = true;
            }
            if (recording) {
                submit_buffer.append(s.trim());
                submit_buffer.append(";");
            }
            if (s.startsWith("1001 Command launching...")) {
                recording = true;
                continue;
            }
            if (!s.startsWith("Service") || !s.endsWith("submitted")) continue;
            String[] toks = s.split("\\s");
            try {
                this.numeric_id = Long.parseLong(toks[2]);
                started = true;
                this.logger.info(methodName, null, new Object[]{"Request to start service " + this.sset.getId().toString() + " accepted as service instance ", this.numeric_id});
            }
            catch (NumberFormatException e) {
                this.sset.setErrorString("Request to start service " + this.sset.getId().toString() + " failed, can't interpret submit response.: " + s);
                this.logger.warn(methodName, null, new Object[]{"Request to start service " + this.sset.getId().toString() + " failed, can't interpret response.: " + s});
            }
        }
        if (!started) {
            this.logger.warn(methodName, this.sset.getId(), new Object[]{"Request to start service " + this.sset.getId().toString() + " failed."});
            meta_props.put((Object)"submit-error", (Object)submit_buffer.toString());
            this.sset.log_errors(stdout_lines, stderr_lines);
        } else {
            meta_props.remove((Object)"submit-error");
            this.state = IDuccState.JobState.Received;
        }
        this.logger.info(methodName, this.sset.getId(), new Object[]{"START INSTANCE COMPLETE"});
        return this.numeric_id;
    }

    void stop() {
        String methodName = "stop";
        this.setStopped(true);
        String[] args = new String[]{System.getProperty("ducc.agent.launcher.ducc_spawn_path"), "-u", this.user, "--", System.getProperty("ducc.jvm"), "-cp", this.api_classpath, "org.apache.uima.ducc.cli.DuccServiceCancel", "--id", Long.toString(this.numeric_id)};
        for (int i = 0; i < args.length; ++i) {
            if (i > 0 && args[i - 1].equals("-cp")) {
                this.logger.debug(methodName, this.sset.getId(), new Object[]{"Instance", this.numeric_id, "Args[", i, "]: <CLASSPATH>"});
                continue;
            }
            this.logger.debug(methodName, this.sset.getId(), new Object[]{"Instance", this.numeric_id, "Args[", i, "]:", args[i]});
        }
        ProcessBuilder pb = new ProcessBuilder(args);
        Map<String, String> env = pb.environment();
        env.put("DUCC_HOME", System.getProperty("DUCC_HOME"));
        ArrayList<String> stdout_lines = new ArrayList<String>();
        ArrayList<String> stderr_lines = new ArrayList<String>();
        int rc = 0;
        try {
            Process p = pb.start();
            rc = p.waitFor();
            this.logger.info(methodName, this.sset.getId(), new Object[]{"DuccServiceCancel returns with rc", rc});
            if (this.logger.isTrace() || rc != 0) {
                InputStream stdout = p.getInputStream();
                InputStream stderr = p.getErrorStream();
                BufferedReader stdout_reader = new BufferedReader(new InputStreamReader(stdout));
                BufferedReader stderr_reader = new BufferedReader(new InputStreamReader(stderr));
                String line = null;
                while ((line = stdout_reader.readLine()) != null) {
                    stdout_lines.add(line);
                }
                line = null;
                while ((line = stderr_reader.readLine()) != null) {
                    stderr_lines.add(line);
                }
            }
        }
        catch (Throwable t) {
            this.logger.error(methodName, null, t, new Object[0]);
        }
        if (this.logger.isTrace() || rc != 0) {
            boolean inhibit_cp = false;
            for (String s : stdout_lines) {
                if (inhibit_cp) {
                    inhibit_cp = false;
                    this.logger.info(methodName, this.sset.getId(), new Object[]{"Instance", this.numeric_id, "<INHIBITED CP>"});
                } else {
                    this.logger.info(methodName, this.sset.getId(), new Object[]{"Instance", this.numeric_id, "Stop stdout:", s});
                }
                if (s.indexOf("-cp") < 0) continue;
                inhibit_cp = true;
            }
            for (String s : stderr_lines) {
                this.logger.info(methodName, this.sset.getId(), new Object[]{"Instance", this.numeric_id, "Stop stderr:", s});
            }
        }
    }
}

