/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.rm.scheduler;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.persistence.rm.IDbShare;
import org.apache.uima.ducc.common.persistence.rm.IRmPersistence;
import org.apache.uima.ducc.common.persistence.rm.RmPersistenceFactory;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.rm.scheduler.IRmJob;
import org.apache.uima.ducc.rm.scheduler.Machine;
import org.apache.uima.ducc.rm.scheduler.NodePool;
import org.apache.uima.ducc.rm.scheduler.SchedConstants;
import org.apache.uima.ducc.rm.scheduler.Scheduler;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.transport.event.common.ITimeWindow;
import org.apache.uima.ducc.transport.event.common.TimeWindow;

public class Share
implements SchedConstants,
IDbShare {
    private transient DuccLogger logger = DuccLogger.getLogger(Share.class, (String)"RM");
    private transient Machine machine;
    private DuccId id = null;
    private transient IRmJob job = null;
    private DuccId bljobid = null;
    private int share_order;
    private ITimeWindow init_time = null;
    private boolean evicted = false;
    private boolean purged = false;
    private boolean fixed = false;
    private long investment = 0L;
    private IRmPersistence persistence = null;
    private long resident_memory = 0L;
    private IProcessState.ProcessState state = IProcessState.ProcessState.Undefined;
    private String pid = "<none>";

    Map<String, Object> getShareProperties() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("numeric_id", this.id.getFriendly());
        ret.put("uuid", this.id.getUnique());
        ret.put("share_order", this.share_order);
        ret.put("init_time", this.init_time.getElapsedMillis());
        ret.put("evicted", this.evicted);
        ret.put("purged", this.purged);
        ret.put("fixed", this.fixed);
        ret.put("investment", this.investment);
        return ret;
    }

    public Share(DuccId id, Machine machine, IRmJob job, int share_order) {
        this.id = id;
        this.machine = machine;
        this.job = job;
        this.bljobid = null;
        this.share_order = share_order;
        this.persistence = RmPersistenceFactory.getInstance((String)this.getClass().getName(), (String)"RM");
    }

    public Share(DuccId id, Machine machine, DuccId jobid, int share_order) {
        this.id = id;
        this.machine = machine;
        this.job = null;
        this.bljobid = jobid;
        this.share_order = share_order;
        this.persistence = RmPersistenceFactory.getInstance((String)this.getClass().getName(), (String)"RM");
    }

    public Share(Machine machine, IRmJob job, int share_order) {
        this.machine = machine;
        this.id = Scheduler.newId();
        this.job = job;
        this.bljobid = null;
        this.share_order = share_order;
        this.persistence = RmPersistenceFactory.getInstance((String)this.getClass().getName(), (String)"RM");
    }

    public NodePool getNodepool() {
        return this.machine.getNodepool();
    }

    public int getNodepoolDepth() {
        return this.getNodepool().getDepth();
    }

    public String getNodepoolId() {
        return this.getNodepool().getId();
    }

    public IRmJob getJob() {
        return this.job;
    }

    public DuccId getId() {
        return this.id;
    }

    public boolean isBlacklisted() {
        return this.bljobid != null;
    }

    public DuccId getBlJobId() {
        return this.bljobid;
    }

    Machine getMachine() {
        return this.machine;
    }

    long getHostMemory() {
        if (this.machine != null) {
            return this.machine.getMemory();
        }
        return 0L;
    }

    boolean isPending() {
        return this.job.isPendingShare(this);
    }

    void reassignJob(IRmJob job) {
        this.job = job;
    }

    public NodeIdentity getNodeIdentity() {
        return this.machine.getNodeIdentity();
    }

    public Node getNode() {
        return this.machine.getNode();
    }

    public int getShareOrder() {
        return this.share_order;
    }

    void setShareOrder(int o) {
        this.share_order = o;
    }

    int getMachineOrder() {
        return this.machine.getShareOrder();
    }

    boolean isForceable() {
        if (this.evicted) {
            return false;
        }
        if (this.purged) {
            return false;
        }
        return !this.fixed;
    }

    boolean isPreemptable() {
        return this.isForceable() && this.job.countNShares() - this.job.countNSharesGiven() > 0;
    }

    public boolean update(DuccId jobid, long mem, long investment, IProcessState.ProcessState state, ITimeWindow init_time, String pid) {
        String methodName = "update";
        if (!jobid.equals((Object)this.job.getId())) {
            return false;
        }
        this.resident_memory = mem;
        this.investment = investment;
        this.state = state;
        this.pid = pid;
        this.init_time = init_time;
        try {
            long npid = -1L;
            if (pid != null) {
                npid = Long.parseLong(pid);
            }
            this.persistence.updateShare(this.getNode().getNodeIdentity().getName(), this.id, jobid, investment, state.toString(), this.getInitializationTime(), npid);
        }
        catch (Exception e) {
            this.logger.warn(methodName, this.job.getId(), new Object[]{"Cannot update share statistics in database for share", this.id, e});
        }
        return true;
    }

    long getInvestment() {
        return this.investment;
    }

    public long getInitializationTime() {
        if (this.init_time == null) {
            return 0L;
        }
        return this.init_time.getElapsedMillis();
    }

    public void setInitializationTime(long millis) {
        String methodName = "setInitializationTme";
        this.logger.info(methodName, null, new Object[]{"SET INIT TIME", "shareid", this.id, millis});
        this.init_time = new TimeWindow();
        this.init_time.setStartLong(0L);
        this.init_time.setEndLong(millis);
    }

    boolean isInitialized() {
        if (this.init_time == null) {
            return false;
        }
        return this.init_time.getEnd() != null;
    }

    public void setFixed() {
        String methodName = "setFixed";
        this.fixed = true;
        try {
            this.persistence.setFixed(this.getNode().getNodeIdentity().getName(), this.id, this.job.getId(), true);
        }
        catch (Exception e) {
            this.logger.warn(methodName, this.job.getId(), new Object[]{"Cannot update 'fixed' in database for share", this.id, e});
        }
    }

    public boolean isFixed() {
        return this.fixed;
    }

    void evict() {
        String methodName = "evicted";
        this.evicted = true;
        try {
            this.persistence.setEvicted(this.getNode().getNodeIdentity().getName(), this.id, this.job.getId(), true);
        }
        catch (Exception e) {
            this.logger.warn(methodName, this.job.getId(), new Object[]{"Cannot update 'evicted' in database for share", this.id, e});
        }
    }

    public boolean isEvicted() {
        return this.evicted || this.purged;
    }

    void purge() {
        String methodName = "purge";
        this.purged = true;
        try {
            this.persistence.setPurged(this.getNode().getNodeIdentity().getName(), this.id, this.job.getId(), true);
        }
        catch (Exception e) {
            this.logger.warn(methodName, this.job.getId(), new Object[]{"Cannot update 'purge bit' in database for share", this.id, e});
        }
    }

    public boolean isPurged() {
        return this.purged;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Share s = (Share)o;
        return this.id.equals((Object)s.getId());
    }

    public String toString() {
        return this.machine.getId() + "." + this.getId();
    }
}

