/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.rm.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.SystemPropertyResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.rm.scheduler.IEntity;
import org.apache.uima.ducc.rm.scheduler.IRmJob;
import org.apache.uima.ducc.rm.scheduler.Machine;
import org.apache.uima.ducc.rm.scheduler.NodePool;
import org.apache.uima.ducc.rm.scheduler.ResourceClass;
import org.apache.uima.ducc.rm.scheduler.SchedConstants;
import org.apache.uima.ducc.rm.scheduler.SchedulingException;
import org.apache.uima.ducc.rm.scheduler.Share;
import org.apache.uima.ducc.rm.scheduler.User;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;

public class RmJob
implements SchedConstants,
IRmJob {
    DuccLogger logger = DuccLogger.getLogger(RmJob.class, (String)"RM");
    static final int DEFAULT_NTHREADS = 4;
    protected DuccId id;
    protected IDuccTypes.DuccType ducc_type;
    protected String name;
    protected String resource_class_name;
    protected ResourceClass resource_class;
    protected int user_priority;
    protected int n_machines;
    protected int min_shares;
    protected int max_shares;
    protected boolean is_reservation = false;
    protected int threads;
    protected int memory;
    protected int nquestions;
    protected int nquestions_remaining;
    protected double time_per_item = Double.NaN;
    protected int share_order = 0;
    protected int share_cap = Integer.MAX_VALUE;
    protected int job_cap = 0;
    protected int pure_fair_share = 0;
    protected long submit_time;
    protected String username;
    protected User user;
    protected HashMap<Share, Share> assignedShares;
    protected HashMap<Share, Share> pendingShares;
    protected HashMap<Share, Share> pendingRemoves;
    protected HashMap<Share, Share> recoveredShares;
    protected int total_assigned = 0;
    Map<Machine, Map<Share, Share>> sharesByMachine = new HashMap<Machine, Map<Share, Share>>();
    Map<Machine, Machine> machineList = new HashMap<Machine, Machine>();
    int[] given_by_order;
    int[] wanted_by_order;
    protected boolean init_wait;
    protected boolean completed = false;
    protected int orchestrator_epoch;
    protected int rm_rate;
    protected int ducc_epoch;
    protected Properties jobprops;
    protected String refusalReason = null;
    private static Comparator<IEntity> apportionmentSorter = new ApportionmentSorterCl();

    protected RmJob() {
    }

    public RmJob(DuccId id) {
        this.id = id;
        this.orchestrator_epoch = SystemPropertyResolver.getIntProperty((String)"ducc.orchestrator.state.publish.rate", (int)10000);
        this.rm_rate = SystemPropertyResolver.getIntProperty((String)"ducc.rm.state.publish.ratio", (int)4);
        this.ducc_epoch = this.orchestrator_epoch * this.rm_rate;
    }

    @Override
    public void init() {
        this.assignedShares = new HashMap();
        this.pendingShares = new HashMap();
        this.pendingRemoves = new HashMap();
        this.recoveredShares = new HashMap();
        if (this.max_shares == 0) {
            this.max_shares = Integer.MAX_VALUE;
        }
    }

    @Override
    public DuccId getId() {
        return this.id;
    }

    public void setId(DuccId id) {
        this.id = id;
    }

    @Override
    public long getFriendlyId() {
        return this.id.getFriendly();
    }

    @Override
    public String getName() {
        return this.id.toString();
    }

    @Override
    public void setJobName(String name) {
        this.name = name;
    }

    @Override
    public void setReservation() {
        this.is_reservation = true;
    }

    @Override
    public boolean isReservation() {
        return this.is_reservation;
    }

    @Override
    public void markComplete() {
        this.completed = true;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public boolean setInitWait(boolean is_running) {
        boolean resched = this.init_wait & is_running;
        this.init_wait = !is_running;
        return resched;
    }

    @Override
    public void setResourceClass(ResourceClass cl) {
        this.resource_class = cl;
    }

    @Override
    public int nQuestions() {
        return this.nquestions;
    }

    @Override
    public void setNQuestions(int allq, int remainingq, double time_per_item) {
        this.nquestions = allq;
        this.nquestions_remaining = remainingq;
        this.time_per_item = time_per_item;
    }

    @Override
    public int nQuestionsRemaining() {
        return this.nquestions_remaining;
    }

    @Override
    public Map<Machine, Map<Share, Share>> getSharesByMachine() {
        return this.sharesByMachine;
    }

    @Override
    public Map<Machine, Machine> getMachines() {
        return this.machineList;
    }

    @Override
    public int queryDemand() {
        if (this.getSchedulingPolicy() == SchedConstants.Policy.FAIR_SHARE) {
            return this.getJobCap();
        }
        return this.countInstances();
    }

    @Override
    public void clearShares() {
        this.given_by_order = null;
    }

    @Override
    public void setPureFairShare(int pfs) {
        this.pure_fair_share = pfs;
    }

    @Override
    public int getPureFairShare() {
        return this.pure_fair_share;
    }

    @Override
    public int[] getGivenByOrder() {
        return this.given_by_order;
    }

    @Override
    public void setGivenByOrder(int[] gbo) {
        this.given_by_order = gbo;
    }

    @Override
    public int getShareWeight() {
        return 1;
    }

    @Override
    public void initWantedByOrder(ResourceClass unused) {
        this.wanted_by_order = NodePool.makeArray();
        this.wanted_by_order[this.share_order] = this.getJobCap();
        this.wanted_by_order[0] = this.wanted_by_order[this.share_order];
    }

    @Override
    public int[] getWantedByOrder() {
        return this.wanted_by_order;
    }

    @Override
    public int calculateCap(int order, int total) {
        return Integer.MAX_VALUE;
    }

    @Override
    public int countNSharesGiven() {
        if (this.given_by_order == null) {
            return 0;
        }
        return this.given_by_order[this.share_order];
    }

    @Override
    public int countQSharesGiven() {
        return this.countNSharesGiven() * this.share_order;
    }

    @Override
    public int countNSharesLost() {
        return this.countNShares() - this.countNSharesGiven();
    }

    @Override
    public HashMap<Share, Share> getAssignedShares() {
        return this.assignedShares;
    }

    @Override
    public HashMap<Share, Share> getRecoveredShares() {
        return this.recoveredShares;
    }

    @Override
    public HashMap<Share, Share> getPendingShares() {
        return this.pendingShares;
    }

    @Override
    public HashMap<Share, Share> promoteShares() {
        HashMap<Share, Share> answer = new HashMap<Share, Share>();
        for (Share s : this.pendingShares.values()) {
            this.assignedShares.put(s, s);
            Machine m = s.getMachine();
            this.machineList.put(m, m);
            Map<Share, Share> machine_shares = this.sharesByMachine.get(m);
            if (machine_shares == null) {
                machine_shares = new HashMap<Share, Share>();
                this.sharesByMachine.put(m, machine_shares);
            }
            machine_shares.put(s, s);
            answer.put(s, s);
        }
        this.pendingShares.clear();
        return answer;
    }

    @Override
    public void cancelPending(Share s) {
        this.pendingShares.remove(s);
    }

    @Override
    public void assignShare(Share s) {
        this.pendingShares.put(s, s);
        ++this.total_assigned;
    }

    @Override
    public int countTotalAssignments() {
        return this.total_assigned;
    }

    @Override
    public void recoverShare(Share s) {
        if (!this.assignedShares.containsKey(s) && !this.pendingShares.containsKey(s)) {
            this.recoveredShares.put(s, s);
        }
    }

    @Override
    public boolean isPendingShare(Share s) {
        return this.pendingShares.containsKey(s);
    }

    @Override
    public boolean isExpanded() {
        return this.pendingShares.size() > 0;
    }

    @Override
    public boolean isShrunken() {
        return this.pendingRemoves.size() > 0;
    }

    @Override
    public boolean isStable() {
        return this.assignedShares.size() > 0 && this.pendingShares.size() == 0 && this.pendingRemoves.size() == 0;
    }

    @Override
    public boolean isDormant() {
        return this.assignedShares.size() == 0 && this.pendingShares.size() == 0 && this.pendingRemoves.size() == 0;
    }

    @Override
    public void removeAllShares() {
        String methodName = "removeAllShares";
        if (this.logger.isTrace()) {
            for (Map<Share, Share> m : this.sharesByMachine.values()) {
                for (Share s : m.values()) {
                    this.logger.trace(methodName, this.getId(), new Object[]{"Clear share", s});
                }
            }
        }
        this.assignedShares.clear();
        this.pendingShares.clear();
        this.pendingRemoves.clear();
        this.machineList.clear();
        this.sharesByMachine.clear();
    }

    @Override
    public void removeShare(Share share) {
        String methodName = "removeShare";
        if (this.assignedShares.containsKey(share)) {
            int prev = this.assignedShares.size();
            this.assignedShares.remove(share);
            this.pendingRemoves.remove(share);
            Machine m = share.getMachine();
            Map<Share, Share> machineShares = this.sharesByMachine.get(m);
            machineShares.remove(share);
            if (machineShares.size() == 0) {
                this.sharesByMachine.remove(m);
                this.machineList.remove(m);
            }
            this.logger.debug(methodName, this.getId(), new Object[]{"Job removes ", share.toString(), " reduces from ", prev, " to ", this.assignedShares.size() + "."});
        } else {
            this.logger.warn(methodName, this.getId(), new Object[]{"****** Job cannot find share " + share.toString() + " to remove. ******"});
        }
    }

    @Override
    public void shrinkByOne(Share share) {
        String methodName = "shrinkByOne";
        if (this.assignedShares.containsKey(share)) {
            this.logger.debug(methodName, this.getId(), new Object[]{"Job schedules " + share.toString() + " for removal."});
            this.pendingRemoves.put(share, share);
            share.evict();
        } else {
            this.logger.warn(methodName, this.getId(), new Object[]{"****** Job cannot find share " + share.toString() + " to schedule for removal.******"});
        }
    }

    @Override
    public int shrinkByOrderByMachine(int shares, int order, boolean force, NodePool nodepool) {
        String methodName = "shrinkByOrderByMachine";
        if (shares <= 0) {
            throw new SchedulingException(this.getId(), "Trying to shrink by " + shares + " shares.");
        }
        ArrayList<Machine> machinesSorted = new ArrayList<Machine>();
        for (Machine m : this.machineList.values()) {
            if (m.getNodepool() != nodepool || m.getShareOrder() < order) continue;
            machinesSorted.add(m);
        }
        Collections.sort(machinesSorted, new MachineByOrderSorter());
        int given = 0;
        int shares_to_lose = 0;
        shares_to_lose = force ? this.countNShares() : Math.max(0, this.countNShares() - this.countNSharesGiven());
        if (shares_to_lose == 0) {
            return 0;
        }
        for (Machine m : machinesSorted) {
            this.logger.debug(methodName, this.getId(), new Object[]{"Inspecting machine", m.getId()});
            ArrayList<Share> slist = new ArrayList<Share>();
            for (Share s : this.sharesByMachine.get(m).values()) {
                if (s.isEvicted()) continue;
                slist.add(s);
            }
            if (slist.size() == 0) continue;
            int to_give = m.countFreedUpShares();
            this.logger.debug(methodName, this.getId(), new Object[]{"A given:", given, "to_give:", to_give, "order", order, "shares", shares, "shares_to_lose", shares_to_lose});
            Iterator iter = slist.iterator();
            while (iter.hasNext() && given + to_give / order < shares && shares_to_lose > 0) {
                Share s = (Share)iter.next();
                this.logger.info(methodName, this.getId(), new Object[]{"Removing share", s.toString()});
                this.pendingRemoves.put(s, s);
                s.evict();
                to_give += this.share_order;
                --shares_to_lose;
            }
            if ((given += to_give / order) < shares) continue;
            break;
        }
        return given;
    }

    @Override
    public int shrinkByInvestment(int shares, int order, boolean force, NodePool nodepool) {
        String methodName = "shrinkByInvestment";
        if (shares <= 0) {
            throw new SchedulingException(this.getId(), "Trying to shrink by " + shares + " shares.");
        }
        this.logger.debug(methodName, this.getId(), new Object[]{"Enter: shares", shares, "order", order, "force", force, "nodepool", nodepool.getId(), "nAssignedShares", this.assignedShares.size(), "nPendingShares", this.pendingShares.size()});
        ArrayList<Share> sharesSorted = new ArrayList<Share>();
        for (Share s : this.assignedShares.values()) {
            if (s.getNodepoolId().equals(nodepool.getId()) && !s.isEvicted()) {
                sharesSorted.add(s);
                continue;
            }
            if (!this.logger.isTrace()) continue;
            this.logger.trace(methodName, this.getId(), new Object[]{"Skipping", s.getId(), "s.nodepool", s.getNodepoolId(), "incoming.nodepool", nodepool.getId(), "evicted", s.isEvicted()});
        }
        if (sharesSorted.size() == 0) {
            return 0;
        }
        if (this.logger.isTrace()) {
            this.logger.trace(methodName, this.getId(), new Object[]{"Shares Before Sort - id, isInitialized, investment:"});
            for (Share s : sharesSorted) {
                this.logger.trace(methodName, this.getId(), s.getId(), new Object[]{s.isInitialized(), s.getInvestment()});
            }
        }
        Collections.sort(sharesSorted, new ShareByInvestmentSorter());
        if (this.logger.isTrace()) {
            this.logger.trace(methodName, this.getId(), new Object[]{"Shares After Sort - id, isInitialized, investment:"});
            for (Share s : sharesSorted) {
                this.logger.trace(methodName, this.getId(), s.getId(), new Object[]{s.isInitialized(), s.getInvestment()});
            }
        }
        int shares_given = 0;
        int processes_to_lose = 0;
        int processes_given = 0;
        processes_to_lose = force ? this.countNShares() : Math.max(0, this.countNShares() - this.countNSharesGiven());
        if ((processes_to_lose = Math.min(processes_to_lose, sharesSorted.size())) == 0) {
            return 0;
        }
        while (shares_given < shares && processes_given < processes_to_lose) {
            int currently_given = 0;
            if (this.logger.isTrace()) {
                this.logger.trace(methodName, this.getId(), new Object[]{"In loop: Shares given", shares_given, "shares wanted", shares, "processes_to_lose", processes_to_lose, "processes_given", processes_given});
            }
            Share s = (Share)sharesSorted.get(0);
            Machine m = s.getMachine();
            int to_give = m.countFreedUpShares();
            this.logger.debug(methodName, this.getId(), new Object[]{"Inspecting share", s.getId()});
            ArrayList<Share> slist = new ArrayList<Share>();
            Iterator iter = sharesSorted.iterator();
            while (to_give < order && iter.hasNext()) {
                Share ss = (Share)iter.next();
                if (ss.getMachine() != s.getMachine()) continue;
                slist.add(ss);
                to_give += ss.getShareOrder();
            }
            if (to_give >= order) {
                for (Share ss : slist) {
                    this.logger.info(methodName, this.getId(), new Object[]{"Removing share", ss.toString()});
                    this.pendingRemoves.put(ss, ss);
                    ss.evict();
                    sharesSorted.remove(ss);
                    ++currently_given;
                    if (++processes_given < processes_to_lose) continue;
                    break;
                }
                shares_given += to_give / order;
            }
            if (currently_given != 0) continue;
            this.logger.debug(methodName, this.getId(), new Object[]{"Gave no shares, breaking loop"});
            break;
        }
        return shares_given;
    }

    public void shrinkTo(int k) {
    }

    public boolean isShrunk() {
        return this.pendingRemoves.size() > 0;
    }

    @Override
    public HashMap<Share, Share> getPendingRemoves() {
        return this.pendingRemoves;
    }

    @Override
    public void clearPendingRemoves() {
        this.pendingRemoves.clear();
    }

    @Override
    public void clearRecoveredShares() {
        this.recoveredShares.clear();
    }

    @Override
    public int countNShares() {
        return this.assignedShares.size() + this.pendingShares.size() - this.pendingRemoves.size();
    }

    @Override
    public void refuse(String refusal) {
        String methodName = "refusal";
        this.logger.warn(methodName, this.id, new Object[]{refusal});
        this.refusalReason = refusal;
    }

    @Override
    public boolean isRefused() {
        return this.refusalReason != null;
    }

    @Override
    public String getRefusalReason() {
        return this.refusalReason;
    }

    @Override
    public void setShareOrder(int s) {
        this.share_order = s;
    }

    @Override
    public int getShareOrder() {
        return this.share_order;
    }

    public void setShareCap(int cap) {
        this.share_cap = cap;
    }

    public int getShareCap() {
        return this.share_cap;
    }

    private int getProjectedCap() {
        String methodName = "getPrjCap";
        if (this.init_wait || Double.isNaN(this.time_per_item) || this.time_per_item == 0.0) {
            this.logger.info(methodName, this.getId(), new Object[]{this.username, "Cannot predict cap: init_wait", this.init_wait, "|| time_per_item", this.time_per_item});
            return Integer.MAX_VALUE;
        }
        int count = 0;
        long initialization_time = 0L;
        for (Share s : this.assignedShares.values()) {
            long t = s.getInitializationTime();
            if (!s.isInitialized() || t <= 0L) continue;
            ++count;
            initialization_time += t;
        }
        if (initialization_time > 0L) {
            initialization_time /= (long)count;
        } else {
            this.logger.warn(methodName, this.getId(), new Object[]{this.username, "Initialization time is 0, project cap and investment will be inaccurate."});
        }
        long target = initialization_time + (long)this.ducc_epoch + this.resource_class.getPredictionFudge();
        int nprocesses = this.countNShares();
        double rate = (double)(nprocesses * this.threads) / this.time_per_item;
        long projected = Math.round((double)target * rate);
        long future = Math.max((long)this.nquestions_remaining - projected, 0L);
        int answer = 0;
        answer = (int)future / this.threads;
        if (future % (long)this.threads > 0L) {
            ++answer;
        }
        if (answer == 0) {
            answer = this.countNShares();
        }
        this.logger.info(methodName, this.getId(), new Object[]{this.username, "O", this.getShareOrder(), "T", target, "NTh", nprocesses * this.threads, "TI", initialization_time, "TR", this.time_per_item, "R", String.format("%.4e", rate), "QR", this.nquestions_remaining, "P", projected, "F", future, "ST", this.submit_time, "return", answer});
        return answer;
    }

    @Override
    public void initJobCap() {
        int projected_cap;
        String methodName = "initJobCap";
        if (this.isRefused()) {
            this.job_cap = 0;
            return;
        }
        if (this.getSchedulingPolicy() != SchedConstants.Policy.FAIR_SHARE) {
            return;
        }
        int c = this.nquestions_remaining / this.threads;
        if (this.nquestions_remaining % this.threads > 0) {
            ++c;
        }
        int currentResources = this.countNShares();
        c = Math.max(c, currentResources);
        int base_cap = Math.min(this.getMaxShares(), c);
        if (base_cap < 0) {
            base_cap = 0;
        }
        if ((projected_cap = this.getProjectedCap()) == 0) {
            projected_cap = base_cap;
        }
        int potential_cap = base_cap;
        int actual_cap = 0;
        if (this.resource_class.isUsePrediction() && projected_cap < base_cap) {
            potential_cap = Math.max(projected_cap, currentResources);
        }
        if (this.init_wait && this.resource_class.getInitializationCap() > 0) {
            actual_cap = Math.min(potential_cap, this.resource_class.getInitializationCap());
        } else if (this.init_wait) {
            actual_cap = potential_cap;
        } else if (this.resource_class.isExpandByDoubling()) {
            if (currentResources == 0) {
                actual_cap = Math.max(1, this.resource_class.getInitializationCap());
                actual_cap = Math.min(base_cap, actual_cap);
            } else {
                actual_cap = Math.min(potential_cap, currentResources * 2);
            }
        } else {
            actual_cap = potential_cap;
        }
        this.logger.info(methodName, this.getId(), new Object[]{this.username, "O", this.getShareOrder(), "Base cap:", base_cap, "Expected future cap:", projected_cap, "potential cap", potential_cap, "actual cap", actual_cap});
        this.job_cap = actual_cap;
    }

    @Override
    public int getJobCap() {
        return this.job_cap;
    }

    @Override
    public int getMaxShares() {
        if (this.max_shares < 0) {
            return this.countNShares();
        }
        return this.max_shares;
    }

    @Override
    public int getMinShares() {
        return this.min_shares;
    }

    @Override
    public void setMaxShares(int s) {
        this.max_shares = s;
    }

    @Override
    public void setMinShares(int s) {
        this.min_shares = s;
    }

    public boolean isRunning() {
        return this.countNShares() > 0;
    }

    @Override
    public String getUserName() {
        return this.username;
    }

    @Override
    public void setUserName(String n) {
        this.username = n;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public void setUser(User u) {
        this.user = u;
    }

    @Override
    public long getTimestamp() {
        return this.submit_time;
    }

    @Override
    public void setTimestamp(long t) {
        this.submit_time = t;
    }

    @Override
    public int getUserPriority() {
        return this.user_priority;
    }

    @Override
    public void setUserPriority(int p) {
        this.user_priority = p;
    }

    @Override
    public String getClassName() {
        return this.resource_class_name;
    }

    @Override
    public void setClassName(String class_name) {
        this.resource_class_name = class_name;
    }

    @Override
    public int getSchedulingPriority() {
        return this.resource_class.getPriority();
    }

    @Override
    public SchedConstants.Policy getSchedulingPolicy() {
        return this.resource_class.getPolicy();
    }

    @Override
    public ResourceClass getResourceClass() {
        return this.resource_class;
    }

    @Override
    public int countInstances() {
        return this.n_machines;
    }

    @Override
    public void setNInstances(int m) {
        this.n_machines = m;
    }

    public int getMaxMachines() {
        return this.min_shares;
    }

    @Override
    public int nThreads() {
        return this.threads;
    }

    @Override
    public void setThreads(int th) {
        this.threads = th;
    }

    @Override
    public int getMemory() {
        return this.memory;
    }

    @Override
    public void setMemory(int memory) {
        this.memory = memory;
    }

    @Override
    public void setDuccType(IDuccTypes.DuccType type) {
        this.ducc_type = type;
    }

    @Override
    public IDuccTypes.DuccType getDuccType() {
        return this.ducc_type;
    }

    @Override
    public boolean isInitialized() {
        for (Share s : this.assignedShares.values()) {
            if (!s.isInitialized()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String printShares() {
        StringBuffer buf = new StringBuffer("AssignedShares: ");
        if (this.assignedShares.size() == 0) {
            buf.append("<none>");
        } else {
            for (Share s : this.assignedShares.values()) {
                buf.append(s.getId());
                buf.append(" ");
            }
        }
        buf.append("\nPendingShares: ");
        if (this.pendingShares.size() == 0) {
            buf.append("<none>");
        } else {
            for (Share s : this.pendingShares.values()) {
                buf.append(s.getId());
                buf.append(" ");
            }
        }
        buf.append("\nPendingRemoves: ");
        if (this.pendingRemoves.size() == 0) {
            buf.append("<none>");
        } else {
            for (Share s : this.pendingRemoves.values()) {
                buf.append(s.getId());
                buf.append(" ");
            }
        }
        return buf.toString();
    }

    String getShortType() {
        String st = "?";
        switch (this.ducc_type) {
            case Reservation: {
                st = "R";
                break;
            }
            case Job: {
                st = "J";
                break;
            }
            case Service: {
                st = "S";
            }
        }
        return st;
    }

    public static String getHeader() {
        return String.format("%11s %30s %10s %10s %6s %5s %7s %3s %6s %6s %8s %8s %9s", "ID", "JobName", "User", "Class", "Shares", "Order", "QShares", "NTh", "Memory", "nQuest", "Ques Rem", "InitWait", "Max P/Nst");
    }

    public String toString() {
        int shares = this.assignedShares.size() + this.pendingShares.size();
        String format = "%11s %30.30s %10s %10s %6d %5d %7d %3d %6d %6d %8d %8s %9d";
        String jid = String.format("%1s%10s", this.getShortType(), this.id.toString()).replace(' ', '_');
        if (this.isReservation()) {
            return String.format(format, jid, this.name.replace(' ', '_'), this.username, this.getClassName(), shares, this.share_order, shares * this.share_order, 0, this.memory, 0, 0, 0, this.n_machines);
        }
        return String.format(format, jid, this.name.replace(' ', '_'), this.username, this.getClassName(), shares, this.share_order, shares * this.share_order, this.threads, this.memory, this.nQuestions(), this.nQuestionsRemaining(), this.init_wait, this.max_shares);
    }

    public String toStringWithHeader() {
        StringBuilder buf = new StringBuilder(RmJob.getHeader());
        buf.append("\n");
        buf.append(this.toString());
        return buf.toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IRmJob other = (IRmJob)obj;
        if (!this.id.equals((Object)other.getId())) {
            return false;
        }
        return this.assignedShares.equals(other.getAssignedShares());
    }

    @Override
    public Comparator<IEntity> getApportionmentSorter() {
        return apportionmentSorter;
    }

    private static class ApportionmentSorterCl
    implements Comparator<IEntity> {
        private ApportionmentSorterCl() {
        }

        @Override
        public int compare(IEntity e1, IEntity e2) {
            if (e1.equals(e2)) {
                return 0;
            }
            return (int)(e1.getTimestamp() - e2.getTimestamp());
        }
    }

    public static class ShareByInvestmentSorter
    implements Comparator<Share> {
        @Override
        public int compare(Share s1, Share s2) {
            if (s1.equals(s2)) {
                return 0;
            }
            int mask = 0;
            if (s1.isInitialized()) {
                mask |= 2;
            }
            if (s2.isInitialized()) {
                mask |= 1;
            }
            switch (mask) {
                case 0: {
                    return (int)(s1.getInitializationTime() - s2.getInitializationTime());
                }
                case 1: {
                    return -1;
                }
                case 2: {
                    return 1;
                }
            }
            long i1 = s1.getInvestment();
            long i2 = s2.getInvestment();
            if (i1 == i2) {
                return (int)(s2.getId().getFriendly() - s1.getId().getFriendly());
            }
            return (int)(i1 - i2);
        }
    }

    class MachineByOrderSorter
    implements Comparator<Machine> {
        MachineByOrderSorter() {
        }

        @Override
        public int compare(Machine m1, Machine m2) {
            if (m1.equals(m2)) {
                return 0;
            }
            return m2.getShareOrder() - m1.getShareOrder();
        }
    }
}

