/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.rm.scheduler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.rm.scheduler.IRmJob;
import org.apache.uima.ducc.rm.scheduler.Machine;
import org.apache.uima.ducc.rm.scheduler.ResourceClass;
import org.apache.uima.ducc.rm.scheduler.SchedConstants;
import org.apache.uima.ducc.rm.scheduler.SchedInternalError;
import org.apache.uima.ducc.rm.scheduler.Share;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;

class NodePool
implements SchedConstants {
    DuccLogger logger = DuccLogger.getLogger(NodePool.class, (String)"RM");
    String id;
    NodePool parent = null;
    int depth;
    int updated = 0;
    int order = 100;
    SchedConstants.EvictionPolicy evictionPolicy = SchedConstants.EvictionPolicy.SHRINK_BY_MACHINE;
    HashMap<String, NodePool> children = new HashMap();
    Map<String, String> subpoolNames = new HashMap<String, String>();
    HashMap<Node, Machine> allMachines = new HashMap();
    HashMap<Node, Machine> unresponsiveMachines = new HashMap();
    HashMap<Node, Machine> offlineMachines = new HashMap();
    HashMap<Integer, HashMap<Node, Machine>> machinesByOrder = new HashMap();
    HashMap<String, Machine> machinesByName = new HashMap();
    HashMap<String, Machine> machinesByIp = new HashMap();
    HashMap<Share, Share> allShares = new HashMap();
    HashMap<Node, Machine> preemptables = new HashMap();
    int total_shares = 0;
    int[] nMachinesByOrder;
    int[] vMachinesByOrder;
    int[] nSharesByOrder;
    int[] machinesToPreempt;
    int[] nPendingByOrder;
    Map<Integer, Integer> onlineMachinesByOrder = new HashMap<Integer, Integer>();
    HashMap<Integer, HashMap<Node, Machine>> virtualMachinesByOrder;
    static int maxorder = 0;

    NodePool(NodePool parent, String id, Map<String, String> nodes, SchedConstants.EvictionPolicy ep, int depth, int order) {
        String methodName = "NodePool.<init>";
        this.parent = parent;
        this.id = id;
        this.subpoolNames = nodes;
        if (nodes == null) {
            this.subpoolNames = new HashMap<String, String>();
            this.logger.warn(methodName, null, new Object[]{"Nodepool", id, ": no nodes in node list"});
        }
        this.evictionPolicy = ep;
        this.depth = depth;
        this.order = order;
    }

    NodePool getParent() {
        return this.parent;
    }

    String getId() {
        return this.id;
    }

    int getDepth() {
        return this.depth;
    }

    int countShares() {
        return this.allShares.size();
    }

    int countOccupiedShares() {
        int count = this.allShares.size();
        for (NodePool np : this.children.values()) {
            count += np.countOccupiedShares();
        }
        return count;
    }

    void removeShare(Share s) {
        this.allShares.remove(s);
    }

    boolean containsPoolNode(Node n) {
        if (this.subpoolNames.containsKey(n.getNodeIdentity().getIp())) {
            return true;
        }
        return this.subpoolNames.containsKey(n.getNodeIdentity().getName());
    }

    int countMachines() {
        int count = this.allMachines.size();
        for (NodePool np : this.children.values()) {
            count += np.countMachines();
        }
        return count;
    }

    int countUnresponsiveMachines() {
        int count = this.unresponsiveMachines.size();
        for (NodePool np : this.children.values()) {
            count += np.countUnresponsiveMachines();
        }
        return count;
    }

    int countOfflineMachines() {
        int count = this.offlineMachines.size();
        for (NodePool np : this.children.values()) {
            count += np.countOfflineMachines();
        }
        return count;
    }

    int countLocalMachines() {
        return this.allMachines.size();
    }

    int countLocalShares() {
        return this.total_shares;
    }

    int countFreeMachines(int order, boolean enforce) {
        int cnt = 0;
        HashMap<Node, Machine> mlist = null;
        mlist = enforce ? this.machinesByOrder.get(order) : this.allMachines;
        if (mlist == null) {
            return 0;
        }
        for (Machine m : mlist.values()) {
            if (!m.isFree()) continue;
            ++cnt;
        }
        return cnt;
    }

    int countAllFreeMachines() {
        int count = this.countFreeMachines(0, false);
        for (NodePool np : this.children.values()) {
            count += np.countAllFreeMachines();
        }
        return count;
    }

    int countTotalShares() {
        int answer = this.total_shares;
        for (NodePool np : this.children.values()) {
            answer += np.countTotalShares();
        }
        return answer;
    }

    int countQShares() {
        int count = this.nSharesByOrder[1];
        for (NodePool np : this.children.values()) {
            count += np.countQShares();
        }
        return count;
    }

    int countAllMachinesByOrder(int o) {
        int count = 0;
        if (this.machinesByOrder.containsKey(o)) {
            count = this.machinesByOrder.get(o).size();
        }
        for (NodePool np : this.children.values()) {
            count += np.countAllMachinesByOrder(o);
        }
        return count;
    }

    int countNSharesByOrder(int o) {
        int count = this.nSharesByOrder[o];
        for (NodePool np : this.children.values()) {
            count += np.countNSharesByOrder(o);
        }
        return count;
    }

    int countPendingSharesByOrder(int o) {
        int count = this.nPendingByOrder[o];
        for (NodePool np : this.children.values()) {
            count += np.countPendingSharesByOrder(o);
        }
        return count;
    }

    int[] cloneNSharesByOrder() {
        int[] cln = (int[])this.nSharesByOrder.clone();
        for (NodePool np : this.children.values()) {
            int[] subcln = np.cloneNSharesByOrder();
            for (int i = 0; i < cln.length; ++i) {
                int n = i;
                cln[n] = cln[n] + subcln[i];
            }
        }
        return cln;
    }

    int[] cloneVMachinesByOrder() {
        int[] cln = (int[])this.nMachinesByOrder.clone();
        for (int i = 0; i < cln.length; ++i) {
            int n = i;
            cln[n] = cln[n] + this.vMachinesByOrder[i];
        }
        for (NodePool np : this.children.values()) {
            int[] subcln = np.cloneVMachinesByOrder();
            for (int i = 0; i < cln.length; ++i) {
                int n = i;
                cln[n] = cln[n] + subcln[i];
            }
        }
        return cln;
    }

    public static int getMaxOrder() {
        return maxorder;
    }

    public static int[] makeArray() {
        return new int[NodePool.getArraySize()];
    }

    public static int getArraySize() {
        return NodePool.getMaxOrder() + 1;
    }

    int getOrder() {
        return this.order;
    }

    public Machine getMachine(Node n) {
        Machine m;
        block1: {
            NodePool np;
            m = this.allMachines.get(n);
            if (m != null) break block1;
            Iterator<NodePool> i$ = this.children.values().iterator();
            while (i$.hasNext() && (m = (np = i$.next()).getMachine(n)) == null) {
            }
        }
        return m;
    }

    public Machine getMachine(NodeIdentity ni) {
        Machine m;
        block1: {
            NodePool np;
            m = this.machinesByIp.get(ni.getIp());
            if (m != null) break block1;
            Iterator<NodePool> i$ = this.children.values().iterator();
            while (i$.hasNext() && (m = (np = i$.next()).getMachine(ni)) == null) {
            }
        }
        return m;
    }

    boolean containsMachine(Machine m) {
        HashMap<Node, Machine> allm = this.getAllMachines();
        return allm.containsKey(m.getNode());
    }

    HashMap<Node, Machine> getAllMachinesForPool() {
        return (HashMap)this.allMachines.clone();
    }

    HashMap<Node, Machine> getAllMachines() {
        HashMap machs = (HashMap)this.allMachines.clone();
        for (NodePool np : this.children.values()) {
            HashMap<Node, Machine> m = np.getAllMachines();
            if (m == null) continue;
            machs.putAll(m);
        }
        return machs;
    }

    HashMap<String, Machine> getMachinesByName() {
        HashMap machs = (HashMap)this.machinesByName.clone();
        for (NodePool np : this.children.values()) {
            HashMap<String, Machine> m = np.getMachinesByName();
            if (m == null) continue;
            machs.putAll(m);
        }
        return machs;
    }

    HashMap<String, Machine> getMachinesByIp() {
        HashMap machs = (HashMap)this.machinesByIp.clone();
        for (NodePool np : this.children.values()) {
            HashMap<String, Machine> m = np.getMachinesByIp();
            if (m == null) continue;
            machs.putAll(m);
        }
        return machs;
    }

    HashMap<Node, Machine> getMachinesByOrder(int order) {
        HashMap machs = this.machinesByOrder.containsKey(order) ? (HashMap)this.machinesByOrder.get(order).clone() : new HashMap();
        for (NodePool np : this.children.values()) {
            HashMap<Node, Machine> m = np.getMachinesByOrder(order);
            machs.putAll(m);
        }
        return machs;
    }

    HashMap<Node, Machine> getVirtualMachinesByOrder(int order) {
        HashMap machs = this.virtualMachinesByOrder.containsKey(order) ? (HashMap)this.virtualMachinesByOrder.get(order).clone() : new HashMap();
        return machs;
    }

    protected void calcNSharesByOrder() {
        int len = this.nMachinesByOrder.length;
        System.arraycopy(this.nMachinesByOrder, 0, this.nSharesByOrder, 0, len);
        for (int i = 0; i < maxorder + 1; ++i) {
            int n = i;
            this.nSharesByOrder[n] = this.nSharesByOrder[n] + this.vMachinesByOrder[i];
        }
        for (int o = 1; o < len; ++o) {
            for (int p = o + 1; p < len; ++p) {
                if (this.nSharesByOrder[p] == 0) continue;
                int n = o;
                this.nSharesByOrder[n] = this.nSharesByOrder[n] + p / o * this.nSharesByOrder[p];
            }
        }
    }

    protected int[] countMachinesByOrder() {
        int[] ans = (int[])this.nMachinesByOrder.clone();
        for (NodePool np : this.children.values()) {
            int[] tmp = np.countMachinesByOrder();
            for (int i = 0; i < NodePool.getArraySize(); ++i) {
                int n = i;
                ans[n] = ans[n] + tmp[i];
            }
        }
        return ans;
    }

    protected int[] countVMachinesByOrder() {
        int[] ans = (int[])this.vMachinesByOrder.clone();
        for (NodePool np : this.children.values()) {
            int[] tmp = np.countVMachinesByOrder();
            for (int i = 0; i < NodePool.getArraySize(); ++i) {
                int n = i;
                ans[n] = ans[n] + tmp[i];
            }
        }
        return ans;
    }

    protected int[] countAllNSharesByOrder() {
        int[] ans = (int[])this.nSharesByOrder.clone();
        for (NodePool np : this.children.values()) {
            int[] tmp = np.countAllNSharesByOrder();
            for (int i = 0; i < NodePool.getArraySize(); ++i) {
                int n = i;
                ans[n] = ans[n] + tmp[i];
            }
        }
        return ans;
    }

    public synchronized void connectShare(Share s, Machine m, IRmJob j, int order) {
        String methodName = "connectShare";
        this.logger.trace(methodName, j.getId(), new Object[]{"share", s, "order", order, "machine", m});
        j.assignShare(s);
        m.assignShare(s);
        this.rearrangeVirtual(m, order);
        this.allShares.put(s, s);
    }

    void rearrangeVirtual(Machine m, int order) {
        if (this.allMachines.containsKey(m.key())) {
            int r_order;
            int v_order = m.getVirtualShareOrder();
            if (v_order == (r_order = m.getShareOrder())) {
                int n = r_order;
                this.nMachinesByOrder[n] = this.nMachinesByOrder[n] - 1;
            } else {
                int n = v_order;
                this.vMachinesByOrder[n] = this.vMachinesByOrder[n] - 1;
            }
            HashMap<Object, Machine> vlist = this.virtualMachinesByOrder.get(v_order);
            vlist.remove(m.key());
            m.setVirtualShareOrder(v_order -= order);
            if (v_order != 0) {
                vlist = this.virtualMachinesByOrder.get(v_order);
                if (vlist == null) {
                    vlist = new HashMap();
                    this.virtualMachinesByOrder.put(v_order, vlist);
                }
                vlist.put(m.key(), m);
                int n = v_order;
                this.vMachinesByOrder[n] = this.vMachinesByOrder[n] + 1;
            }
            this.calcNSharesByOrder();
        } else {
            for (NodePool np : this.children.values()) {
                np.rearrangeVirtual(m, order);
            }
        }
    }

    void accountForShares(HashMap<Share, Share> shares) {
        for (Share s : shares.values()) {
            int order = s.getShareOrder();
            Machine m = s.getMachine();
            this.rearrangeVirtual(m, order);
        }
    }

    void reset(int order) {
        String methodName = "reset";
        maxorder = Math.max(order, maxorder);
        this.nSharesByOrder = new int[maxorder + 1];
        this.nMachinesByOrder = new int[maxorder + 1];
        this.vMachinesByOrder = new int[maxorder + 1];
        this.nPendingByOrder = new int[maxorder + 1];
        this.machinesToPreempt = new int[maxorder + 1];
        this.virtualMachinesByOrder = new HashMap();
        for (Integer i : this.machinesByOrder.keySet()) {
            HashMap ml = (HashMap)this.machinesByOrder.get(i).clone();
            this.virtualMachinesByOrder.put(i, ml);
            this.nMachinesByOrder[i.intValue()] = ml.size();
        }
        this.calcNSharesByOrder();
        for (Machine m : this.allMachines.values()) {
            m.resetVirtualShareOrder();
        }
        for (NodePool np : this.children.values()) {
            np.reset(order);
        }
        if (this.parent == null && this.updated > 0) {
            this.logger.info(methodName, null, new Object[]{"Scheduling Tables:\n", this.toString()});
            this.updated = 0;
        }
    }

    void resetPreemptables() {
        this.preemptables.clear();
    }

    NodePool getSubpool(String name) {
        if (name.equals(this.id)) {
            return this;
        }
        for (NodePool np : this.children.values()) {
            if (np.getSubpool(name) == null) continue;
            return np;
        }
        return null;
    }

    boolean containsSubpool(NodePool np) {
        if (np == this) {
            return true;
        }
        for (NodePool cnp : this.children.values()) {
            if (!cnp.containsSubpool(np)) continue;
            return true;
        }
        return false;
    }

    HashMap<String, NodePool> getChildren() {
        return this.children;
    }

    List<NodePool> getChildrenAscending() {
        ArrayList<NodePool> sorted = new ArrayList<NodePool>();
        if (this.children.size() > 0) {
            sorted.addAll(this.children.values());
            Collections.sort(sorted, new NodepoolAscendingSorter());
        }
        return sorted;
    }

    List<NodePool> getChildrenDescending() {
        ArrayList<NodePool> sorted = new ArrayList<NodePool>();
        if (this.children.size() > 0) {
            sorted.addAll(this.children.values());
            Collections.sort(sorted, new NodepoolDescendingSorter());
        }
        return sorted;
    }

    NodePool createSubpool(String className, Map<String, String> names, int order) {
        NodePool np = new NodePool(this, className, names, this.evictionPolicy, this.depth + 1, order);
        this.children.put(className, np);
        return np;
    }

    private synchronized void incrementOnlineByOrder(int order) {
        if (!this.onlineMachinesByOrder.containsKey(order)) {
            this.onlineMachinesByOrder.put(order, 1);
        } else {
            this.onlineMachinesByOrder.put(order, this.onlineMachinesByOrder.get(order) + 1);
        }
    }

    private synchronized void decrementOnlineByOrder(int order) {
        this.onlineMachinesByOrder.put(order, this.onlineMachinesByOrder.get(order) - 1);
    }

    synchronized void getOnlineByOrder(int[] ret) {
        Iterator<Object> i$ = this.onlineMachinesByOrder.keySet().iterator();
        while (i$.hasNext()) {
            int o;
            int n = o = i$.next().intValue();
            ret[n] = ret[n] + this.onlineMachinesByOrder.get(o);
        }
        for (NodePool child : this.children.values()) {
            child.getOnlineByOrder(ret);
        }
    }

    Machine nodeArrives(Node node, int order) {
        HashMap<Object, Machine> mlist;
        Machine m;
        String methodName = "nodeArrives";
        maxorder = Math.max(order, maxorder);
        for (NodePool np : this.children.values()) {
            if (!np.containsPoolNode(node)) continue;
            Machine m2 = np.nodeArrives(node, order);
            return m2;
        }
        if (this.allMachines.containsKey(node)) {
            m = this.allMachines.get(node);
            this.logger.trace(methodName, null, new Object[]{"Node ", m.getId(), " is already known, not adding."});
            return m;
        }
        if (this.offlineMachines.containsKey(node)) {
            m = this.offlineMachines.get(node);
            this.logger.trace(methodName, null, new Object[]{"Node ", m.getId(), " is offline, not activating."});
            return m;
        }
        if (this.unresponsiveMachines.containsKey(node)) {
            m = this.unresponsiveMachines.remove(node);
            if (m.getShareOrder() != order) {
                m.setShareOrder(order);
            }
            this.allMachines.put(node, m);
            this.machinesByName.put(m.getId(), m);
            this.machinesByIp.put(m.getIp(), m);
            mlist = this.machinesByOrder.get(order);
            this.incrementOnlineByOrder(order);
            if (mlist == null) {
                mlist = new HashMap();
                this.machinesByOrder.put(order, mlist);
            }
            mlist.put(m.key(), m);
            this.total_shares += order;
            this.logger.info(methodName, null, new Object[]{"Nodepool:", this.id, "Host reactivated ", m.getId(), String.format("shares %2d total %4d:", order, this.total_shares), m.toString()});
            return m;
        }
        Machine machine = new Machine(node);
        machine.setShareOrder(order);
        this.allMachines.put(machine.key(), machine);
        this.machinesByName.put(machine.getId(), machine);
        this.machinesByIp.put(machine.getIp(), machine);
        this.incrementOnlineByOrder(order);
        machine.setNodepool(this);
        this.total_shares += order;
        mlist = this.machinesByOrder.get(order);
        if (mlist == null) {
            mlist = new HashMap();
            this.machinesByOrder.put(order, mlist);
        }
        mlist.put(machine.key(), machine);
        this.logger.info(methodName, null, new Object[]{"Nodepool:", this.id, "Host added:", this.id, ": ", machine.getId(), String.format("shares %2d total %4d:", order, this.total_shares), machine.toString()});
        ++this.updated;
        return machine;
    }

    void disable(Machine m, HashMap<Node, Machine> disableMap) {
        String methodName = "nodeLeaves";
        if (this.allMachines.containsKey(m.key())) {
            this.logger.info(methodName, null, new Object[]{"Nodepool:", this.id, "Host disabled:", m.getId(), "Looking for shares to clear"});
            int order = m.getShareOrder();
            String name = m.getId();
            String ip = m.getIp();
            HashMap<Share, Share> shares = m.getActiveShares();
            for (Share s : shares.values()) {
                IRmJob j = s.getJob();
                if (j.getDuccType() == IDuccTypes.DuccType.Reservation) {
                    this.logger.info(methodName, null, new Object[]{"Nodepool:", this.id, "Host dead/offline:", m.getId(), "Not purging", j.getDuccType()});
                    break;
                }
                this.logger.info(methodName, j.getId(), new Object[]{"Nodepool:", this.id, "Purge", j.getDuccType(), "on dead/offline:", m.getId()});
                j.shrinkByOne(s);
                int n = order;
                this.nPendingByOrder[n] = this.nPendingByOrder[n] + 1;
                s.purge();
            }
            this.allMachines.remove(m.key());
            this.decrementOnlineByOrder(order);
            this.total_shares -= order;
            disableMap.put(m.key(), m);
            HashMap<Node, Machine> machs = this.machinesByOrder.get(order);
            machs.remove(m.key());
            if (machs.size() == 0) {
                this.machinesByOrder.remove(order);
            }
            this.machinesByName.remove(name);
            this.machinesByIp.remove(ip);
            this.logger.info(methodName, null, new Object[]{"Nodepool:", this.id, "Node leaves:", m.getId(), "total shares:", this.total_shares});
        } else {
            for (NodePool np : this.children.values()) {
                np.nodeLeaves(m);
            }
        }
    }

    void nodeLeaves(Machine m) {
        this.disable(m, this.unresponsiveMachines);
    }

    String varyoff(String node) {
        Machine m = this.machinesByName.get(node);
        if (m == null) {
            for (Machine mm : this.offlineMachines.values()) {
                if (!mm.getId().equals(node)) continue;
                return "VaryOff: Nodepool " + this.id + " - Already offline: " + node;
            }
            Iterator<Machine> iter = this.unresponsiveMachines.values().iterator();
            while (iter.hasNext()) {
                Machine mm;
                mm = iter.next();
                if (!mm.getId().equals(node)) continue;
                Node key = mm.key();
                iter.remove();
                this.offlineMachines.put(key, mm);
                return "VaryOff: Nodepool " + this.id + " - Unresponsive machine, marked offline: " + node;
            }
            return "VaryOff: Nodepool " + this.id + " - Cannot find machine: " + node;
        }
        this.disable(m, this.offlineMachines);
        return "VaryOff: " + node + " - OK.";
    }

    String varyon(String node) {
        if (this.machinesByName.containsKey(node)) {
            return "VaryOn: Nodepool " + this.id + " - Already online: " + node;
        }
        Iterator<Machine> iter = this.offlineMachines.values().iterator();
        while (iter.hasNext()) {
            Machine mm = iter.next();
            if (!mm.getId().equals(node)) continue;
            iter.remove();
            return "VaryOn: Nodepool " + this.id + " - Machine marked online: " + node;
        }
        for (Machine mm : this.unresponsiveMachines.values()) {
            if (!mm.getId().equals(node)) continue;
            return "VaryOn: Nodepool " + this.id + " - Machine is online but not responsive: " + node;
        }
        return "VaryOn: Nodepool " + this.id + " - Cannot find machine: " + node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int countFreeableMachines(IRmJob j, boolean enforce) {
        int needed = j.countInstances();
        int order = j.getShareOrder();
        ArrayList<Machine> machs = new ArrayList<Machine>();
        if (enforce) {
            if (!this.machinesByOrder.containsKey(order)) return 0;
            machs.addAll(this.machinesByOrder.get(order).values());
        } else {
            machs.addAll(this.allMachines.values());
        }
        Collections.sort(machs, new MachineByAscendingOrderSorter());
        int given = 0;
        Iterator iter = machs.iterator();
        ArrayList<Machine> pables = new ArrayList<Machine>();
        while (iter.hasNext() && given < needed) {
            Machine m = (Machine)iter.next();
            if (this.preemptables.containsKey(m.key()) || m.getShareOrder() < order) continue;
            if (m.isFree()) {
                ++given;
                continue;
            }
            if (!m.isFreeable()) continue;
            ++given;
            pables.add(m);
        }
        if (given < needed) {
            return 0;
        }
        if (enforce) {
            this.machinesToPreempt[0] = this.machinesToPreempt[0] + this.preemptables.size();
        } else {
            int n = order;
            this.machinesToPreempt[n] = this.machinesToPreempt[n] + this.preemptables.size();
        }
        for (Machine m : pables) {
            this.preemptables.put(m.key(), m);
            int n = m.getShareOrder();
            this.nMachinesByOrder[n] = this.nMachinesByOrder[n] - 1;
        }
        this.calcNSharesByOrder();
        return given;
    }

    int countOutNSharesByOrder(int order, int nrequested) {
        int given = 0;
        int rem = 0;
        int low = order;
        while (given < nrequested && low <= maxorder) {
            int avail = this.vMachinesByOrder[low] + this.nMachinesByOrder[low];
            if (avail > 0) {
                if (this.vMachinesByOrder[low] > 0) {
                    int n = low;
                    this.vMachinesByOrder[n] = this.vMachinesByOrder[n] - 1;
                } else {
                    int n = low;
                    this.nMachinesByOrder[n] = this.nMachinesByOrder[n] - 1;
                }
                ++given;
                rem = low - order;
                if (rem <= 0) continue;
                int n = rem;
                this.vMachinesByOrder[n] = this.vMachinesByOrder[n] + 1;
                low = Math.max(rem, order);
                continue;
            }
            ++low;
        }
        int k = nrequested - given;
        if (k > 0) {
            Iterator<NodePool> iter = this.children.values().iterator();
            while (iter.hasNext() && k > 0) {
                NodePool np = iter.next();
                k = nrequested - (given += np.countOutNSharesByOrder(order, k));
            }
        }
        this.calcNSharesByOrder();
        return given;
    }

    protected ArrayList<Machine> sortedForReservation(HashMap<Node, Machine> machs) {
        ArrayList<Machine> answer = new ArrayList<Machine>();
        answer.addAll(machs.values());
        Collections.sort(answer, new ReservationSorter());
        return answer;
    }

    protected int setupPreemptions(int needed, int order, boolean enforce) {
        String methodName = "setupPreemptions";
        int given = 0;
        Iterator<Machine> iter = this.preemptables.values().iterator();
        while (iter.hasNext() && given < needed) {
            Machine m = iter.next();
            int o = m.getShareOrder();
            if (enforce && order != o) continue;
            HashMap<Share, Share> shares = m.getActiveShares();
            for (Share s : shares.values()) {
                if (s.isPreemptable()) {
                    IRmJob j = s.getJob();
                    j.shrinkByOne(s);
                    int n = order;
                    this.nPendingByOrder[n] = this.nPendingByOrder[n] + 1;
                    continue;
                }
                this.logger.warn(methodName, null, new Object[]{"Found non-preemptable share on machine that should be clearable (possible fragmentation):", s});
            }
            ++given;
            iter.remove();
        }
        return given;
    }

    void allocateForReservation(IRmJob job, ResourceClass rc) {
        ArrayList<Machine> machs;
        String methodName = "allocateForReservation";
        ArrayList<Machine> answer = new ArrayList<Machine>();
        int order = job.getShareOrder();
        int needed = job.countInstances();
        boolean enforce = rc.enforceMemory();
        int cnt = this.countFreeMachines(order, enforce);
        if (cnt < needed) {
            this.logger.info(methodName, job.getId(), new Object[]{"Reservation waiting on evictions"});
            this.setupPreemptions(needed - cnt, order, enforce);
            return;
        }
        if (enforce) {
            if (!this.machinesByOrder.containsKey(order)) {
                throw new SchedInternalError(job.getId(), "Scheduling counts are wrong - machinesByOrder does not match nMachinesByOrder");
            }
            machs = this.sortedForReservation(this.machinesByOrder.get(order));
        } else {
            machs = this.sortedForReservation(this.allMachines);
        }
        if (machs.size() < needed) {
            throw new SchedInternalError(job.getId(), "Scheduling counts are wrong - can't schedule reservation");
        }
        for (Machine m : machs) {
            if (m.isFree()) {
                answer.add(m);
                --needed;
            }
            if (needed != 0) continue;
            break;
        }
        if (needed == 0) {
            for (Machine mm : answer) {
                Share s = new Share(mm, job, mm.getShareOrder());
                s.setFixed();
                this.connectShare(s, mm, job, mm.getShareOrder());
            }
        } else {
            throw new SchedInternalError(job.getId(), "Thought we had enough machines for reservation, but we don't");
        }
    }

    ArrayList<Share> evacuateLargest(int order, ArrayList<Share> shares) {
        int found_order = 0;
        if (shares.size() == 1) {
            Share s = shares.get(0);
            if (s.isPreemptable() && s.getShareOrder() == order) {
                return shares;
            }
            return null;
        }
        ArrayList<Share> slist = new ArrayList<Share>();
        for (Share s : shares) {
            found_order = s.getShareOrder();
            if (s.isPreemptable() && found_order == order) {
                slist.add(s);
                return slist;
            }
            int new_order = order - found_order;
            ArrayList new_shares = (ArrayList)shares.clone();
            new_shares.remove(0);
            ArrayList<Share> found_shares = this.evacuateLargest(new_order, new_shares);
            if (!s.isPreemptable() || found_shares == null) continue;
            slist.add(s);
            slist.addAll(found_shares);
            return slist;
        }
        return null;
    }

    private void doEvictions(int[] neededByOrder, HashMap<Integer, HashMap<IRmJob, IRmJob>> candidates, boolean force) {
        for (int nbo = maxorder; nbo > 0; --nbo) {
            if (neededByOrder[nbo] == 0) continue;
            for (int oo = maxorder; oo > 0; --oo) {
                HashMap<IRmJob, IRmJob> jobs = candidates.get(oo);
                if (jobs == null) continue;
                Iterator<IRmJob> iter = jobs.values().iterator();
                while (iter.hasNext() && neededByOrder[nbo] > 0) {
                    IRmJob j = iter.next();
                    int loss = 0;
                    switch (this.evictionPolicy) {
                        case SHRINK_BY_MACHINE: {
                            loss = j.shrinkByOrderByMachine(neededByOrder[nbo], nbo, force, this);
                            break;
                        }
                        case SHRINK_BY_INVESTMENT: {
                            loss = j.shrinkByInvestment(neededByOrder[nbo], nbo, force, this);
                        }
                    }
                    int n = nbo;
                    neededByOrder[n] = neededByOrder[n] - loss;
                    neededByOrder[0] = neededByOrder[0] - loss;
                    int n2 = oo;
                    this.nPendingByOrder[n2] = this.nPendingByOrder[n2] + loss;
                    if (j.countNShares() != 0) continue;
                    iter.remove();
                }
            }
        }
    }

    void doEvictionsByMachine(int[] neededByOrder, boolean force) {
        String methodName = "doEvictions";
        String type = force ? "forced" : "natural";
        this.logger.debug(methodName, null, new Object[]{this.getId(), "NeededByOrder", type, "on entrance eviction", Arrays.toString(neededByOrder)});
        for (NodePool np : this.getChildrenDescending()) {
            np.doEvictionsByMachine(neededByOrder, force);
        }
        for (int nbo = maxorder; nbo > 0; --nbo) {
            int needed;
            neededByOrder[nbo] = needed = Math.max(0, neededByOrder[nbo] - this.countNSharesByOrder(nbo) - this.countPendingSharesByOrder(nbo));
            neededByOrder[0] = neededByOrder[0] + needed;
        }
        this.logger.debug(methodName, null, new Object[]{this.getId(), "NeededByOrder", type, "after adjustments for pending eviction:", Arrays.toString(neededByOrder)});
        HashMap<Integer, HashMap<IRmJob, IRmJob>> squatters = new HashMap<Integer, HashMap<IRmJob, IRmJob>>();
        HashMap<Integer, HashMap<IRmJob, IRmJob>> residents = new HashMap<Integer, HashMap<IRmJob, IRmJob>>();
        for (Share s : this.allShares.values()) {
            HashMap<Object, Object> map = null;
            boolean is_candidate = force ? s.isForceable() : s.isPreemptable();
            if (!is_candidate) continue;
            IRmJob j = s.getJob();
            ResourceClass rc = j.getResourceClass();
            map = rc.getNodepoolName().equals(this.id) ? residents : squatters;
            int order = j.getShareOrder();
            HashMap jmap = null;
            if (map.containsKey(order)) {
                jmap = (HashMap)map.get(order);
            } else {
                jmap = new HashMap();
                map.put(order, jmap);
            }
            jmap.put(j, j);
        }
        this.doEvictions(neededByOrder, squatters, force);
        this.logger.debug(methodName, null, new Object[]{this.getId(), "NeededByOrder", type, "after eviction of squatters:", Arrays.toString(neededByOrder)});
        if (neededByOrder[0] <= 0) {
            return;
        }
        this.doEvictions(neededByOrder, residents, force);
        this.logger.debug(methodName, null, new Object[]{this.getId(), "NeededByOrder", type, "after eviction of residents:", Arrays.toString(neededByOrder)});
    }

    int findShares(IRmJob j) {
        String methodName = "findShares";
        int counted = j.countNSharesGiven();
        int current = j.countNShares();
        int needed = counted - current;
        int order = j.getShareOrder();
        int given = 0;
        this.logger.trace(methodName, j.getId(), new Object[]{"counted", counted, "current", current, "needed", needed, "order", order, "given", given});
        if (needed > 0) {
            block0: for (int i = order; i < NodePool.getArraySize(); ++i) {
                if (this.nSharesByOrder[i] == 0) continue;
                HashMap<Node, Machine> machs = this.getVirtualMachinesByOrder(i);
                ArrayList<Machine> ml = new ArrayList<Machine>();
                ml.addAll(machs.values());
                for (Machine m : ml) {
                    int g = Math.min(needed, m.countFreeShares(order));
                    for (int ndx = 0; ndx < g; ++ndx) {
                        Share s = new Share(m, j, order);
                        this.connectShare(s, m, j, order);
                        this.logger.info(methodName, j.getId(), new Object[]{"Connecting new share", s.toString()});
                    }
                    given += g;
                    if ((needed -= g) != 0) continue;
                    break block0;
                }
            }
        }
        if (needed > 0) {
            for (NodePool np : this.getChildrenAscending()) {
                int g = np.findShares(j);
                given += g;
                if ((needed -= g) != 0) continue;
                break;
            }
        }
        return given;
    }

    HashMap<IRmJob, IRmJob> doExpansion(List<IRmJob> jobs) {
        String methodName = "doExpansion";
        HashMap<IRmJob, IRmJob> expansions = new HashMap<IRmJob, IRmJob>();
        StringBuffer sb = new StringBuffer();
        sb.append("NP: ");
        sb.append(this.getId());
        sb.append(" Expansions in this order: ");
        for (IRmJob j : jobs) {
            sb.append(j.getId());
            sb.append(":");
            if (this.findShares(j) > 0) {
                sb.append("found ");
                expansions.put(j, j);
                continue;
            }
            sb.append("notfound ");
        }
        this.logger.info(methodName, null, new Object[]{sb.toString()});
        return expansions;
    }

    public String toString() {
        int i;
        int i2;
        StringBuffer sb = new StringBuffer();
        sb.append("--------------------------------------------------------------------------------\n");
        sb.append("Nodepool ");
        sb.append(this.id);
        sb.append(" depth ");
        sb.append(this.depth);
        sb.append(": ");
        sb.append("\n");
        int len = this.nMachinesByOrder.length;
        StringBuffer sbsb = new StringBuffer("%18s ");
        for (int i3 = 0; i3 < len; ++i3) {
            sbsb.append("%4s ");
        }
        sbsb.append("\n");
        String fmt = sbsb.toString();
        Object[] vals = new Object[len + 2];
        vals[0] = "Order";
        for (i2 = 0; i2 < len; ++i2) {
            vals[i2 + 1] = Integer.toString(i2);
        }
        sb.append(String.format(fmt, vals));
        sbsb = new StringBuffer("%18s ");
        for (i2 = 0; i2 < len; ++i2) {
            sbsb.append("%4d ");
        }
        sbsb.append("\n");
        fmt = sbsb.toString();
        vals[0] = "nMachinesByOrder";
        int[] counts = this.countMachinesByOrder();
        for (i = 0; i < len; ++i) {
            vals[i + 1] = counts[i];
        }
        sb.append(String.format(fmt, vals));
        vals[0] = "vMachinesByOrder";
        counts = this.countVMachinesByOrder();
        for (i = 0; i < len; ++i) {
            vals[i + 1] = counts[i];
        }
        sb.append(String.format(fmt, vals));
        vals[0] = "nSharesByOrder";
        counts = this.countAllNSharesByOrder();
        for (i = 0; i < len; ++i) {
            vals[i + 1] = counts[i];
        }
        sb.append(String.format(fmt, vals));
        sb.append("--------------------------------------------------------------------------------\n");
        for (NodePool np : this.children.values()) {
            sb.append(np.toString());
        }
        return sb.toString();
    }

    public void queryMachines() {
        String methodName = "queryMachines";
        ArrayList<Machine> machines = new ArrayList<Machine>();
        machines.addAll(this.getAllMachines().values());
        this.logger.info(methodName, null, new Object[]{"================================== Query Machines Nodepool:", this.id, "========================="});
        StringBuffer buf = new StringBuffer();
        buf.append(Machine.getHeader());
        buf.append("\n");
        buf.append(Machine.getDashes());
        buf.append("\n");
        Collections.sort(machines, new MachineByOrderSorter());
        for (Machine m : machines) {
            buf.append(m.toString());
            int remaining = m.countFreeShares();
            if (remaining > 0) {
                buf.append("[" + m.countFreeShares() + "]");
            }
            buf.append("\n");
        }
        this.logger.info(methodName, null, new Object[]{"\n", buf.toString()});
        this.logger.info(methodName, null, new Object[]{"================================== End Query Machines Nodepool:", this.id, "======================"});
    }

    class MachineByAscendingOrderSorter
    implements Comparator<Machine> {
        MachineByAscendingOrderSorter() {
        }

        @Override
        public int compare(Machine m1, Machine m2) {
            return m1.getShareOrder() - m2.getShareOrder();
        }
    }

    class MachineByOrderSorter
    implements Comparator<Machine> {
        MachineByOrderSorter() {
        }

        @Override
        public int compare(Machine m1, Machine m2) {
            return m2.getShareOrder() - m1.getShareOrder();
        }
    }

    class DescendingShareOrderSorter
    implements Comparator<Share> {
        DescendingShareOrderSorter() {
        }

        @Override
        public int compare(Share s1, Share s2) {
            return s2.getShareOrder() - s1.getShareOrder();
        }
    }

    class InvestmentSorter
    implements Comparator<Share> {
        InvestmentSorter() {
        }

        @Override
        public int compare(Share s1, Share s2) {
            return (int)(s1.getInvestment() - s2.getInvestment());
        }
    }

    private static class NodepoolDescendingSorter
    implements Comparator<NodePool> {
        private NodepoolDescendingSorter() {
        }

        @Override
        public int compare(NodePool n1, NodePool n2) {
            return n2.getOrder() - n1.getOrder();
        }
    }

    private static class NodepoolAscendingSorter
    implements Comparator<NodePool> {
        private NodepoolAscendingSorter() {
        }

        @Override
        public int compare(NodePool n1, NodePool n2) {
            return n1.getOrder() - n2.getOrder();
        }
    }

    class ReservationSorter
    implements Comparator<Machine> {
        ReservationSorter() {
        }

        @Override
        public int compare(Machine m1, Machine m2) {
            if (m1.equals(m2)) {
                return 0;
            }
            if (m1.isFree()) {
                if (m2.isFree()) {
                    return m1.getShareOrder() - m2.getShareOrder();
                }
                return -1;
            }
            switch (NodePool.this.evictionPolicy) {
                case SHRINK_BY_MACHINE: {
                    return m2.countFreeShares() - m1.countFreeShares();
                }
                case SHRINK_BY_INVESTMENT: {
                    return m1.getInvestment() - m2.getInvestment();
                }
            }
            return 0;
        }
    }
}

