/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.rm.scheduler;

import java.util.Comparator;
import java.util.HashMap;
import org.apache.uima.ducc.rm.scheduler.IEntity;
import org.apache.uima.ducc.rm.scheduler.IRmJob;
import org.apache.uima.ducc.rm.scheduler.NodePool;
import org.apache.uima.ducc.rm.scheduler.ResourceClass;
import org.apache.uima.ducc.rm.scheduler.SchedulingException;

public class User
implements IEntity {
    private String id;
    private HashMap<IRmJob, IRmJob> jobs = new HashMap();
    private HashMap<ResourceClass, HashMap<IRmJob, IRmJob>> jobsByClass = new HashMap();
    private HashMap<Integer, HashMap<IRmJob, IRmJob>> jobsByOrder = new HashMap();
    private int pure_fair_share;
    private int share_wealth;
    private int[] given_by_order = null;
    private int[] wanted_by_order = null;
    private static Comparator<IEntity> apportionmentSorter = new ApportionmentSorterCl();

    public User(String name) {
        this.id = name;
    }

    @Override
    public long getTimestamp() {
        return 0L;
    }

    void addJob(IRmJob j) {
        this.jobs.put(j, j);
        int order = j.getShareOrder();
        HashMap<IRmJob, IRmJob> ojobs = this.jobsByOrder.get(order);
        if (!this.jobsByOrder.containsKey(order)) {
            ojobs = new HashMap();
            this.jobsByOrder.put(order, ojobs);
        }
        ojobs.put(j, j);
        ResourceClass cl = j.getResourceClass();
        ojobs = this.jobsByClass.get(cl);
        if (ojobs == null) {
            ojobs = new HashMap();
            this.jobsByClass.put(cl, ojobs);
        }
        ojobs.put(j, j);
    }

    int remove(IRmJob j) {
        if (this.jobs.containsKey(j)) {
            this.jobs.remove(j);
            int order = j.getShareOrder();
            HashMap<IRmJob, IRmJob> ojobs = this.jobsByOrder.get(order);
            ojobs.remove(j);
            ResourceClass cl = j.getResourceClass();
            if (this.jobsByClass.containsKey(cl)) {
                ojobs = this.jobsByClass.get(cl);
                ojobs.remove(j);
            }
        } else {
            throw new SchedulingException(j.getId(), "User " + this.id + " is asked to remove job " + j.getId() + " but the job is not assigned.");
        }
        return this.jobs.size();
    }

    @Override
    public int getShareWeight() {
        return 1;
    }

    private int countNSharesWanted(int order, ResourceClass rc) {
        int K = 0;
        HashMap<IRmJob, IRmJob> jobs = this.jobsByOrder.get(order);
        if (jobs == null) {
            return 0;
        }
        String rcname = rc.getName();
        for (IRmJob j : jobs.values()) {
            if (!j.getResourceClass().getName().equals(rcname)) continue;
            K += j.getJobCap();
        }
        return K;
    }

    @Override
    public void initWantedByOrder(ResourceClass rc) {
        this.wanted_by_order = NodePool.makeArray();
        for (int o = NodePool.getMaxOrder(); o > 0; --o) {
            this.wanted_by_order[o] = this.countNSharesWanted(o, rc);
            this.wanted_by_order[0] = this.wanted_by_order[0] + this.wanted_by_order[o];
        }
    }

    public void setPureFairShare(int pfs) {
        this.pure_fair_share = pfs;
    }

    public int getPureFairShare() {
        return this.pure_fair_share;
    }

    @Override
    public int[] getWantedByOrder() {
        return this.wanted_by_order;
    }

    @Override
    public void setGivenByOrder(int[] gbo) {
        this.given_by_order = gbo;
    }

    @Override
    public int[] getGivenByOrder() {
        return this.given_by_order;
    }

    public void setShareWealth(int w) {
        this.share_wealth = w;
    }

    public int getShareWealth() {
        return this.share_wealth;
    }

    public void subtractWealth(int w) {
        this.share_wealth -= w;
    }

    @Override
    public int calculateCap(int order, int total) {
        return Integer.MAX_VALUE;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        User u = (User)o;
        return this.id.equals(u.getName());
    }

    @Override
    public String getName() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public Comparator<IEntity> getApportionmentSorter() {
        return apportionmentSorter;
    }

    private static class ApportionmentSorterCl
    implements Comparator<IEntity> {
        private ApportionmentSorterCl() {
        }

        @Override
        public int compare(IEntity e1, IEntity e2) {
            if (e1 == e2) {
                return 0;
            }
            return e1.getName().compareTo(e2.getName());
        }
    }
}

