/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.rm.scheduler;

import java.util.HashMap;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.rm.scheduler.NodePool;
import org.apache.uima.ducc.rm.scheduler.SchedConstants;
import org.apache.uima.ducc.rm.scheduler.Share;

public class Machine
implements SchedConstants {
    private String id;
    private int hbcounter = 0;
    private long memory;
    private int share_order = 0;
    private NodePool nodepool;
    private int virtual_share_order = 0;
    private int shares_left = 0;
    Node node;
    private HashMap<Share, Share> activeShares = new HashMap();

    public Machine(Node node) {
        this.node = node;
        this.memory = node.getNodeMetrics().getNodeMemory().getMemTotal();
        this.id = node.getNodeIdentity().getName();
    }

    public Node key() {
        return this.node;
    }

    public synchronized void heartbeat_down() {
        this.hbcounter = 0;
    }

    public synchronized void heartbeat_up() {
        ++this.hbcounter;
    }

    public synchronized int get_heartbeat() {
        return this.hbcounter;
    }

    public NodeIdentity getNodeIdentity() {
        return this.node.getNodeIdentity();
    }

    public void setNodepool(NodePool np) {
        this.nodepool = np;
    }

    public NodePool getNodepool() {
        return this.nodepool;
    }

    public boolean isFree() {
        return this.activeShares.size() == 0 && this.virtual_share_order == this.share_order;
    }

    public boolean isFreeable() {
        boolean answer = true;
        for (Share s : this.activeShares.values()) {
            if (!s.isFixed()) continue;
            return false;
        }
        return answer;
    }

    public int countProcesses() {
        return this.activeShares.size();
    }

    public void assignShare(Share s) {
        this.activeShares.put(s, s);
        this.shares_left -= s.getShareOrder();
    }

    HashMap<Share, Share> getActiveShares() {
        return this.activeShares;
    }

    public Node getNode() {
        return this.node;
    }

    public String getId() {
        return this.id;
    }

    public String getIp() {
        return this.node.getNodeIdentity().getIp();
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getMemory() {
        return this.memory;
    }

    public void setMemory(long memory) {
        this.memory = memory;
    }

    public int getShareOrder() {
        return this.share_order;
    }

    public int getVirtualShareOrder() {
        return this.virtual_share_order;
    }

    public void setShareOrder(int o) {
        this.shares_left = this.share_order = o;
        this.virtual_share_order = this.share_order;
    }

    public void setVirtualShareOrder(int o) {
        this.virtual_share_order = o;
    }

    public void resetVirtualShareOrder() {
        this.virtual_share_order = this.share_order;
    }

    public void removeShare(Share s) {
        this.activeShares.remove(s);
        this.nodepool.removeShare(s);
        this.shares_left += s.getShareOrder();
    }

    public int countFreeShares(int order) {
        int in_use = 0;
        for (Share s : this.activeShares.values()) {
            in_use += s.getShareOrder();
        }
        return (this.share_order - in_use) / order;
    }

    public int countFreeShares() {
        return this.shares_left;
    }

    public int countFreedUpShares() {
        int cnt = this.shares_left;
        for (Share s : this.activeShares.values()) {
            if (!s.isEvicted()) continue;
            cnt += s.getShareOrder();
        }
        return cnt;
    }

    public int getInvestment() {
        int answer = 0;
        for (Share s : this.activeShares.values()) {
            answer = (int)((long)answer + s.getInvestment());
        }
        return answer;
    }

    public static String getDashes() {
        return String.format("%20s %5s %13s %13s %11s %s", "--------------------", "-----", "-------------", "-------------", "-----------", "------ ...");
    }

    public static String getHeader() {
        return String.format("%20s %5s %13s %13s %11s %s", "Name", "Order", "Active Shares", "Unused Shares", "Memory (MB)", "Jobs");
    }

    public boolean matches(String s) {
        String name = this.getNodeIdentity().getName();
        if (s.equals(name)) {
            return true;
        }
        int ndx1 = s.indexOf(".");
        int ndx2 = name.indexOf(".");
        if (ndx1 > 0 && ndx2 > 0) {
            return false;
        }
        if (ndx1 == -1) {
            return s.equals(name.substring(0, ndx2));
        }
        return s.substring(0, ndx1).equals(name);
    }

    public int hashCode() {
        return this.getNodeIdentity().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Machine m = (Machine)o;
        return this.getNodeIdentity().equals((Object)m.getNodeIdentity());
    }

    public String toString() {
        int qshares = 0;
        int unused = this.share_order;
        String jobs = "<none>";
        if (this.activeShares.size() > 0) {
            StringBuffer buf = new StringBuffer();
            for (Share s : this.activeShares.values()) {
                qshares += s.getShareOrder();
                buf.append(s.getJob().getId());
                buf.append(" ");
            }
            jobs = buf.toString();
            unused = this.share_order - qshares;
        }
        return String.format("%20s %5d %13d %13d %11d %s", this.id, this.share_order, qshares, unused, this.memory / 1024L, jobs);
    }
}

