/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.rm.config;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.SystemPropertyResolver;
import org.apache.uima.ducc.rm.NodeStability;
import org.apache.uima.ducc.rm.ResourceManager;
import org.apache.uima.ducc.rm.ResourceManagerComponent;
import org.apache.uima.ducc.rm.event.ResourceManagerEventListener;
import org.apache.uima.ducc.rm.scheduler.SchedConstants;
import org.apache.uima.ducc.transport.DuccTransportConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DuccTransportConfiguration.class, CommonConfiguration.class})
public class ResourceManagerConfiguration
implements SchedConstants {
    @Autowired
    CommonConfiguration common;
    @Autowired
    DuccTransportConfiguration resourceManagerTransport;
    DuccLogger logger = DuccLogger.getLogger(this.getClass(), (String)"RM");

    public ResourceManagerEventListener resourceManagerDelegateListener(ResourceManagerComponent rm) {
        ResourceManagerEventListener jmel = new ResourceManagerEventListener(rm);
        int nodeStability = SystemPropertyResolver.getIntProperty((String)"ducc.rm.node.stability", (int)5);
        int agentMetricsRate = SystemPropertyResolver.getIntProperty((String)"ducc.agent.node.metrics.publish.rate", (int)60000);
        NodeStability ns = new NodeStability(rm, nodeStability, agentMetricsRate);
        rm.setNodeStability(ns);
        jmel.setEndpoint(this.common.rmStateUpdateEndpoint);
        jmel.setNodeStability(ns);
        ns.start();
        return jmel;
    }

    public RouteBuilder routeBuilderForEndpoint(final String endpoint, final ResourceManagerEventListener delegate) {
        return new RouteBuilder(){

            public void configure() {
                this.from(endpoint).bean((Object)delegate);
            }
        };
    }

    public RouteBuilder routeBuilderForJmEndpoint(final String endpoint, final ResourceManagerEventListener delegate) {
        System.out.println("Starting JM endpoint " + endpoint + "  ???????????????????????");
        return new RouteBuilder(){

            public void configure() {
                this.from(endpoint).threads(10).bean((Object)delegate);
            }
        };
    }

    @Bean
    public ResourceManagerComponent resourceManager() throws Throwable {
        String methodName = "resourceManager";
        ResourceManagerComponent rm = null;
        try {
            rm = new ResourceManagerComponent(this.common.camelContext());
            rm.setTransportConfiguration(this.resourceManagerTransport.duccEventDispatcher(this.common.rmStateUpdateEndpoint, rm.getContext()), this.common.rmStateUpdateEndpoint);
            ResourceManagerEventListener delegateListener = this.resourceManagerDelegateListener(rm);
            delegateListener.setDuccEventDispatcher(this.resourceManagerTransport.duccEventDispatcher(this.common.orchestratorStateUpdateEndpoint, rm.getContext()));
            rm.getContext().addRoutes((RoutesBuilder)this.routeBuilderForEndpoint(this.common.orchestratorAbbreviatedStateUpdateEndpoint, delegateListener));
            rm.getContext().addRoutes((RoutesBuilder)this.routeBuilderForEndpoint(this.common.nodeMetricsEndpoint, delegateListener));
            return rm;
        }
        catch (Throwable t) {
            this.logger.fatal(methodName, null, t, new Object[0]);
            throw new IllegalStateException("Can't start RM: " + t.getMessage());
        }
    }

    public class NodeMetricsProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
        }
    }

    public class NodeInventoryProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
        }
    }

    public class ResourceManagerStateUpdateProcessor
    implements Processor {
        private ResourceManager resourceManager;

        public ResourceManagerStateUpdateProcessor(ResourceManager resourceManager) {
            this.resourceManager = resourceManager;
        }

        public void process(Exchange exchange) throws Exception {
            exchange.getIn().setBody((Object)this.resourceManager.getState());
        }
    }
}

