/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.rm;

import java.util.Map;
import org.apache.uima.ducc.common.ANodeStability;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.rm.ResourceManagerComponent;
import org.apache.uima.ducc.rm.scheduler.ISchedulerMain;
import org.apache.uima.ducc.rm.scheduler.SchedConstants;

public class NodeStability
extends ANodeStability
implements SchedConstants {
    ISchedulerMain scheduler;
    ResourceManagerComponent rm;
    DuccLogger logger = DuccLogger.getLogger(NodeStability.class, (String)"RM");

    public NodeStability(ResourceManagerComponent rm, int nodeStabilityLimit, int agentMetricsRate) {
        super(nodeStabilityLimit, agentMetricsRate);
        this.rm = rm;
        this.scheduler = rm.getScheduler();
    }

    public void nodeDeath(Map<Node, Node> nodes) {
        String methodName = "nodeDeath";
        this.scheduler.nodeDeath(nodes);
        for (Node n : nodes.keySet()) {
            this.logger.debug(methodName, null, new Object[]{"*** ! Notification of node death:", n.getNodeIdentity().getName()});
        }
    }

    public void missedNode(Node n, int c) {
        String methodName = "missedNode";
        this.logger.warn(methodName, null, new Object[]{"*** Missed heartbeat ***", n.getNodeIdentity().getName(), "count[", c, "]"});
    }

    public void nodeArrives(Node n) {
        String methodName = "nodeArrives";
        if (!this.rm.isSchedulerReady()) {
            this.logger.warn(methodName, null, new Object[]{"Ignoring node update, scheduler is still booting."});
            return;
        }
        this.scheduler.nodeArrives(n);
        super.nodeArrives(n);
    }
}

