/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.rm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.utils.DuccCollectionUtils;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.SystemPropertyResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.rm.NodeStability;
import org.apache.uima.ducc.rm.scheduler.IJobManager;
import org.apache.uima.ducc.rm.scheduler.IRmJob;
import org.apache.uima.ducc.rm.scheduler.ISchedulerMain;
import org.apache.uima.ducc.rm.scheduler.JobManagerUpdate;
import org.apache.uima.ducc.rm.scheduler.Machine;
import org.apache.uima.ducc.rm.scheduler.ResourceClass;
import org.apache.uima.ducc.rm.scheduler.RmJob;
import org.apache.uima.ducc.rm.scheduler.SchedConstants;
import org.apache.uima.ducc.rm.scheduler.SchedulingException;
import org.apache.uima.ducc.rm.scheduler.Share;
import org.apache.uima.ducc.transport.event.RmStateDuccEvent;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccPerWorkItemStatistics;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccReservation;
import org.apache.uima.ducc.transport.event.common.IDuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccSchedulingInfo;
import org.apache.uima.ducc.transport.event.common.IDuccStandardInfo;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkExecutable;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.transport.event.common.ITimeWindow;
import org.apache.uima.ducc.transport.event.rm.IRmJobState;
import org.apache.uima.ducc.transport.event.rm.Resource;
import org.apache.uima.ducc.transport.event.rm.RmJobState;

public class JobManagerConverter
implements IJobManager,
SchedConstants {
    DuccLogger logger = DuccLogger.getLogger(JobManagerConverter.class, (String)"RM");
    ISchedulerMain scheduler;
    NodeStability nodeStability = null;
    DuccWorkMap localMap = null;
    JobManagerUpdate lastJobManagerUpdate = new JobManagerUpdate();
    Map<IRmJob, IRmJob> refusedJobs = new HashMap<IRmJob, IRmJob>();
    boolean recovery = false;
    boolean first_or_state = true;
    Map<DuccId, IRmJobState> previousJobState = new HashMap<DuccId, IRmJobState>();

    public JobManagerConverter(ISchedulerMain scheduler, NodeStability ns) {
        this.scheduler = scheduler;
        this.localMap = new DuccWorkMap();
        this.nodeStability = ns;
        DuccLogger.setUnthreaded();
        this.recovery = SystemPropertyResolver.getBooleanProperty((String)"ducc.rm.fast.recovery", (boolean)true);
    }

    int toInt(String s, int deflt) {
        try {
            int val = Integer.parseInt(s);
            return val == 0 ? deflt : val;
        }
        catch (Throwable t) {
            return deflt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refuse(IRmJob j, String reason) {
        j.refuse(reason);
        Map<IRmJob, IRmJob> map = this.refusedJobs;
        synchronized (map) {
            this.refusedJobs.put(j, j);
        }
    }

    String getElapsedTime(ITimeWindow w) {
        if (w == null) {
            return "0";
        }
        return w.getDiff();
    }

    void jobUpdate(Object state, IDuccWork job) {
        String methodName = "jobUpate";
        IDuccSchedulingInfo si = job.getSchedulingInfo();
        DuccId jobid = job.getDuccId();
        IRmJob j = this.scheduler.getJob(jobid);
        if (j == null) {
            return;
        }
        int total_work = this.toInt(si.getWorkItemsTotal(), this.scheduler.getDefaultNTasks());
        int completed_work = this.toInt(si.getWorkItemsCompleted(), 0) + this.toInt(si.getWorkItemsError(), 0) + this.toInt(si.getWorkItemsLost(), 0);
        int max_shares = this.toInt(si.getSharesMax(), Integer.MAX_VALUE);
        int existing_max_shares = j.getMaxShares();
        int remaining_work = Math.max(total_work - completed_work, 1);
        double arith_mean = Double.NaN;
        IDuccPerWorkItemStatistics stats = si.getPerWorkItemStatistics();
        if (stats != null) {
            arith_mean = stats.getMean();
        }
        this.logger.info(methodName, job.getDuccId(), new Object[]{String.format("tot: %d %s -> %s compl: %s err: %s rem: %d mean: %f", total_work, state, job.getStateObject(), si.getWorkItemsCompleted(), si.getWorkItemsError(), remaining_work, arith_mean)});
        if (max_shares != existing_max_shares) {
            j.setMaxShares(max_shares);
            this.logger.info(methodName, job.getDuccId(), new Object[]{"Max shares adjusted from", existing_max_shares, "to", max_shares, "(incoming)", si.getSharesMax()});
        }
        j.setNQuestions(total_work, remaining_work, arith_mean);
        if (job instanceof IDuccWorkJob) {
            if (j.setInitWait(((IDuccWorkJob)job).isRunnable())) {
                this.logger.info(methodName, jobid, new Object[]{"Set Initialized."});
                this.scheduler.signalInitialized(j);
            }
        } else {
            j.setInitWait(true);
        }
    }

    private boolean receiveExecutable(IRmJob j, IDuccWork job) {
        String methodName = "receiveExecutable";
        IDuccWorkExecutable de = (IDuccWorkExecutable)job;
        IDuccProcessMap pm = de.getProcessMap();
        if (pm.size() > 0 && !job.isCompleted()) {
            for (IDuccProcess proc : pm.values()) {
                IProcessState.ProcessState state = proc.getProcessState();
                String pid = proc.getPID();
                NodeIdentity ni = proc.getNodeIdentity();
                if (proc.isComplete()) {
                    this.logger.debug(methodName, j.getId(), new Object[]{"Skipping process", pid, "on", ni.getName(), "beacause state is", state});
                    continue;
                }
                Machine m = this.scheduler.getMachine(ni);
                if (m == null) {
                    this.refuse(j, "Cannot restore job because node " + ni.getName() + " is unknown.");
                    return false;
                }
                DuccId id = proc.getDuccId();
                Share s = new Share(id, m, j, m.getShareOrder());
                long mem = proc.getResidentMemory();
                this.logger.info(methodName, j.getId(), new Object[]{"Assigning share in state", state, "pid", pid, "for recovery", s.toString()});
                j.recoverShare(s);
                s.update(j.getId(), mem, state, proc.getTimeWindowInit(), proc.getTimeWindowRun(), pid);
            }
            this.logger.info(methodName, j.getId(), new Object[]{"Scheduling for recovery."});
            this.scheduler.signalRecovery(j);
        } else {
            this.logger.info(methodName, j.getId(), new Object[]{"Scheduling as new."});
            this.scheduler.signalNewWork(j);
        }
        return true;
    }

    private boolean receiveReservation(IRmJob j, IDuccWork job) {
        String methodName = "receiveReservation";
        j.setReservation();
        IDuccWorkReservation dr = (IDuccWorkReservation)job;
        IDuccReservationMap rm = dr.getReservationMap();
        if (rm.size() > 0 && !job.isCompleted()) {
            for (IDuccReservation res : rm.values()) {
                NodeIdentity ni = res.getNodeIdentity();
                Machine m = this.scheduler.getMachine(ni);
                if (m == null) {
                    this.refuse(j, "Cannot restore reservation because node " + ni.getName() + " is unknown.");
                    return false;
                }
                DuccId id = res.getDuccId();
                Share s = new Share(id, m, j, m.getShareOrder());
                s.setFixed();
                j.recoverShare(s);
                this.logger.debug(methodName, j.getId(), new Object[]{"Assigning share for recovery", s.toString()});
            }
            this.logger.info(methodName, j.getId(), new Object[]{"Scheduling for recovery."});
            this.scheduler.signalRecovery(j);
        } else {
            this.logger.info(methodName, j.getId(), new Object[]{"Scheduling as new."});
            this.scheduler.signalNewWork(j);
        }
        return true;
    }

    boolean jobArrives(IDuccWork job) {
        String methodName = "jobArrives";
        this.logger.trace(methodName, job.getDuccId(), new Object[]{"Job arives"});
        this.logger.trace(methodName, job.getDuccId(), new Object[]{"Job is of type", job.getDuccType()});
        RmJob j = new RmJob(job.getDuccId());
        IDuccSchedulingInfo si = job.getSchedulingInfo();
        IDuccStandardInfo sti = job.getStandardInfo();
        String name = sti.getDescription();
        if (name == null) {
            name = "A Job With No Name.";
        }
        String user_name = sti.getUser();
        j.setUserName(user_name);
        j.setJobName(name);
        int min_shares = this.toInt(si.getSharesMin(), 0);
        int threads = this.toInt(si.getThreadsPerShare(), this.scheduler.getDefaultNThreads());
        int user_priority = this.toInt(si.getSchedulingPriority(), 100);
        int total_work = this.toInt(si.getWorkItemsTotal(), this.scheduler.getDefaultNTasks());
        int completed_work = this.toInt(si.getWorkItemsCompleted(), 0);
        int remaining_work = Math.max(total_work - completed_work, 1);
        this.logger.info(methodName, job.getDuccId(), new Object[]{"total_work", total_work, "completed_work", completed_work, "remaining_work", remaining_work});
        int memory = this.toInt(si.getShareMemorySize(), this.scheduler.getDefaultMemory());
        String className = si.getSchedulingClass();
        if (className == null) {
            switch (job.getDuccType()) {
                case Job: {
                    className = this.scheduler.getDefaultFairShareName();
                    break;
                }
                case Service: 
                case Pop: 
                case Reservation: {
                    className = this.scheduler.getDefaultReserveName();
                }
            }
            if (className == null) {
                j.refuse("No scheduling class defined and no default class configured.");
                return false;
            }
        }
        j.setMinShares(min_shares);
        j.setThreads(threads);
        j.setUserPriority(user_priority);
        j.setNQuestions(total_work, remaining_work, 0.0);
        j.setClassName(className);
        switch (si.getShareMemoryUnits()) {
            case GB: {
                break;
            }
            default: {
                this.logger.warn(methodName, job.getDuccId(), new Object[]{"Memory units other than GB are not currently supported.  Job returned."});
            }
        }
        j.setMemory(memory);
        j.init();
        j.setTimestamp(Long.parseLong(sti.getDateOfSubmission()));
        if (job instanceof IDuccWorkJob) {
            j.setInitWait(((IDuccWorkJob)job).isRunnable());
        } else {
            j.setInitWait(true);
        }
        j.setDuccType(job.getDuccType());
        boolean status = true;
        int max_processes = 0;
        int max_machines = 0;
        ResourceClass rescl = this.scheduler.getResourceClass(className);
        j.setResourceClass(rescl);
        if (rescl == null) {
            this.refuse(j, "Cannot find priority class " + className + " for job");
            return false;
        }
        switch (job.getDuccType()) {
            case Job: 
            case Service: 
            case Pop: {
                switch (rescl.getPolicy()) {
                    case FAIR_SHARE: {
                        max_processes = this.toInt(si.getSharesMax(), 10);
                        max_processes = Math.min(rescl.getMaxProcesses(), max_processes);
                        j.setMaxShares(max_processes);
                        j.setNInstances(-1);
                        break;
                    }
                    case FIXED_SHARE: {
                        max_processes = this.toInt(si.getSharesMax(), 1);
                        j.setMaxShares(max_processes);
                        j.setNInstances(max_processes);
                        break;
                    }
                    case RESERVE: {
                        max_machines = this.toInt(si.getSharesMax(), 1);
                        j.setMaxShares(max_machines);
                        j.setNInstances(max_machines);
                    }
                }
                status = this.receiveExecutable(j, job);
                this.logger.trace(methodName, j.getId(), new Object[]{"Serivce, Pop, or Job arrives, accepted:", status});
                break;
            }
            case Reservation: {
                switch (rescl.getPolicy()) {
                    case FIXED_SHARE: {
                        max_machines = this.toInt(si.getInstancesCount(), 1);
                        break;
                    }
                    case RESERVE: {
                        max_machines = this.toInt(si.getInstancesCount(), 1);
                    }
                }
                j.setMaxShares(-1);
                j.setNInstances(max_machines);
                status = this.receiveReservation(j, job);
                this.logger.trace(methodName, j.getId(), new Object[]{"Reservation arrives, accepted:", status});
                break;
            }
            default: {
                this.refuse(j, "Unknown job type: " + job.getDuccType());
                status = false;
            }
        }
        return status;
    }

    void jobRemoved(DuccId id) {
        String methodName = "jobRemoved";
        this.logger.trace(methodName, id, new Object[]{"Signalling removal"});
        this.scheduler.signalCompletion(id);
        this.localMap.removeDuccWork(id);
        this.logger.trace(methodName, id, new Object[]{"Remove signalled"});
    }

    public void reconcileProcesses(DuccId jobid, IDuccWork l, IDuccWork r) {
        String methodName = "reconcileProcess";
        IDuccProcessMap lpm = ((IDuccWorkJob)l).getProcessMap();
        IDuccProcessMap rpm = ((IDuccWorkJob)r).getProcessMap();
        DuccCollectionUtils.DuccMapDifference diffmap = DuccCollectionUtils.difference((Map)lpm, (Map)rpm);
        Map lproc = diffmap.getLeft();
        for (IDuccProcess p : lproc.values()) {
            Share s = this.scheduler.getShare(p.getDuccId());
            long mem = p.getResidentMemory();
            IProcessState.ProcessState state = p.getProcessState();
            String pid = p.getPID();
            this.logger.info(methodName, jobid, new Object[]{"New process ", s.toString(), mem, state, pid});
            if (s.update(jobid, mem, state, p.getTimeWindowInit(), p.getTimeWindowRun(), pid)) continue;
            throw new SchedulingException(jobid, "Process assignemnt arrives for share " + s.toString() + " but jobid " + jobid + " does not match share " + s.getJob().getId());
        }
        Map rproc = diffmap.getRight();
        for (IDuccProcess p : rproc.values()) {
            Share s = this.scheduler.getShare(p.getDuccId());
            IRmJob j = this.scheduler.getJob(jobid);
            if (j == null) {
                throw new SchedulingException(jobid, "Process completion arrives for share " + s.toString() + " but job " + jobid + "cannot be found.");
            }
            this.scheduler.signalCompletion(j, s);
            this.logger.info(methodName, jobid, new Object[]{String.format("Process %5s", p.getPID()), "Completion:", s.toString()});
        }
        for (DuccCollectionUtils.DuccMapValueDifference pd : diffmap) {
            IRmJob j;
            long init_timeR;
            IDuccProcess pl = (IDuccProcess)pd.getLeft();
            IDuccProcess pr = (IDuccProcess)pd.getRight();
            Share sl = this.scheduler.getShare(pl.getDuccId());
            Share sr = this.scheduler.getShare(pr.getDuccId());
            String shareL = sl == null ? "<none>" : sl.toString();
            String shareR = sr == null ? "<none>" : sr.toString();
            ITimeWindow initL = pl.getTimeWindowInit();
            ITimeWindow initR = pr.getTimeWindowInit();
            long init_timeL = initL == null ? 0L : initL.getElapsedMillis();
            long l2 = init_timeR = initR == null ? 0L : initR.getElapsedMillis();
            if (this.logger.isTrace()) {
                this.logger.trace(methodName, jobid, new Object[]{"\n\tReconciling. incoming.(pid, mem, state, share, initTime)", pl.getPID(), pl.getResidentMemory(), pl.getProcessState(), shareL, init_timeL, "\n\tReconciling. existing.(pid, mem, state, share, initTime)", pr.getPID(), pr.getResidentMemory(), pr.getProcessState(), shareR, init_timeR});
            } else {
                if (pr.getPID() == null && pl.getPID() != null) {
                    this.logger.trace(methodName, jobid, new Object[]{String.format("Process %5s", pl.getPID()), "PID assignement for share", shareL});
                }
                if (pl.getProcessState() != pr.getProcessState()) {
                    this.logger.info(methodName, jobid, new Object[]{String.format("Process %5s", pl.getPID()), sl.toString(), "State:", pr.getProcessState(), "->", pl.getProcessState(), this.getElapsedTime(pr.getTimeWindowInit()), this.getElapsedTime(pr.getTimeWindowRun())});
                }
            }
            long mem = pl.getResidentMemory();
            IProcessState.ProcessState state = pl.getProcessState();
            String pid = pl.getPID();
            Share s = this.scheduler.getShare(pl.getDuccId());
            if (pl.isActive()) {
                if (s == null) {
                    this.logger.warn(methodName, jobid, new Object[]{"Update for share from process", pl.getPID(), pl.getDuccId(), "but cannot find share."});
                    continue;
                }
                if (s.isPurged()) {
                    j = this.scheduler.getJob(jobid);
                    this.scheduler.signalCompletion(j, s);
                    this.logger.info(methodName, jobid, new Object[]{"Process", pl.getPID(), "marked complete because it is purged. State:", state});
                }
                if (s.update(jobid, mem, state, pl.getTimeWindowInit(), pl.getTimeWindowRun(), pid)) continue;
                throw new SchedulingException(jobid, "Process update arrives for share " + s.toString() + " but jobid " + jobid + " does not match job in share " + s.getJob().getId());
            }
            if (pl.isComplete()) {
                if (s == null) continue;
                j = this.scheduler.getJob(jobid);
                this.scheduler.signalCompletion(j, s);
                this.logger.info(methodName, jobid, new Object[]{"Process", pl.getPID(), " completed due to state", state});
                continue;
            }
            this.logger.info(methodName, jobid, new Object[]{"Process", pl.getPID(), "ignoring update because of state", state});
        }
    }

    public void eventArrives(DuccWorkMap jobMap) {
        String methodName = "eventArrives";
        if (jobMap.size() == 0) {
            this.logger.debug(methodName, null, new Object[]{"No state from Orchestrator"});
            return;
        }
        if (!this.scheduler.isInitialized()) {
            return;
        }
        if (this.first_or_state) {
            this.first_or_state = false;
            if (!this.recoverFromOrchestrator(jobMap)) {
                this.logger.info(methodName, null, new Object[]{"There are no active jobs in map so can't build up state. Waiting for init stability."});
                return;
            }
            if (this.recovery) {
                this.logger.info(methodName, null, new Object[]{"Fast recovery is enabled: Recovered state from Orchestrator, starting scheduler."});
                this.scheduler.start();
            }
        }
        if (!this.scheduler.ready()) {
            this.logger.info(methodName, null, new Object[]{"Orchestrator event is discarded: waiting for init stability."});
            return;
        }
        DuccCollectionUtils.DuccMapDifference diffmap = DuccCollectionUtils.difference((Map)jobMap, (Map)this.localMap);
        for (IDuccWork w : jobMap.values()) {
            this.logger.trace(methodName, w.getDuccId(), new Object[]{"Arrives in JmStateEvent state =", w.getStateObject()});
        }
        Map jobs = diffmap.getLeft();
        for (IDuccWork w : jobs.values()) {
            if (w.isSchedulable()) {
                this.logger.info(methodName, w.getDuccId(), new Object[]{"Incoming, state = ", w.getStateObject()});
                try {
                    if (!this.jobArrives(w)) continue;
                    this.localMap.addDuccWork(w);
                }
                catch (Exception e) {
                    this.logger.error(methodName, w.getDuccId(), new Object[]{"Can't receive job because of exception", e});
                }
                continue;
            }
            this.logger.info(methodName, w.getDuccId(), new Object[]{"Received non-schedulable job, state = ", w.getStateObject()});
        }
        jobs = diffmap.getRight();
        for (IDuccWork w : jobs.values()) {
            this.logger.info(methodName, w.getDuccId(), new Object[]{"Gone"});
            this.jobRemoved(w.getDuccId());
        }
        for (DuccCollectionUtils.DuccMapValueDifference jd : diffmap) {
            IDuccWork r = (IDuccWork)jd.getRight();
            IDuccWork l = (IDuccWork)jd.getLeft();
            if (!l.isSchedulable()) {
                this.logger.info(methodName, l.getDuccId(), new Object[]{"Removing unschedulable:", r.getStateObject(), "->", l.getStateObject()});
                this.jobRemoved(r.getDuccId());
                continue;
            }
            this.localMap.addDuccWork(l);
            switch (l.getDuccType()) {
                case Job: {
                    this.jobUpdate(r.getStateObject(), l);
                    this.reconcileProcesses(l.getDuccId(), l, r);
                    break;
                }
                case Service: 
                case Pop: 
                case Reservation: {
                    if (r.getStateObject() == l.getStateObject()) break;
                    this.logger.info(methodName, l.getDuccId(), new Object[]{"[SPR] State: ", r.getStateObject(), "->", l.getStateObject()});
                    break;
                }
                case Undefined: {
                    throw new SchedulingException(l.getDuccId(), "Work arrives as type Undefined - should have been filtered out by now.");
                }
            }
        }
        this.logger.trace(methodName, null, new Object[]{"Done with JmStateDuccEvent with some jobs processed"});
    }

    Map<Share, Share> sanityCheckForOrchestrator(IRmJob j, Map<Share, Share> shares, Map<Share, Share> expanded) {
        String methodName = "sanityCheckForOrchestrator";
        IDuccWork w = this.localMap.findDuccWork(j.getId());
        if (w == null) {
            return null;
        }
        if (shares == null) {
            return null;
        }
        HashMap<Share, Share> ret = new HashMap<Share, Share>();
        switch (w.getDuccType()) {
            case Job: 
            case Service: {
                IDuccWorkExecutable de = (IDuccWorkExecutable)w;
                IDuccProcessMap pm = de.getProcessMap();
                for (Share s : shares.values()) {
                    IDuccProcess p = (IDuccProcess)pm.get((Object)s.getId());
                    if (p != null || expanded != null && expanded.containsKey(s)) continue;
                    this.logger.warn(methodName, j.getId(), new Object[]{"Redrive share assignment: ", s});
                    ret.put(s, s);
                }
                break;
            }
            case Reservation: {
                IDuccWorkReservation de = (IDuccWorkReservation)w;
                IDuccReservationMap rm = de.getReservationMap();
                for (Share s : shares.values()) {
                    IDuccReservation r = (IDuccReservation)rm.get((Object)s.getId());
                    if (r != null || expanded != null && expanded.containsKey(s)) continue;
                    this.logger.warn(methodName, j.getId(), new Object[]{"Redrive share assignment:", s});
                    ret.put(s, s);
                }
                break;
            }
        }
        return ret;
    }

    boolean isPendingNonPreemptable(IRmJob j) {
        String methodName = "isPendingNonPreemptable";
        if (j.getResourceClass().getPolicy() == SchedConstants.Policy.FAIR_SHARE) {
            return false;
        }
        this.logger.info(methodName, j.getId(), new Object[]{"countNShares", j.countNShares(), "countInstances", j.countInstances(), "isComplete", j.isCompleted()});
        if (j.isCompleted()) {
            return false;
        }
        if (j.countNShares() == j.countInstances()) {
            j.markComplete();
            return false;
        }
        return j.countNShares() < j.countInstances();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RmStateDuccEvent createState(JobManagerUpdate jmu) {
        String methodName = "createState";
        Map<DuccId, IRmJobState> rmJobState = null;
        if (jmu == null) {
            rmJobState = this.previousJobState;
        } else {
            rmJobState = new HashMap<DuccId, IRmJobState>();
            HashMap<IRmJob, IRmJob> refused = new HashMap<IRmJob, IRmJob>();
            Map<IRmJob, IRmJob> map = this.refusedJobs;
            synchronized (map) {
                refused.putAll(this.refusedJobs);
                this.refusedJobs.clear();
            }
            for (IRmJob j : refused.values()) {
                RmJobState rjs = new RmJobState(j.getId(), j.getRefusalReason());
                rjs.setDuccType(j.getDuccType());
                rmJobState.put(j.getId(), (IRmJobState)rjs);
            }
            Map<DuccId, IRmJob> jobs = jmu.getAllJobs();
            Map<DuccId, HashMap<Share, Share>> shrunken = jmu.getShrunkenShares();
            Map<DuccId, HashMap<Share, Share>> expanded = jmu.getExpandedShares();
            for (IRmJob j : jobs.values()) {
                if (j.isRefused()) {
                    RmJobState rjs = new RmJobState(j.getId(), j.getRefusalReason());
                    rjs.setDuccType(j.getDuccType());
                    rmJobState.put(j.getId(), (IRmJobState)rjs);
                    this.jobRemoved(j.getId());
                    this.logger.warn(methodName, j.getId(), new Object[]{"Refusal: ", j.getRefusalReason()});
                    continue;
                }
                LinkedHashMap<DuccId, Resource> all_shares = new LinkedHashMap<DuccId, Resource>();
                LinkedHashMap<DuccId, Resource> shrunken_shares = new LinkedHashMap<DuccId, Resource>();
                LinkedHashMap<DuccId, Resource> expanded_shares = new LinkedHashMap<DuccId, Resource>();
                Map<Share, Share> shares = null;
                Map<Share, Share> redrive = null;
                if (this.isPendingNonPreemptable(j)) {
                    this.logger.info(methodName, j.getId(), new Object[]{"Delaying publication of expansion because it's not yet complete."});
                } else {
                    Resource r;
                    shares = j.getAssignedShares();
                    if (shares != null) {
                        ArrayList sorted = new ArrayList(shares.values());
                        Collections.sort(sorted, new RmJob.ShareByInvestmentSorter());
                        for (Share s : sorted) {
                            Resource r2 = new Resource(s.getId(), s.getNode(), s.isPurged(), s.getShareOrder(), s.getInitializationTime());
                            all_shares.put(s.getId(), r2);
                        }
                        redrive = this.sanityCheckForOrchestrator(j, shares, (Map<Share, Share>)expanded.get(j.getId()));
                    }
                    if ((shares = (Map)shrunken.get(j.getId())) != null) {
                        for (Share s : shares.values()) {
                            r = new Resource(s.getId(), s.getNode(), s.isPurged(), s.getShareOrder(), 0L);
                            shrunken_shares.put(s.getId(), r);
                        }
                    }
                    if ((shares = (Map)expanded.get(j.getId())) != null) {
                        for (Share s : shares.values()) {
                            r = new Resource(s.getId(), s.getNode(), s.isPurged(), s.getShareOrder(), 0L);
                            expanded_shares.put(s.getId(), r);
                        }
                    }
                    if (redrive != null) {
                        for (Share s : redrive.values()) {
                            r = new Resource(s.getId(), s.getNode(), s.isPurged(), s.getShareOrder(), 0L);
                            expanded_shares.put(s.getId(), r);
                        }
                    }
                }
                RmJobState rjs = new RmJobState(j.getId(), all_shares, shrunken_shares, expanded_shares);
                rjs.setDuccType(j.getDuccType());
                rmJobState.put(j.getId(), (IRmJobState)rjs);
            }
            this.previousJobState = rmJobState;
        }
        RmStateDuccEvent response = new RmStateDuccEvent(rmJobState);
        try {
            this.logger.info(methodName, null, new Object[]{"Schedule sent to Orchestrator"});
            this.logger.info(methodName, null, new Object[]{response.toString()});
        }
        catch (Exception e) {
            this.logger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        return response;
    }

    boolean recoverFromOrchestrator(DuccWorkMap jobmap) {
        String methodName = "recoverFromOrchestrator";
        HashMap<Node, Node> nodes = new HashMap<Node, Node>();
        block9: for (IDuccWork w : jobmap.values()) {
            String prefix = "?";
            switch (w.getDuccType()) {
                case Job: {
                    prefix = "JOB";
                    break;
                }
                case Service: {
                    prefix = "SVC";
                    break;
                }
                case Reservation: {
                    prefix = "RES";
                }
            }
            if (w.isCompleted()) {
                this.logger.info(methodName, w.getDuccId(), new Object[]{"Ignoring completed work:", w.getDuccType(), ":", w.getStateObject()});
                continue;
            }
            switch (w.getDuccType()) {
                case Job: 
                case Service: {
                    IDuccWorkExecutable de = (IDuccWorkExecutable)w;
                    IDuccProcessMap pm = de.getProcessMap();
                    this.logger.info(methodName, w.getDuccId(), new Object[]{"Receive:", prefix, w.getDuccType(), w.getStateObject(), "processes[", pm.size(), "] Completed:", w.isCompleted()});
                    for (IDuccProcess proc : pm.values()) {
                        String pid = proc.getPID();
                        IProcessState.ProcessState state = proc.getProcessState();
                        Node n = proc.getNode();
                        if (n == null) {
                            this.logger.info(methodName, w.getDuccId(), new Object[]{"   Process[", pid, "] state [", state, "] is complete[", proc.isComplete(), "] Node [N/A] mem[N/A"});
                            continue;
                        }
                        long mem = n.getNodeMetrics().getNodeMemory().getMemTotal();
                        this.logger.info(methodName, w.getDuccId(), new Object[]{"   Process[", pid, "] state [", state, "] is complete [", proc.isComplete(), "] Node [", n.getNodeIdentity().getName() + "." + proc.getDuccId(), "] mem [", mem, "]"});
                        this.logger.info(methodName, w.getDuccId(), new Object[]{"      Recover node[", n.getNodeIdentity().getName()});
                        nodes.put(n, n);
                    }
                    continue block9;
                }
                case Reservation: {
                    IDuccWorkExecutable de = (IDuccWorkReservation)w;
                    IDuccReservationMap rm = de.getReservationMap();
                    this.logger.info(methodName, w.getDuccId(), new Object[]{"Receive:", prefix, w.getDuccType(), w.getStateObject(), "processes[", rm.size(), "] Completed:", w.isCompleted()});
                    for (IDuccReservation r : rm.values()) {
                        Node n = r.getNode();
                        if (n == null) {
                            this.logger.info(methodName, w.getDuccId(), new Object[]{"    Node [N/A] mem[N/A"});
                            continue;
                        }
                        long mem = n.getNodeMetrics().getNodeMemory().getMemTotal();
                        this.logger.info(methodName, w.getDuccId(), new Object[]{"   Node[", n.getNodeIdentity().getName(), "] mem[", mem, "]"});
                        nodes.put(n, n);
                    }
                    continue block9;
                }
                default: {
                    this.logger.info(methodName, w.getDuccId(), new Object[]{"Received work of type ?", w.getDuccType()});
                }
            }
        }
        this.logger.info(methodName, null, new Object[]{"Recovered[", nodes.size(), "] nodes from OR state."});
        for (Node n : nodes.values()) {
            this.nodeStability.nodeArrives(n);
        }
        return nodes.size() != 0;
    }
}

