/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.pm.config;

import com.thoughtworks.xstream.XStream;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dataformat.xstream.XStreamDataFormat;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.spi.ClassResolver;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.common.config.DuccBlastGuardPredicate;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.pm.ProcessManager;
import org.apache.uima.ducc.pm.ProcessManagerComponent;
import org.apache.uima.ducc.pm.event.ProcessManagerEventListener;
import org.apache.uima.ducc.transport.DuccTransportConfiguration;
import org.apache.uima.ducc.transport.dispatcher.DuccEventDispatcher;
import org.apache.uima.ducc.transport.event.PmStateDuccEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DuccTransportConfiguration.class, CommonConfiguration.class})
public class ProcessManagerConfiguration {
    private static DuccLogger logger = new DuccLogger(ProcessManagerConfiguration.class, "ProcessManagerConfiguration");
    @Autowired
    CommonConfiguration common;
    @Autowired
    DuccTransportConfiguration processManagerTransport;

    public ProcessManagerEventListener processManagerDelegateListener(ProcessManagerComponent pm) {
        ProcessManagerEventListener pmel = new ProcessManagerEventListener(pm);
        pmel.setEndpoint(this.common.agentRequestEndpoint);
        return pmel;
    }

    public synchronized RouteBuilder routeBuilderForIncomingRequests(final String endpoint, final ProcessManagerEventListener delegate, ProcessManagerComponent pm) {
        return new RouteBuilder(){

            public void configure() {
                System.out.println("Process Manager waiting for messages on endpoint:" + endpoint);
                this.onException(Throwable.class).maximumRedeliveries(0).handled(false).process((Processor)new ErrorProcessor());
                this.from(endpoint).bean((Object)delegate);
            }
        };
    }

    private RouteBuilder routeBuilderForProcessManagerStatePost(final ProcessManagerComponent pm, final String targetEndpointToReceiveProcessManagerStateUpdate, final int statePublishRate) throws Exception {
        final ProcessManagerStateProcessor pmsp = new ProcessManagerStateProcessor(pm);
        return new RouteBuilder(){

            public void configure() {
                String methodName = "configure";
                DuccBlastGuardPredicate blastGuard = new DuccBlastGuardPredicate(pm.logger);
                logger.trace(methodName, null, new Object[]{"timer:pmStateDumpTimer?fixedRate=true&period=" + statePublishRate});
                logger.trace(methodName, null, new Object[]{"endpoint=" + targetEndpointToReceiveProcessManagerStateUpdate});
                ((ExpressionNode)this.from("timer:pmStateDumpTimer?fixedRate=true&period=" + statePublishRate).filter((Predicate)blastGuard).process((Processor)pmsp)).to(targetEndpointToReceiveProcessManagerStateUpdate);
            }
        };
    }

    @Bean
    public ProcessManagerComponent processManager() throws Exception {
        CamelContext camelContext = this.common.camelContext();
        DuccEventDispatcher eventDispatcher = this.processManagerTransport.duccEventDispatcher(this.common.agentRequestEndpoint, camelContext);
        logger.info("processManager()", null, new Object[]{"PM publishes state update to Agents on endpoint:" + this.common.agentRequestEndpoint});
        ProcessManagerComponent pm = new ProcessManagerComponent(camelContext, eventDispatcher);
        ProcessManagerEventListener delegateListener = this.processManagerDelegateListener(pm);
        delegateListener.setDuccEventDispatcher(eventDispatcher);
        pm.getContext().addRoutes((RoutesBuilder)this.routeBuilderForIncomingRequests(this.common.orchestratorStateUpdateEndpoint, delegateListener, pm));
        pm.getContext().addRoutes((RoutesBuilder)this.routeBuilderForProcessManagerStatePost(pm, this.common.pmStateUpdateEndpoint, Integer.parseInt(this.common.pmStatePublishRate)));
        return pm;
    }

    private class ProcessManagerStateProcessor
    implements Processor {
        private ProcessManager pm;

        private ProcessManagerStateProcessor(ProcessManager pm) {
            this.pm = pm;
        }

        public void process(Exchange exchange) throws Exception {
            PmStateDuccEvent jse = this.pm.getState();
            exchange.getIn().setBody((Object)jse);
        }
    }

    public class DebugProcessor
    implements Processor {
        private ProcessManagerComponent pm;

        public DebugProcessor(ProcessManagerComponent pm) {
            this.pm = pm;
        }

        public void process(Exchange exchange) throws Exception {
            String methodName = "process";
            if (this.pm.getLogLevel().toLowerCase().equals("trace")) {
                XStreamDataFormat xStreamDataFormat = new XStreamDataFormat();
                XStream xStream = xStreamDataFormat.getXStream((ClassResolver)new DefaultClassResolver());
                String marshalledEvent = xStream.toXML(exchange.getIn().getBody());
                this.pm.logAtTraceLevel(methodName, marshalledEvent);
            }
        }
    }

    public class TransportProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String methodName = "process";
            logger.info(methodName, null, new Object[]{"Transport received Event. Body Type:" + exchange.getIn().getBody().getClass().getName()});
        }
    }

    public class ErrorProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            Throwable throwable = (Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class);
            logger.error("ErrorProcessor.process", null, throwable, new Object[0]);
            throwable.printStackTrace();
        }
    }
}

