/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.database;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SimpleStatement;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.database.DbManager;
import org.apache.uima.ducc.database.DbUtil;

public class DbHandle {
    private DuccLogger logger = DuccLogger.getLogger(DbHandle.class, (String)"DB");
    DbManager manager;

    DbHandle(DbManager manager) {
        this.manager = manager;
    }

    public ResultSet execute(String sql) throws Exception {
        String methodName = "execute";
        long now = System.currentTimeMillis();
        ResultSet ret = this.manager.execute(sql);
        if (this.logger.isDebug()) {
            this.logger.debug(methodName, null, new Object[]{"Time to execute", System.currentTimeMillis() - now});
        }
        return ret;
    }

    public ResultSet execute(SimpleStatement s) {
        return this.manager.execute(s);
    }

    public ResultSet execute(BoundStatement s) {
        return this.manager.execute(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet execute(PreparedStatement ps, Object ... fields) throws Exception {
        ResultSet resultSet;
        String methodName = "execute";
        long now = System.currentTimeMillis();
        try {
            BoundStatement boundStatement = new BoundStatement(ps);
            BoundStatement bound = boundStatement.bind(fields);
            resultSet = this.execute(bound);
        }
        catch (Throwable throwable) {
            if (this.logger.isTrace()) {
                this.logger.trace(methodName, null, new Object[]{"Time to execute prepared statement:", ps.getQueryString(), System.currentTimeMillis() - now});
                StringBuffer buf = new StringBuffer("Fields for statement: ");
                for (Object o : fields) {
                    buf.append(o.toString());
                    buf.append(" ");
                }
                this.logger.trace(methodName, null, new Object[]{buf.toString()});
            }
            throw throwable;
        }
        if (this.logger.isTrace()) {
            this.logger.trace(methodName, null, new Object[]{"Time to execute prepared statement:", ps.getQueryString(), System.currentTimeMillis() - now});
            StringBuffer buf = new StringBuffer("Fields for statement: ");
            for (Object o : fields) {
                buf.append(o.toString());
                buf.append(" ");
            }
            this.logger.trace(methodName, null, new Object[]{buf.toString()});
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateProperty(String table, String row, String propkey, Object propval) throws Exception {
        boolean bl;
        String methodName = "updateProperty";
        long now = System.currentTimeMillis();
        String cql = "UPDATE " + table + " SET " + propkey + "=" + propval + " WHERE " + row;
        try {
            this.manager.execute(cql);
            bl = true;
        }
        catch (Throwable throwable) {
            this.logger.debug(methodName, null, new Object[]{"Time to update one property", propkey, System.currentTimeMillis() - now});
            throw throwable;
        }
        this.logger.debug(methodName, null, new Object[]{"Time to update one property", propkey, System.currentTimeMillis() - now});
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperties(String table, String row, Object ... props) throws Exception {
        String methodName = "updateProperties";
        long now = System.currentTimeMillis();
        if (props.length % 2 != 0) {
            throw new IllegalArgumentException("mkUpdate: need even number of props to form (k,v) list.  Found " + props.length + " props.");
        }
        String cql = DbUtil.mkUpdate(table, row, props);
        try {
            this.logger.trace(methodName, null, new Object[]{cql});
            this.manager.execute(cql);
        }
        catch (Throwable throwable) {
            this.logger.debug(methodName, null, new Object[]{"Total time to update properties", System.currentTimeMillis() - now});
            throw throwable;
        }
        this.logger.debug(methodName, null, new Object[]{"Total time to update properties", System.currentTimeMillis() - now});
    }

    PreparedStatement prepare(String cql) {
        return this.manager.prepare(cql);
    }

    void truncate(String table) throws Exception {
        this.manager.truncate(table);
    }

    void saveObject(PreparedStatement ps, Object ... fields) throws Exception {
        String methodName = "saveObject";
        long now = System.currentTimeMillis();
        BoundStatement boundStatement = new BoundStatement(ps);
        BoundStatement bound = boundStatement.bind(fields);
        this.execute(bound);
        this.logger.debug(methodName, null, new Object[]{"Time to execute prepared statement:", ps.getQueryString(), System.currentTimeMillis() - now});
    }
}

