/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.timeout;

import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.fsm.iface.IEvent;
import org.apache.uima.ducc.container.common.fsm.iface.IFsm;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.fsm.wi.IActionData;
import org.apache.uima.ducc.container.jd.log.LoggerHelper;
import org.apache.uima.ducc.container.jd.timeout.ITimeoutTask;
import org.apache.uima.ducc.container.jd.timeout.TimeoutManager;

public class TimeoutTask
implements ITimeoutTask {
    private static Logger logger = Logger.getLogger(TimeoutTask.class, IComponent.Id.JD.name());
    private IFsm fsm = null;
    private IEvent event = null;
    private IActionData actionData = null;
    private long deadline = 0L;

    public TimeoutTask(IFsm fsm, IEvent event, IActionData actionData, long deadline) {
        this.setFsm(fsm);
        this.setEvent(event);
        this.setActionData(actionData);
        this.setDeadline(deadline);
    }

    private void setFsm(IFsm value) {
        this.fsm = value;
    }

    @Override
    public IFsm getFsm() {
        return this.fsm;
    }

    private void setEvent(IEvent value) {
        this.event = value;
    }

    @Override
    public IEvent getEvent() {
        return this.event;
    }

    private void setActionData(IActionData value) {
        this.actionData = value;
    }

    @Override
    public IActionData getActionData() {
        return this.actionData;
    }

    private void setDeadline(long value) {
        this.deadline = value;
    }

    @Override
    public long getDeadline() {
        return this.deadline;
    }

    @Override
    public Object call() throws Exception {
        String location = "call";
        MessageBuffer mb = LoggerHelper.getMessageBuffer(this.actionData);
        mb.append(Standardize.Label.event.get() + this.event.getEventName());
        logger.warn(location, ILogger.null_id, mb.toString());
        TimeoutManager.getInstance().timeout(this.actionData);
        this.fsm.transition(this.event, this.actionData);
        return null;
    }
}

