/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.mh;

import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerProcess;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerThread;
import org.apache.uima.ducc.container.net.iface.IMetaCasRequester;

public class RemoteWorkerProcess
implements IRemoteWorkerProcess {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(RemoteWorkerProcess.class, IComponent.Id.JD.name());
    private String nodeName = null;
    private String nodeAddress = null;
    private String pidName = null;
    private int pid = 0;

    public static RemoteWorkerProcess factory(String nodeName, String nodeAddress, String pidName, String pid) {
        String location = "factory";
        RemoteWorkerProcess rwp = null;
        try {
            rwp = new RemoteWorkerProcess(nodeName, nodeAddress, pidName, Integer.parseInt(pid));
        }
        catch (Exception e) {
            logger.trace(location, ILogger.null_id, e, new Object[0]);
        }
        return rwp;
    }

    public RemoteWorkerProcess(IMetaCasRequester metaCasRequester) {
        this.setNodeName(metaCasRequester.getRequesterNodeName());
        this.setNodeAddress(metaCasRequester.getRequesterAddress());
        this.setPidName(metaCasRequester.getRequesterProcessName());
        this.setPid(metaCasRequester.getRequesterProcessId());
    }

    public RemoteWorkerProcess(String nodeName, String nodeAddress, String pidName, int pid) {
        this.setNodeName(nodeName);
        this.setNodeAddress(nodeAddress);
        this.setPidName(pidName);
        this.setPid(pid);
    }

    public RemoteWorkerProcess(IRemoteWorkerThread rwt) {
        this.setNodeName(rwt.getNodeName());
        this.setNodeAddress(rwt.getNodeAddress());
        this.setPidName(rwt.getPidName());
        this.setPid(rwt.getPid());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.nodeName != null) {
            sb.append(this.nodeName);
            sb.append(".");
        }
        if (this.nodeAddress != null) {
            sb.append("[");
            sb.append(this.nodeAddress);
            sb.append("]");
            sb.append(".");
        }
        sb.append(this.pid);
        if (this.pidName != null) {
            sb.append(".");
            sb.append("[");
            sb.append(this.pidName);
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public void setNodeName(String value) {
        this.nodeName = value;
    }

    @Override
    public String getNodeAddress() {
        return this.nodeAddress;
    }

    @Override
    public void setNodeAddress(String value) {
        this.nodeAddress = value;
    }

    @Override
    public String getPidName() {
        return this.pidName;
    }

    @Override
    public void setPidName(String value) {
        this.pidName = value;
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    @Override
    public void setPid(int value) {
        this.pid = value;
    }

    private int compareNodeName(RemoteWorkerProcess that) {
        int retVal = 0;
        String thisNodeName = this.getNodeName();
        String thatNodeName = that.getNodeName();
        if (thisNodeName != null && thatNodeName != null) {
            retVal = thisNodeName.compareTo(thatNodeName);
        }
        return retVal;
    }

    private int comparePid(RemoteWorkerProcess that) {
        int retVal = 0;
        Integer thisPid = new Integer(this.pid);
        Integer thatPid = new Integer(that.pid);
        retVal = thisPid.compareTo(thatPid);
        return retVal;
    }

    @Override
    public int compareTo(Object o) {
        String location = "compareTo";
        int retVal = 0;
        try {
            if (o != null) {
                RemoteWorkerProcess that = (RemoteWorkerProcess)o;
                if (retVal == 0) {
                    retVal = this.compareNodeName(that);
                }
                if (retVal == 0) {
                    retVal = this.comparePid(that);
                }
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        return retVal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        String thisNodeName = this.getNodeName();
        Integer thisPid = new Integer(this.pid);
        result = 31 * result + (thisNodeName == null ? 0 : thisNodeName.hashCode());
        result = 31 * result + (thisPid == null ? 0 : thisPid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        String location = "equals";
        boolean retVal = false;
        try {
            if (obj != null) {
                if (this == obj) {
                    retVal = true;
                } else {
                    RemoteWorkerProcess that = (RemoteWorkerProcess)obj;
                    if (this.compareTo(that) == 0) {
                        retVal = true;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        return retVal;
    }
}

