/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.sd;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.ducc.container.net.iface.IMetaCasTransaction;
import org.apache.uima.ducc.container.net.impl.MetaCasTransaction;
import org.apache.uima.ducc.container.net.impl.TransactionId;
import org.apache.uima.ducc.container.sd.DriverException;
import org.apache.uima.ducc.container.sd.iface.ServiceDriver;
import org.apache.uima.ducc.container.sd.task.DuccServiceTaskProtocolHandler;
import org.apache.uima.ducc.container.sd.task.TestTaskAllocatorCallbackListener;
import org.apache.uima.ducc.container.sd.task.error.TaskProtocolException;
import org.apache.uima.ducc.container.sd.task.iface.TaskAllocatorCallbackListener;
import org.apache.uima.ducc.container.sd.task.iface.TaskProtocolHandler;
import org.apache.uima.ducc.container.sd.task.transport.TaskTransportException;
import org.apache.uima.ducc.container.sd.task.transport.Transports;
import org.apache.uima.ducc.container.sd.task.transport.iface.TaskTransportHandler;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class DuccServiceDriver
implements ServiceDriver {
    Logger logger = UIMAFramework.getLogger(DuccServiceDriver.class);
    private TaskAllocatorCallbackListener taskAllocator;
    private TaskTransportHandler transport;
    private Transports.TransportType transportType = Transports.TransportType.HTTP;
    private TaskProtocolHandler protocolHandler = null;

    private DuccServiceDriver() {
    }

    public static DuccServiceDriver getInstance() {
        return DuccServiceDriverSingleton.instance;
    }

    @Override
    public TaskAllocatorCallbackListener getTaskAllocator() {
        return this.taskAllocator;
    }

    @Override
    public void setTaskAllocator(TaskAllocatorCallbackListener taskAllocator) {
        this.taskAllocator = taskAllocator;
    }

    @Override
    public String start() throws Exception {
        if (this.protocolHandler == null) {
            throw new DriverException("start() called before initialize()");
        }
        if (this.transport == null) {
            throw new DriverException("start() called before initialize()");
        }
        if (this.taskAllocator == null) {
            throw new DriverException("start() called before setTaskAllocator()");
        }
        String retValue = this.protocolHandler.start();
        this.transport.start();
        return retValue;
    }

    @Override
    public void stop() throws Exception {
        if (this.transport != null) {
            this.transport.stop();
        }
        if (this.protocolHandler != null) {
            this.protocolHandler.stop();
        }
    }

    @Override
    public void initialize(Properties properties) throws DriverException {
        if (Transports.TransportType.HTTP.equals((Object)this.transportType)) {
            this.transport = Transports.newHttpTransport();
            this.protocolHandler = new DuccServiceTaskProtocolHandler(this.taskAllocator);
            try {
                this.protocolHandler.initialize(properties);
                this.logger.log(Level.INFO, "... Protocol handler initialized ...");
                this.transport.setTaskProtocolHandler(this.protocolHandler);
                this.transport.initialize(properties);
                this.start();
            }
            catch (TaskProtocolException e) {
                throw new DriverException(e);
            }
            catch (TaskTransportException e) {
                throw new DriverException(e);
            }
            catch (Exception e) {
                throw new DriverException(e);
            }
        }
    }

    public void test() throws Exception {
        AtomicInteger IdGenerator = new AtomicInteger();
        MetaCasTransaction transaction = new MetaCasTransaction();
        int major = IdGenerator.addAndGet(1);
        int minor = 0;
        TransactionId tid = new TransactionId(major, minor);
        transaction.setTransactionId(tid);
        transaction.setType(IMetaCasTransaction.Type.Get);
        this.protocolHandler.handle(transaction);
        this.logger.log(Level.INFO, "Returned from Get Handler - Client Got Message");
        transaction.setType(IMetaCasTransaction.Type.Ack);
        this.protocolHandler.handle(transaction);
        this.logger.log(Level.INFO, "Returned from Ack Handler - Client Got Message");
        transaction.setType(IMetaCasTransaction.Type.End);
        this.protocolHandler.handle(transaction);
        this.logger.log(Level.INFO, "Returned from End Handler - Client Got Message");
    }

    public static void main(String[] args) {
        String port = "8888";
        String application = "/test";
        if (args.length > 0) {
            if (args.length != 2) {
                System.out.println("Two arguments required: port application (defaults: 8888 /test");
                return;
            }
            port = args[0];
            application = args[1];
        }
        try {
            Properties properties = new Properties();
            properties.put("driver.server.port", port);
            properties.put("driver.application.name", application);
            properties.put("driver.server.max.threads", "100");
            TestTaskAllocatorCallbackListener taskAllocator = new TestTaskAllocatorCallbackListener();
            DuccServiceDriver driver = DuccServiceDriver.getInstance();
            driver.setTaskAllocator(taskAllocator);
            driver.initialize(properties);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class DuccServiceDriverSingleton {
        private static final DuccServiceDriver instance = new DuccServiceDriver();

        private DuccServiceDriverSingleton() {
        }
    }
}

