/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.fsm.wi;

import org.apache.uima.ducc.common.jd.files.workitem.IRemoteLocation;
import org.apache.uima.ducc.common.jd.files.workitem.RemoteLocation;
import org.apache.uima.ducc.container.common.IJdConstants;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.JobDriver;
import org.apache.uima.ducc.container.jd.JobDriverHelper;
import org.apache.uima.ducc.container.jd.cas.CasManager;
import org.apache.uima.ducc.container.jd.cas.CasManagerStats;
import org.apache.uima.ducc.container.jd.fsm.wi.IActionData;
import org.apache.uima.ducc.container.jd.log.ErrorLogger;
import org.apache.uima.ducc.container.jd.log.LoggerHelper;
import org.apache.uima.ducc.container.jd.mh.iface.remote.IRemoteWorkerProcess;
import org.apache.uima.ducc.container.jd.timeout.TimeoutManager;
import org.apache.uima.ducc.container.jd.wi.IWorkItem;
import org.apache.uima.ducc.container.jd.wi.WiTracker;
import org.apache.uima.ducc.container.net.iface.IMetaCas;
import org.apache.uima.ducc.container.net.iface.IMetaCasTransaction;

public class ActionHelper {
    protected static String getPrintable(Throwable t) {
        StringBuffer sb = new StringBuffer();
        if (t != null) {
            StackTraceElement[] stacktrace;
            sb.append(t.toString());
            sb.append("\n");
            sb.append("\nAt:\n");
            for (StackTraceElement ste : stacktrace = t.getStackTrace()) {
                sb.append("\t");
                sb.append(ste.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    protected static void toJdErrLog(String text) {
        ErrorLogger.record(text);
    }

    protected static void jdExhausted(Logger logger, IActionData actionData) {
        String location = "jdExhausted";
        JobDriver jd = JobDriver.getInstance();
        switch (jd.getJdState()) {
            case Ended: {
                break;
            }
            default: {
                jd.advanceJdState(IMetaCasTransaction.JdState.Ended);
                MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
                mb.append(Standardize.Label.jdState.get() + (Object)((Object)JobDriver.getInstance().getJdState()));
                logger.info(location, ILogger.null_id, mb.toString());
                JobDriverHelper.getInstance().summarize();
            }
        }
    }

    protected static void checkEnded(Logger logger, IActionData actionData, CasManager cm) {
        String location = "checkEnded";
        int remainder = cm.getCasManagerStats().getUnfinishedWorkCount();
        MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
        mb.append(Standardize.Label.remainder.get() + remainder);
        logger.debug(location, ILogger.null_id, mb.toString());
        if (remainder <= 0) {
            ActionHelper.jdExhausted(logger, actionData);
        }
    }

    protected static void retryWorkItem(Logger logger, IActionData actionData, CasManager cm, IMetaCas metaCas) {
        String location = "retryWorkItem";
        MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
        logger.info(location, ILogger.null_id, mb.toString());
        TimeoutManager.getInstance().cancelTimer(actionData);
        cm.putMetaCas(metaCas, CasManagerStats.RetryReason.UserErrorRetry);
        cm.getCasManagerStats().incEndRetry();
    }

    protected static void killWorkItem(Logger logger, IActionData actionData, CasManager cm) {
        String location = "killWorkItem";
        MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
        logger.info(location, ILogger.null_id, mb.toString());
        cm.getCasManagerStats().incEndFailure();
        ActionHelper.checkEnded(logger, actionData, cm);
    }

    protected static void killProcess(Logger logger, IActionData actionData, CasManager cm, IMetaCas metaCas, IWorkItem wi, IJdConstants.DeallocateReason deallocateReason) {
        String location = "killProcess";
        WiTracker tracker = WiTracker.getInstance();
        IRemoteWorkerProcess rwp = tracker.getRemoteWorkerProcess(wi);
        if (rwp == null) {
            MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
            mb.append("remote worker process not found");
            logger.info(location, ILogger.null_id, mb.toString());
        } else {
            String nodeIp = rwp.getNodeAddress();
            String pid = "" + rwp.getPid();
            RemoteLocation remoteLocation = new RemoteLocation(nodeIp, pid);
            JobDriver jd = JobDriver.getInstance();
            jd.killProcess((IRemoteLocation)remoteLocation, deallocateReason);
            MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
            mb.append(Standardize.Label.node.get() + nodeIp);
            mb.append(Standardize.Label.pid.get() + pid);
            logger.info(location, ILogger.null_id, mb.toString());
        }
    }

    protected static void killJob(Logger logger, IActionData actionData, CasManager cm) {
        String location = "killJob";
        cm.getCasManagerStats().setKillJob();
        MessageBuffer mb = LoggerHelper.getMessageBuffer(actionData);
        logger.info(location, ILogger.null_id, mb.toString());
    }
}

