/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.cas;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;

public class CasManagerStats {
    private static Logger logger = Logger.getLogger(CasManagerStats.class, IComponent.Id.JD.name());
    private AtomicInteger crTotal = new AtomicInteger(0);
    private AtomicInteger crGets = new AtomicInteger(0);
    private AtomicInteger retryQueuePuts = new AtomicInteger(0);
    private AtomicInteger retryQueueGets = new AtomicInteger(0);
    private AtomicInteger endSuccess = new AtomicInteger(0);
    private AtomicInteger endFailure = new AtomicInteger(0);
    private AtomicInteger endRetry = new AtomicInteger(0);
    private AtomicBoolean seenAll = new AtomicBoolean(false);
    private AtomicBoolean killJob = new AtomicBoolean(false);
    private AtomicBoolean warned = new AtomicBoolean(false);
    private ConcurrentHashMap<String, AtomicInteger> retryReasonsMap = new ConcurrentHashMap();

    public boolean isExhausted() {
        boolean retVal = false;
        if (this.getCrTotal() == this.getEnded()) {
            retVal = true;
        }
        return retVal;
    }

    public boolean isPremature() {
        boolean update;
        boolean expect;
        boolean success;
        String location = "isPremature";
        boolean retVal = false;
        if (this.isSeenAll() && this.crGets.get() > 0 && this.crGets.get() == this.getEnded() && this.crGets.get() < this.crTotal.get()) {
            retVal = true;
        }
        if (retVal && (success = this.warned.compareAndSet(expect = false, update = true))) {
            MessageBuffer mb = new MessageBuffer();
            mb.append("seenAll:" + this.seenAll.get());
            mb.append("crGets:" + this.crGets.get());
            mb.append("crTotal:" + this.crTotal.get());
            mb.append("endSuccess:" + this.endSuccess.get());
            mb.append("endFailure:" + this.endFailure.get());
            logger.warn(location, ILogger.null_id, mb.toString());
        }
        return retVal;
    }

    public boolean isSeenAll() {
        boolean retVal = this.seenAll.get();
        return retVal;
    }

    public void setSeenAll() {
        this.seenAll.set(true);
    }

    public int getUnfinishedWorkCount() {
        return this.crTotal.get() - this.getEnded();
    }

    public int getPendingRetry() {
        return this.retryQueuePuts.get() - this.retryQueueGets.get();
    }

    public int getEnded() {
        return this.endSuccess.get() + this.endFailure.get();
    }

    public int getDispatched() {
        return this.crGets.get() - this.getEnded() - this.getPendingRetry();
    }

    public void setCrTotal(int value) {
        this.crTotal.set(value);
    }

    public int getCrTotal() {
        return this.crTotal.get();
    }

    public void incCrGets() {
        this.crGets.incrementAndGet();
    }

    public int getCrGets() {
        return this.crGets.get();
    }

    public void incRetryQueuePuts() {
        this.retryQueuePuts.incrementAndGet();
    }

    public int getRetryQueuePuts() {
        return this.retryQueuePuts.get();
    }

    public void incRetryQueueGets() {
        this.retryQueueGets.incrementAndGet();
    }

    public int getRetryQueueGets() {
        return this.retryQueueGets.get();
    }

    public void incRetryReasons(RetryReason retryReason) {
        if (retryReason != null) {
            String key = retryReason.name();
            this.retryReasonsMap.putIfAbsent(key, new AtomicInteger(0));
            AtomicInteger value = this.retryReasonsMap.get(key);
            value.incrementAndGet();
        }
    }

    public ConcurrentHashMap<String, AtomicInteger> getRetryReasons() {
        return this.retryReasonsMap;
    }

    public int getNumberOfPreemptions() {
        int retVal = 0;
        String key = RetryReason.ProcessPreempt.name();
        if (this.retryReasonsMap.containsKey(key)) {
            AtomicInteger value = this.retryReasonsMap.get(key);
            retVal = value.get();
        }
        return retVal;
    }

    public int getNumberOfRetrys() {
        int retVal = this.getEndRetry() - this.getNumberOfPreemptions();
        return retVal;
    }

    public void incEndSuccess() {
        this.endSuccess.incrementAndGet();
    }

    public int getEndSuccess() {
        return this.endSuccess.get();
    }

    public void incEndFailure() {
        this.endFailure.incrementAndGet();
    }

    public int getEndFailure() {
        return this.endFailure.get();
    }

    public void incEndRetry() {
        this.endRetry.incrementAndGet();
    }

    public int getEndRetry() {
        return this.endRetry.get();
    }

    public void setKillJob() {
        this.killJob.set(true);
    }

    public boolean isKillJob() {
        return this.killJob.get();
    }

    public static enum RetryReason {
        ProcessPreempt,
        ProcessVolunteered,
        ProcessDown,
        NodeDown,
        UserErrorRetry,
        TimeoutRetry;

    }
}

