/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.dgen;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ducc.common.utils.QuotedOptions;
import org.apache.uima.ducc.container.common.FlagsExtendedHelper;
import org.apache.uima.ducc.container.common.classloader.ProxyException;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.dgen.DgenException;
import org.apache.uima.ducc.container.dgen.classload.ProxyDeployableGeneration;
import org.apache.uima.ducc.container.dgen.classload.ProxyDeployableGenerationException;

public class DgenManager {
    private static Logger logger = Logger.getLogger(DgenManager.class, IComponent.Id.JD.name());
    private static DgenManager instance = null;
    private String deployable = null;
    private ProxyDeployableGeneration proxy = null;

    public static synchronized DgenManager getInstance() {
        String location = "getInstance";
        if (instance == null) {
            try {
                instance = new DgenManager();
            }
            catch (DgenException e) {
                logger.error(location, ILogger.null_id, e, new Object[0]);
            }
        }
        return instance;
    }

    public DgenManager() throws DgenException {
        this.initialize();
    }

    private void initialize() throws DgenException {
        FlagsExtendedHelper feh = FlagsExtendedHelper.getInstance();
        this.initialize(feh.getJobDirectory(), feh.getJobId(), feh.getJpDdName(), feh.getJpDdDescription(), this.convert2Integer(feh.getJpThreadCount()), feh.getJpDdBrokerURL(), feh.getJpDdBrokerEndpoint(), feh.getJpFlowController(), feh.getJpAeDescriptor(), this.convert2List(feh.getJpAeOverrides()), feh.getJpCcDescriptor(), this.convert2List(feh.getJpCcOverrides()), feh.getJpCmDescriptor(), this.convert2List(feh.getJpCmOverrides()), feh.getJpDd());
    }

    public void initialize(String jobDirectory, String jobId, String dgenName, String dgenDescription, Integer dgenThreadCount, String dgenBrokerURL, String dgenBrokerEndpoint, String flowController, String aeDescriptor, List<String> aeOverrides, String ccDescriptor, List<String> ccOverrides, String cmDescriptor, List<String> cmOverrides, String referenceByName) throws DgenException {
        String location = "initialize";
        try {
            this.proxy = new ProxyDeployableGeneration();
            if (referenceByName == null) {
                String value = this.proxy.generate(jobDirectory, jobId, dgenName, dgenDescription, dgenThreadCount, dgenBrokerURL, dgenBrokerEndpoint, flowController, cmDescriptor, cmOverrides, aeDescriptor, aeOverrides, ccDescriptor, ccOverrides);
                this.setDeployable(value);
                logger.info(location, null, "dd from parts: " + value);
            } else {
                String specification = referenceByName.trim();
                logger.info(location, null, "dd specified: " + specification);
                String value = this.proxy.generate(jobDirectory, jobId, dgenName, dgenDescription, dgenThreadCount, dgenBrokerURL, dgenBrokerEndpoint, flowController, specification);
                this.setDeployable(value);
                logger.info(location, null, "dd generated: " + value);
            }
        }
        catch (ProxyDeployableGenerationException e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
            throw new DgenException(e);
        }
        catch (ProxyException e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
            throw new DgenException(e);
        }
    }

    private List<String> convert2List(String input) {
        ArrayList list = null;
        if (input != null) {
            list = QuotedOptions.tokenizeList((String)input, (boolean)true);
        }
        return list;
    }

    private Integer convert2Integer(String input) {
        Integer retVal = null;
        retVal = input == null ? new Integer(1) : Integer.valueOf(Integer.parseInt(input));
        return retVal;
    }

    public String getDeployable() {
        return this.deployable;
    }

    private void setDeployable(String value) {
        this.deployable = value;
    }
}

