/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.classload;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.container.common.FlagsExtendedHelper;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.classloader.ContextSwitch;
import org.apache.uima.ducc.container.common.classloader.PrivateClassLoader;
import org.apache.uima.ducc.container.common.classloader.ProxyException;
import org.apache.uima.ducc.container.common.classloader.ProxyHelper;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.mh.MessageHandler;
import org.apache.uima.ducc.container.net.impl.MetaCas;

public class ProxyJobDriverCollectionReader {
    private static Logger logger = Logger.getLogger(ProxyJobDriverCollectionReader.class, IComponent.Id.JD.name());
    private URLClassLoader urlClassLoader = null;
    private String crXml = null;
    private String crCfg = null;
    private Class<?>[] nullClassArray = null;
    private Object[] nullObjectArray = null;
    private Class<?> class_JdUserCollectionReader = null;
    private Object instance_JdUserCollectionReader = null;
    private String name_getTotal = "getTotal";
    private Method method_getTotal = null;
    private Class<?> class_JdUserMetaCas = null;
    private String name_getJdUserMetaCas = "getJdUserMetaCas";
    private Method method_getJdUserMetaCas = null;
    private String name_getJdUserEmptyMetaCas = "getJdUserEmptyMetaCas";
    private Method method_getJdUserEmptyMetaCas = null;
    private String name_getSeqNo = "getSeqNo";
    private String name_getDocumentText = "getDocumentText";
    private String name_getSerializedCas = "getSerializedCas";
    private String[] requiredClasses = new String[]{"org.apache.uima.ducc.user.jd.JdUserCollectionReader", "org.apache.uima.cas.CAS"};

    public ProxyJobDriverCollectionReader() throws ProxyException {
        try {
            this.initialize();
        }
        catch (Exception e) {
            Exception userException = ProxyHelper.getTargetException(e);
            ProxyHelper.loggifyUserException(logger, userException);
            throw new ProxyException(userException.getMessage());
        }
    }

    private void initialize() throws Exception {
        FlagsExtendedHelper feh = FlagsExtendedHelper.getInstance();
        String userClasspath = feh.getUserClasspath();
        URLClassLoader classLoader = this.createClassLoader(userClasspath);
        String crXml = feh.getCollectionReaderXml();
        String crCfg = feh.getCollectionReaderCfg();
        this.construct(classLoader, crXml, crCfg);
    }

    private URLClassLoader createClassLoader(String userClasspath) throws Exception {
        URLClassLoader retVal = null;
        retVal = PrivateClassLoader.create(userClasspath);
        return retVal;
    }

    public int getTotal() throws ProxyException {
        int retVal = -1;
        try {
            retVal = (Integer)ContextSwitch.call(this.urlClassLoader, this.method_getTotal, this.instance_JdUserCollectionReader, this.nullObjectArray);
        }
        catch (Exception e) {
            Exception userException = ProxyHelper.getTargetException(e);
            ProxyHelper.loggifyUserException(logger, userException);
            throw new ProxyException(userException.getMessage());
        }
        return retVal;
    }

    private String normalizeDocId(int seqNo, String docId) {
        String location = "normalizeDocId";
        String retVal = docId;
        try {
            String max = DuccPropertiesResolver.getInstance().getFileProperty("ducc.jd.workitem.name.maximum.length");
            if (max != null) {
                int limit = Integer.parseInt(max);
                if (docId.length() > limit) {
                    retVal = docId.substring(0, limit);
                    MessageBuffer mb = new MessageBuffer();
                    mb.append(Standardize.Label.seqNo.get() + seqNo);
                    mb.append(Standardize.Label.limit.get() + limit);
                    mb.append(Standardize.Label.name.get() + docId);
                    logger.debug(location, ILogger.null_id, mb.toString());
                }
            }
        }
        catch (Exception e) {
            logger.trace(location, ILogger.null_id, e, new Object[0]);
        }
        return retVal;
    }

    public MetaCas getEmptyMetaCas() throws ProxyException {
        MetaCas retVal = null;
        try {
            this.method_getJdUserEmptyMetaCas = this.class_JdUserCollectionReader.getMethod(this.name_getJdUserEmptyMetaCas, this.nullClassArray);
            long stime = System.nanoTime();
            Object instance_metaCas = ContextSwitch.call(this.urlClassLoader, this.method_getJdUserEmptyMetaCas, this.instance_JdUserCollectionReader, this.nullObjectArray);
            MessageHandler.accumulateTimes("CR", stime);
            if (instance_metaCas != null) {
                Method method_getSeqNo = this.class_JdUserMetaCas.getMethod(this.name_getSeqNo, this.nullClassArray);
                Integer integer = (Integer)ContextSwitch.call(this.urlClassLoader, method_getSeqNo, instance_metaCas, this.nullObjectArray);
                int seqNo = integer;
                Method method_getSerializedCas = this.class_JdUserMetaCas.getMethod(this.name_getSerializedCas, this.nullClassArray);
                Object serializedCas = ContextSwitch.call(this.urlClassLoader, method_getSerializedCas, instance_metaCas, this.nullObjectArray);
                Method method_getDocumentText = this.class_JdUserMetaCas.getMethod(this.name_getDocumentText, this.nullClassArray);
                String rawDocId = (String)ContextSwitch.call(this.urlClassLoader, method_getDocumentText, instance_metaCas, this.nullObjectArray);
                String docId = this.normalizeDocId(seqNo, rawDocId);
                retVal = new MetaCas(seqNo, docId, serializedCas);
            }
        }
        catch (Exception e) {
            Exception userException = ProxyHelper.getTargetException(e);
            ProxyHelper.loggifyUserException(logger, userException);
            throw new ProxyException(userException.getMessage());
        }
        return retVal;
    }

    public MetaCas getMetaCas() throws ProxyException {
        MetaCas retVal = null;
        try {
            this.method_getJdUserMetaCas = this.class_JdUserCollectionReader.getMethod(this.name_getJdUserMetaCas, this.nullClassArray);
            long stime = System.nanoTime();
            Object instance_metaCas = ContextSwitch.call(this.urlClassLoader, this.method_getJdUserMetaCas, this.instance_JdUserCollectionReader, this.nullObjectArray);
            MessageHandler.accumulateTimes("CR", stime);
            if (instance_metaCas != null) {
                Method method_getSeqNo = this.class_JdUserMetaCas.getMethod(this.name_getSeqNo, this.nullClassArray);
                Integer integer = (Integer)ContextSwitch.call(this.urlClassLoader, method_getSeqNo, instance_metaCas, this.nullObjectArray);
                int seqNo = integer;
                Method method_getSerializedCas = this.class_JdUserMetaCas.getMethod(this.name_getSerializedCas, this.nullClassArray);
                Object serializedCas = ContextSwitch.call(this.urlClassLoader, method_getSerializedCas, instance_metaCas, this.nullObjectArray);
                Method method_getDocumentText = this.class_JdUserMetaCas.getMethod(this.name_getDocumentText, this.nullClassArray);
                String rawDocId = (String)ContextSwitch.call(this.urlClassLoader, method_getDocumentText, instance_metaCas, this.nullObjectArray);
                String docId = this.normalizeDocId(seqNo, rawDocId);
                retVal = new MetaCas(seqNo, docId, serializedCas);
            }
        }
        catch (Exception e) {
            Exception userException = ProxyHelper.getTargetException(e);
            ProxyHelper.loggifyUserException(logger, userException);
            throw new ProxyException(userException.getMessage());
        }
        return retVal;
    }

    private void construct(URLClassLoader classLoader, String crXml, String cfCfg) throws Exception {
        this.setup(classLoader, crXml, cfCfg);
        this.validate();
        this.prepare();
    }

    private void setup(URLClassLoader urlClassLoader, String crXml, String crCfg) throws Exception {
        String location = "setup";
        if (urlClassLoader == null) {
            Exception e = new Exception("missing URLClassLoader");
            logger.error(location, ILogger.null_id, e, new Object[0]);
            throw e;
        }
        this.setURLClassLoader(urlClassLoader);
        if (crXml == null) {
            Exception e = new Exception("missing CollectionReader xml");
            logger.error(location, ILogger.null_id, e, new Object[0]);
            throw e;
        }
        this.setCrXml(crXml);
        this.setCrCfg(crCfg);
    }

    private void validate() throws Exception {
        for (String className : this.requiredClasses) {
            this.loadClass(className);
        }
    }

    private void prepare() throws Exception {
        this.class_JdUserCollectionReader = this.urlClassLoader.loadClass("org.apache.uima.ducc.user.jd.JdUserCollectionReader");
        Constructor<?> constructor_JdUserCollectionReader = this.class_JdUserCollectionReader.getConstructor(String.class, String.class);
        this.instance_JdUserCollectionReader = constructor_JdUserCollectionReader.newInstance(this.crXml, this.crCfg);
        this.method_getTotal = this.class_JdUserCollectionReader.getMethod(this.name_getTotal, this.nullClassArray);
        this.class_JdUserMetaCas = this.urlClassLoader.loadClass("org.apache.uima.ducc.user.jd.JdUserMetaCas");
        this.method_getJdUserMetaCas = this.class_JdUserCollectionReader.getMethod(this.name_getJdUserMetaCas, this.nullClassArray);
    }

    private void setURLClassLoader(URLClassLoader value) {
        String location = "setURLClassLoader";
        logger.debug(location, ILogger.null_id, value);
        this.urlClassLoader = value;
    }

    private void setCrXml(String value) {
        this.crXml = value;
    }

    private void setCrCfg(String value) {
        this.crCfg = value;
    }

    private void loadClass(String className) throws Exception {
        URL[] urls;
        String location = "loadClass";
        MessageBuffer mb = new MessageBuffer();
        mb.append(Standardize.Label.loading.get() + className);
        logger.debug(location, ILogger.null_id, mb.toString());
        for (URL url : urls = this.urlClassLoader.getURLs()) {
            logger.trace(location, ILogger.null_id, url);
        }
        Class<?> loadedClass = this.urlClassLoader.loadClass(className);
        mb = new MessageBuffer();
        mb.append(Standardize.Label.loaded.get() + loadedClass.getName());
        logger.trace(location, ILogger.null_id, mb.toString());
    }
}

