/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.cas;

import java.util.concurrent.LinkedBlockingQueue;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.classloader.ProxyException;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.JobDriverException;
import org.apache.uima.ducc.container.jd.cas.CasManagerStats;
import org.apache.uima.ducc.container.jd.classload.ProxyJobDriverCollectionReader;
import org.apache.uima.ducc.container.net.iface.IMetaCas;
import org.apache.uima.ducc.container.net.impl.MetaCas;

public class CasManager {
    private static Logger logger = Logger.getLogger(CasManager.class, IComponent.Id.JD.name());
    private ProxyJobDriverCollectionReader pjdcr = null;
    private LinkedBlockingQueue<IMetaCas> cacheQueue = new LinkedBlockingQueue();
    private CasManagerStats casManagerStats = new CasManagerStats();

    public CasManager() throws JobDriverException {
        this.initialize();
    }

    private void initialize() throws JobDriverException {
        String location = "initialize";
        try {
            this.pjdcr = new ProxyJobDriverCollectionReader();
            this.casManagerStats.setCrTotal(this.pjdcr.getTotal());
        }
        catch (ProxyException e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
            throw new JobDriverException();
        }
    }

    public IMetaCas getEmptyMetaCas() throws ProxyException {
        MetaCas retVal = null;
        if (retVal == null && (retVal = this.pjdcr.getEmptyMetaCas()) != null) {
            this.casManagerStats.incCrGets();
        }
        return retVal;
    }

    public IMetaCas getMetaCas() throws ProxyException, JobDriverException {
        IMetaCas retVal = this.dequeueMetaCas();
        if (retVal == null) {
            retVal = this.pjdcr.getMetaCas();
            if (retVal != null) {
                this.casManagerStats.incCrGets();
            } else {
                this.casManagerStats.setSeenAll();
            }
        }
        return retVal;
    }

    private IMetaCas dequeueMetaCas() throws JobDriverException {
        String location = "dequeueMetaCas";
        IMetaCas metaCas = this.cacheQueue.poll();
        if (metaCas != null) {
            this.casManagerStats.incRetryQueueGets();
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.seqNo.get() + metaCas.getSystemKey());
            mb.append(Standardize.Label.puts.get() + this.casManagerStats.getRetryQueuePuts());
            mb.append(Standardize.Label.gets.get() + this.casManagerStats.getRetryQueueGets());
            logger.debug(location, ILogger.null_id, mb);
        }
        return metaCas;
    }

    public void putMetaCas(IMetaCas metaCas, CasManagerStats.RetryReason retryReason) {
        this.queueMetaCas(metaCas, retryReason);
    }

    private void queueMetaCas(IMetaCas metaCas, CasManagerStats.RetryReason retryReason) {
        String location = "queueMetaCas";
        this.cacheQueue.add(metaCas);
        this.casManagerStats.incRetryQueuePuts();
        this.casManagerStats.incRetryReasons(retryReason);
        MessageBuffer mb = new MessageBuffer();
        mb.append(Standardize.Label.seqNo.get() + metaCas.getSystemKey());
        mb.append(Standardize.Label.puts.get() + this.casManagerStats.getRetryQueuePuts());
        mb.append(Standardize.Label.gets.get() + this.casManagerStats.getRetryQueueGets());
        mb.append(Standardize.Label.reason.get() + retryReason.name());
        logger.debug(location, ILogger.null_id, mb);
    }

    public CasManagerStats getCasManagerStats() {
        return this.casManagerStats;
    }
}

