/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.common.fsm;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.fsm.FsmException;
import org.apache.uima.ducc.container.common.fsm.StateEventKey;
import org.apache.uima.ducc.container.common.fsm.StateEventValue;
import org.apache.uima.ducc.container.common.fsm.iface.IAction;
import org.apache.uima.ducc.container.common.fsm.iface.IEvent;
import org.apache.uima.ducc.container.common.fsm.iface.IFsmBuilder;
import org.apache.uima.ducc.container.common.fsm.iface.IState;
import org.apache.uima.ducc.container.common.fsm.iface.IStateEventKey;
import org.apache.uima.ducc.container.common.fsm.iface.IStateEventValue;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;

public class Fsm
implements IFsmBuilder {
    private static Logger logger = Logger.getLogger(Fsm.class, IComponent.Id.JD.name());
    private ConcurrentHashMap<IStateEventKey, IStateEventValue> map = new ConcurrentHashMap();
    private IState stateInitial = null;
    private IState stateCurrent = null;
    private IState statePrevious = null;

    @Override
    public void add(IState current, IEvent event, IAction action, IState next) throws FsmException {
        String location = "add";
        StateEventKey key = new StateEventKey(current, event);
        StateEventValue value = new StateEventValue(action, next);
        IStateEventValue result = this.putIfAbsent(key, value);
        if (result != null) {
            MessageBuffer mb = new MessageBuffer();
            mb.append("duplicate");
            mb.append(Standardize.Label.state.get() + current.getName());
            mb.append(Standardize.Label.event.get() + event.getName());
            throw new FsmException(mb.toString());
        }
        MessageBuffer mb = new MessageBuffer();
        mb.append(Standardize.Label.state.get() + current.getName());
        mb.append(Standardize.Label.event.get() + event.getName());
        logger.trace(location, ILogger.null_id, mb.toString());
    }

    @Override
    public void addInitial(IState current, IEvent event, IAction action, IState next) throws FsmException {
        this.add(current, event, action, next);
        this.setStateCurrent(current);
    }

    @Override
    public void initial(IState state) throws FsmException {
        this.setStateInitial(state);
        this.setStateCurrent(state);
    }

    @Override
    public boolean isStateInitial() {
        boolean retVal = false;
        IState s0 = this.getStateInitial();
        IState s1 = this.getStateCurrent();
        if (s0 != null && s1 != null) {
            String n0 = s0.getName();
            String n1 = s1.getName();
            if (n0 != null && n1 != null) {
                retVal = n0.equals(n1);
            }
        }
        return retVal;
    }

    private void setStateInitial(IState value) {
        this.stateInitial = value;
    }

    private IState getStateInitial() {
        return this.stateInitial;
    }

    private void setStateCurrent(IState value) {
        this.stateCurrent = value;
    }

    @Override
    public IState getStateCurrent() {
        return this.stateCurrent;
    }

    private void setStatePrevious(IState value) {
        this.statePrevious = value;
    }

    @Override
    public IState getStatePrevious() {
        return this.statePrevious;
    }

    private IStateEventValue putIfAbsent(IStateEventKey key, IStateEventValue value) {
        String location = "putIfAbsent";
        MessageBuffer mb = new MessageBuffer();
        mb.append(Standardize.Label.state.get() + key.getState().getName());
        mb.append(Standardize.Label.event.get() + key.getEvent().getName());
        mb.append(Standardize.Label.hash.get() + key.hashCode());
        logger.trace(location, ILogger.null_id, mb.toString());
        return this.map.putIfAbsent(key, value);
    }

    private IStateEventValue get(IStateEventKey key) {
        String location = "get";
        MessageBuffer mb = new MessageBuffer();
        mb.append(Standardize.Label.state.get() + key.getState().getName());
        mb.append(Standardize.Label.event.get() + key.getEvent().getName());
        mb.append(Standardize.Label.hash.get() + key.hashCode());
        logger.trace(location, ILogger.null_id, mb.toString());
        IStateEventValue value = this.map.get(key);
        return value;
    }

    @Override
    public void transitionLog(IEvent event, Object actionData) {
        String location = "transition";
        MessageBuffer mb = new MessageBuffer();
        mb.append(Standardize.Label.curr.get() + this.getStateCurrent().getName());
        mb.append(Standardize.Label.prev.get() + this.getStatePrevious().getName());
        mb.append(Standardize.Label.event.get() + event.getName());
        logger.trace(location, ILogger.null_id, mb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transition(IEvent event, Object actionData) throws FsmException {
        try {
            Fsm fsm = this;
            synchronized (fsm) {
                IState _stateCurrent = this.getStateCurrent();
                StateEventKey key = new StateEventKey(_stateCurrent, event);
                IStateEventValue value = this.get(key);
                if (value == null) {
                    MessageBuffer mb = new MessageBuffer();
                    mb.append("undefined");
                    mb.append(Standardize.Label.state.get() + _stateCurrent.getName());
                    mb.append(Standardize.Label.event.get() + event.getName());
                    throw new FsmException(mb.toString());
                }
                IState _statePrevious = _stateCurrent;
                _stateCurrent = value.getState();
                this.setStateCurrent(_stateCurrent);
                this.setStatePrevious(_statePrevious);
                this.transitionLog(event, actionData);
                IAction action = value.getAction();
                action.engage(actionData);
            }
        }
        catch (Exception e) {
            throw new FsmException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws FsmException {
        String location = "reset";
        try {
            Fsm fsm = this;
            synchronized (fsm) {
                IState _stateCurrent = this.getStateInitial();
                IState _statePrevious = this.getStateCurrent();
                if (!_stateCurrent.equals(_statePrevious)) {
                    MessageBuffer mb = new MessageBuffer();
                    mb.append(Standardize.Label.curr.get() + _stateCurrent.getName());
                    mb.append(Standardize.Label.prev.get() + _statePrevious.getName());
                    logger.info(location, ILogger.null_id, mb.toString());
                }
            }
        }
        catch (Exception e) {
            throw new FsmException(e);
        }
    }
}

