/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.common.classloader;

import java.lang.reflect.InvocationTargetException;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.classloader.ProxyException;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;

public class ProxyLogger {
    private static Logger logger = Logger.getLogger(ProxyLogger.class, IComponent.Id.JD.name());

    public static void loggifyUserException(Exception e) {
        String location = "loggifyUserException";
        if (e != null) {
            if (e instanceof ProxyException) {
                Throwable t = e.getCause();
                if (t instanceof Exception) {
                    Exception cause = (Exception)t;
                    ProxyLogger.loggifyUserException(cause);
                } else {
                    MessageBuffer mb = new MessageBuffer();
                    mb.append(Standardize.Label.classname.get() + e.getClass().getName());
                    logger.debug(location, ILogger.null_id, mb);
                    logger.error(location, ILogger.null_id, e, new Object[0]);
                }
            } else if (e instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)e;
                Throwable t = ite.getTargetException();
                if (t instanceof Exception) {
                    Exception jdUserException = (Exception)t;
                    String message = jdUserException.getMessage();
                    ProxyLogger.loggifyUserException(message);
                } else {
                    MessageBuffer mb = new MessageBuffer();
                    mb.append(Standardize.Label.classname.get() + e.getClass().getName());
                    logger.debug(location, ILogger.null_id, mb);
                    logger.error(location, ILogger.null_id, e, new Object[0]);
                }
            } else {
                MessageBuffer mb = new MessageBuffer();
                mb.append(Standardize.Label.classname.get() + e.getClass().getName());
                logger.debug(location, ILogger.null_id, mb);
                logger.error(location, ILogger.null_id, e, new Object[0]);
            }
        } else {
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.exception.get() + null);
            logger.debug(location, ILogger.null_id, mb);
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }

    private static void loggifyUserException(String message) {
        String location = "loggify";
        if (message != null) {
            logger.error(location, ILogger.null_id, message);
        } else {
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.instance.get() + null);
            logger.debug(location, ILogger.null_id, mb);
        }
    }
}

