/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.wi.perf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.common.jd.files.JobPerformanceSummary;
import org.apache.uima.ducc.common.jd.files.JobPerformanceSummaryData;
import org.apache.uima.ducc.common.jd.files.JobPerformanceSummaryJsonGz;
import org.apache.uima.ducc.common.jd.files.perf.PerformanceMetricsSummaryItem;
import org.apache.uima.ducc.common.utils.FormatHelper;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.SynchronizedStats;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.wi.perf.IWorkItemPerformanceInfo;
import org.apache.uima.ducc.container.jd.wi.perf.IWorkItemPerformanceKeeper;
import org.apache.uima.ducc.container.jd.wi.perf.WorkItemPerformanceInfo;

public class WorkItemPerformanceKeeper
implements IWorkItemPerformanceKeeper {
    private static Logger logger = Logger.getLogger(WorkItemPerformanceKeeper.class, IComponent.Id.JD.name());
    private String logDir = null;
    private AtomicLong count = new AtomicLong(0L);
    private AtomicLong total = new AtomicLong(0L);
    private ConcurrentHashMap<String, Data> map = new ConcurrentHashMap();

    public WorkItemPerformanceKeeper(String logDir) {
        this.setLogDir(logDir);
    }

    private void setLogDir(String value) {
        this.logDir = value;
    }

    @Override
    public List<IWorkItemPerformanceInfo> dataGet() {
        ArrayList<IWorkItemPerformanceInfo> list = new ArrayList<IWorkItemPerformanceInfo>();
        for (Map.Entry<String, Data> entry : this.map.entrySet()) {
            String name = entry.getKey();
            Data data = entry.getValue();
            String uniqueName = data.uniqueName;
            SynchronizedStats stats = data.synchronizedStats;
            double count = stats.getNum();
            double time = stats.getSum();
            double pctOfTime = 0.0;
            if (this.total.get() > 0L) {
                pctOfTime = time * (double)(100L / this.total.get());
            }
            double avg = stats.getMean();
            double min = stats.getMin();
            double max = stats.getMax();
            WorkItemPerformanceInfo item = new WorkItemPerformanceInfo(name, uniqueName, count, time, pctOfTime, avg, min, max);
            list.add(item);
        }
        return list;
    }

    @Override
    public void count() {
        this.count.addAndGet(1L);
    }

    @Override
    public void dataAdd(String name, String uniqueName, long time) {
        String location = "dataAdd";
        try {
            Data data;
            String key = name;
            if (!this.map.containsKey(key)) {
                data = new Data(uniqueName, new SynchronizedStats());
                this.map.putIfAbsent(key, data);
            }
            data = this.map.get(key);
            SynchronizedStats stats = data.synchronizedStats;
            stats.addValue(time);
            this.total.addAndGet(time);
            long lTimeSum = (long)stats.getSum();
            String timeSum = FormatHelper.duration((long)lTimeSum, (FormatHelper.Precision)FormatHelper.Precision.Tenths);
            long lTimeAvg = (long)stats.getMean();
            String timeAvg = FormatHelper.duration((long)lTimeAvg, (FormatHelper.Precision)FormatHelper.Precision.Tenths);
            long lTimeMin = (long)stats.getMin();
            String timeMin = FormatHelper.duration((long)lTimeMin, (FormatHelper.Precision)FormatHelper.Precision.Tenths);
            long lTimeMax = (long)stats.getMax();
            String timeMax = FormatHelper.duration((long)lTimeMax, (FormatHelper.Precision)FormatHelper.Precision.Tenths);
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.name.get() + name);
            mb.append(Standardize.Label.sum.get() + timeSum);
            mb.append(Standardize.Label.avg.get() + timeAvg);
            mb.append(Standardize.Label.min.get() + timeMin);
            mb.append(Standardize.Label.max.get() + timeMax);
            mb.append(Standardize.Label.count.get() + this.count.get());
            mb.append(Standardize.Label.total.get() + this.total.get());
            logger.debug(location, ILogger.null_id, mb.toString());
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }

    private PerformanceMetricsSummaryItem create(IWorkItemPerformanceInfo wipi) {
        PerformanceMetricsSummaryItem retVal = new PerformanceMetricsSummaryItem(wipi.getName(), wipi.getUniqueName(), (long)wipi.getTime(), (long)wipi.getCount(), (long)wipi.getMin(), (long)wipi.getMax());
        return retVal;
    }

    @Override
    public void publish() {
        String location = "publish";
        try {
            List<IWorkItemPerformanceInfo> list = this.dataGet();
            ConcurrentSkipListMap<String, JobPerformanceSummary> map = new ConcurrentSkipListMap<String, JobPerformanceSummary>();
            for (IWorkItemPerformanceInfo wipi : list) {
                PerformanceMetricsSummaryItem item = this.create(wipi);
                JobPerformanceSummary jps = new JobPerformanceSummary();
                jps.setAnalysisTime(item.getAnalysisTime());
                jps.setAnalysisTimeMax(item.getAnalysisTimeMax());
                jps.setAnalysisTimeMin(item.getAnalysisTimeMin());
                jps.setNumProcessed(item.getNumProcessed());
                jps.setName(item.getName());
                jps.setUniqueName(item.getUniqueName());
                map.put(jps.getUniqueName(), jps);
            }
            Integer casCount = new Integer((int)this.count.get());
            JobPerformanceSummaryData data = new JobPerformanceSummaryData(map, casCount);
            JobPerformanceSummaryJsonGz jsonGz = new JobPerformanceSummaryJsonGz(this.logDir);
            jsonGz.exportData(data);
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
    }

    private class Data {
        public String uniqueName;
        public SynchronizedStats synchronizedStats;

        public Data(String uniqueName, SynchronizedStats synchronizedStats) {
            this.uniqueName = uniqueName;
            this.synchronizedStats = synchronizedStats;
        }
    }
}

