/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.classload;

import java.lang.reflect.Method;
import java.net.URLClassLoader;
import org.apache.uima.ducc.common.container.FlagsHelper;
import org.apache.uima.ducc.container.common.classloader.PrivateClassLoader;
import org.apache.uima.ducc.container.common.classloader.ProxyLogger;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.JobDriverException;
import org.apache.uima.ducc.container.jd.classload.ProxyJobDriverDirective;

public class ProxyJobDriverErrorHandler {
    private static Logger logger = Logger.getLogger(ProxyJobDriverErrorHandler.class, IComponent.Id.JD.name());
    private URLClassLoader classLoader = null;
    private Object objectInstance = null;
    private Method methodInstanceHandle = null;
    private Method methodInstanceIsKillJob = null;
    private Method methodInstanceIsKillProcess = null;
    private Method methodInstanceIsKillWorkItem = null;
    private static String packageName = "org.apache.uima.ducc.";
    private static String defaultClassName = packageName + "ErrorHandler";
    private static String directiveInterfaceName = packageName + "IErrorHandlerDirective";

    public ProxyJobDriverErrorHandler() throws JobDriverException {
        try {
            this.initialize();
        }
        catch (Exception e) {
            ProxyLogger.loggifyUserException(e);
            throw new JobDriverException();
        }
    }

    private void initialize() throws Exception {
        Method[] directiveMethods;
        Method[] classMethods;
        String className;
        String userClasspath;
        String location = "initialize";
        FlagsHelper fh = FlagsHelper.getInstance();
        String[] classpath = fh.stringToArray(userClasspath = fh.getUserClasspath());
        if (classpath != null) {
            for (String item : classpath) {
                logger.trace(location, ILogger.null_id, item);
            }
        }
        if ((className = fh.getUserErrorHandlerClassname()) == null) {
            className = defaultClassName;
        }
        String initializationData = fh.getUserErrorHandlerCfg();
        this.classLoader = this.createClassLoader(userClasspath);
        Class<?> classAnchor = this.classLoader.loadClass(className);
        this.objectInstance = classAnchor.newInstance();
        String methodNameInitialize = "initialize";
        Method methodInstanceInitialize = classAnchor.getMethod(methodNameInitialize, String.class);
        methodInstanceInitialize.invoke(this.objectInstance, initializationData);
        for (Method method : classMethods = classAnchor.getMethods()) {
            Class<?>[] types;
            if (!method.getName().equals("handle") || (types = method.getParameterTypes()).length != 2 || !((Object)types[0]).toString().contains("String") || !((Object)types[1]).toString().contains("Object")) continue;
            this.methodInstanceHandle = method;
            break;
        }
        Class<?> directiveAnchor = this.classLoader.loadClass(directiveInterfaceName);
        for (Method method : directiveMethods = directiveAnchor.getMethods()) {
            Class<?>[] types = method.getParameterTypes();
            if (types.length != 0) continue;
            if (method.getName().equals("isKillJob")) {
                this.methodInstanceIsKillJob = method;
                continue;
            }
            if (method.getName().equals("isKillProcess")) {
                this.methodInstanceIsKillProcess = method;
                continue;
            }
            if (!method.getName().equals("isKillWorkItem")) continue;
            this.methodInstanceIsKillWorkItem = method;
        }
    }

    private URLClassLoader createClassLoader(String userClasspath) throws Exception {
        URLClassLoader retVal = null;
        retVal = PrivateClassLoader.create(userClasspath);
        return retVal;
    }

    public ProxyJobDriverDirective handle(String serializedCAS, Object userException) throws JobDriverException {
        String location = "handle";
        ProxyJobDriverDirective retVal = new ProxyJobDriverDirective();
        try {
            Object[] plist = new Object[]{serializedCAS, userException};
            Object directive = this.methodInstanceHandle.invoke(this.objectInstance, plist);
            boolean isKillJob = (Boolean)this.methodInstanceIsKillJob.invoke(directive, new Object[0]);
            boolean isKillProcess = (Boolean)this.methodInstanceIsKillProcess.invoke(directive, new Object[0]);
            boolean isKillWorkItem = (Boolean)this.methodInstanceIsKillWorkItem.invoke(directive, new Object[0]);
            retVal = new ProxyJobDriverDirective(isKillJob, isKillProcess, isKillWorkItem);
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        return retVal;
    }

    public ProxyJobDriverDirective handle(String serializedCAS) throws JobDriverException {
        String location = "handle";
        ProxyJobDriverDirective retVal = new ProxyJobDriverDirective();
        try {
            boolean isKillJob = false;
            boolean isKillProcess = false;
            boolean isKillWorkItem = false;
            retVal = new ProxyJobDriverDirective(isKillJob, isKillProcess, isKillWorkItem);
        }
        catch (Exception e) {
            logger.error(location, ILogger.null_id, e, new Object[0]);
        }
        return retVal;
    }
}

