/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

public class SystemPropertyResolver {
    private static String trimComments(String val) {
        String answer = "";
        int ndx = val.indexOf("#");
        answer = ndx >= 0 ? val.substring(0, ndx) : val.trim();
        return answer.trim();
    }

    private static int toInt(String k, String v) {
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException n) {
            throw new IllegalArgumentException("Value for int property " + k + " is not a number: " + v);
        }
    }

    private static long toLong(String k, String v) {
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException n) {
            throw new IllegalArgumentException("Value for long property " + k + " is not a number: " + v);
        }
    }

    public static int getIntProperty(String k) {
        String v = System.getProperty(k);
        if (v == null) {
            throw new IllegalArgumentException("Can't find property " + k);
        }
        v = SystemPropertyResolver.trimComments(v);
        return SystemPropertyResolver.toInt(k, v);
    }

    public static int getIntProperty(String k, int dflt) {
        String v = System.getProperty(k);
        if (v == null) {
            return dflt;
        }
        v = SystemPropertyResolver.trimComments(v);
        return SystemPropertyResolver.toInt(k, v);
    }

    public static long getLongProperty(String k) {
        String v = System.getProperty(k);
        if (v == null) {
            throw new IllegalArgumentException("Can't find property " + k);
        }
        v = SystemPropertyResolver.trimComments(v);
        return SystemPropertyResolver.toLong(k, v);
    }

    public static long getLongProperty(String k, long dflt) {
        String v = System.getProperty(k);
        if (v == null) {
            return dflt;
        }
        v = SystemPropertyResolver.trimComments(v);
        return SystemPropertyResolver.toLong(k, v);
    }

    public static String getStringProperty(String k) {
        String v = System.getProperty(k);
        if (v == null) {
            throw new IllegalArgumentException("Can't find property " + k);
        }
        return SystemPropertyResolver.trimComments(v);
    }

    public static String getStringProperty(String k, String dflt) {
        String v = System.getProperty(k);
        if (v == null) {
            return dflt;
        }
        return SystemPropertyResolver.trimComments(v);
    }

    public static boolean getBooleanProperty(String k, boolean dflt) {
        String v = System.getProperty(k);
        if (v == null) {
            return dflt;
        }
        return (v = SystemPropertyResolver.trimComments(v)).equalsIgnoreCase("t") || v.equalsIgnoreCase("true");
    }
}

