/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.persistence.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.uima.ducc.common.persistence.services.IStateServices;
import org.apache.uima.ducc.common.persistence.services.StateServicesDirectory;
import org.apache.uima.ducc.common.persistence.services.StateServicesSet;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.IOHelper;
import org.apache.uima.ducc.common.utils.id.DuccId;

public class StateServices
implements IStateServices {
    private DuccLogger logger = null;

    StateServices() {
    }

    @Override
    public boolean init(DuccLogger logger) {
        this.logger = logger;
        this.mkdirs();
        return true;
    }

    private void mkdirs() {
        IOHelper.mkdirs(svc_reg_dir);
        IOHelper.mkdirs(svc_hist_dir);
    }

    private String mkfilename(long id, String type) {
        return svc_reg_dir + Long.toString(id) + "." + type;
    }

    private String mkfilename(DuccId id, String type) {
        return this.mkfilename(id.getFriendly(), type);
    }

    private ArrayList<Long> getList(String type) {
        String location = "getList";
        ArrayList<Long> retVal = new ArrayList<Long>();
        try {
            this.logger.debug(location, null, svc_reg_dir);
            File folder = new File(svc_reg_dir);
            File[] listOfFiles = folder.listFiles();
            if (listOfFiles != null) {
                for (int i = 0; i < listOfFiles.length; ++i) {
                    String name;
                    if (!listOfFiles[i].isFile() || !(name = listOfFiles[i].getName()).endsWith("." + type)) continue;
                    int ndx = name.lastIndexOf(".");
                    name = name.substring(0, ndx);
                    retVal.add(Long.parseLong(name));
                }
            }
        }
        catch (Exception e) {
            this.logger.error(location, null, e, new Object[0]);
        }
        return retVal;
    }

    private ArrayList<Long> getSvcList() {
        return this.getList("svc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DuccProperties getProperties(String name) {
        String location = "getProperties";
        DuccProperties properties = new DuccProperties();
        properties.ignorePlaceholders();
        try (FileInputStream fis = new FileInputStream(name);){
            properties.load(fis);
        }
        catch (Exception e) {
            this.logger.error(location, null, e, new Object[0]);
        }
        return properties;
    }

    @Override
    public StateServicesDirectory getStateServicesDirectory() throws Exception {
        String location = "getStateServicesDirectory";
        StateServicesDirectory ssd = null;
        try {
            ssd = new StateServicesDirectory();
            ArrayList<Long> svcList = this.getSvcList();
            this.logger.trace(location, null, svcList.size());
            for (Long entry : svcList) {
                try {
                    StateServicesSet sss = new StateServicesSet();
                    String fnSvc = this.mkfilename(entry, "svc");
                    String fnMeta = this.mkfilename(entry, "meta");
                    DuccProperties propertiesSvc = this.getProperties(fnSvc);
                    sss.put("svc", propertiesSvc);
                    DuccProperties propertiesMeta = this.getProperties(fnMeta);
                    sss.put("meta", propertiesMeta);
                    ssd.put(entry, sss);
                }
                catch (Exception e) {
                    this.logger.error(location, null, e, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(location, null, e, new Object[0]);
        }
        return ssd;
    }

    /*
     * Exception decompiling
     */
    private synchronized boolean writeProperties(DuccId id, Properties props, File pfile, File pfile_tmp, String type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean saveProperties(DuccId id, Properties props, File pfile, File pfile_tmp, String type) {
        int max = 5;
        for (int i = 0; i < max; ++i) {
            if (!this.writeProperties(id, props, pfile, pfile_tmp, type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean storeProperties(DuccId id, Properties svcprops, Properties metaprops) {
        File svcfile = new File(this.mkfilename(id, "svc"));
        File metafile = new File(this.mkfilename(id, "meta"));
        boolean ok = true;
        File tmpfile = new File(svcfile.toString() + ".tmp");
        if (this.saveProperties(id, svcprops, svcfile, tmpfile, "svc")) {
            tmpfile = new File(metafile.toString() + ".tmp");
            ok = this.saveProperties(id, metaprops, metafile, tmpfile, "meta");
        }
        if (!ok) {
            metafile.delete();
            svcfile.delete();
        }
        return ok;
    }

    private boolean updateProperties(DuccId serviceId, Properties props, String type) {
        File f = new File(this.mkfilename(serviceId, type));
        File tmpf = new File(f.toString() + ".tmp");
        return this.saveProperties(serviceId, props, f, tmpf, type);
    }

    @Override
    public boolean updateJobProperties(DuccId serviceId, Properties props) {
        return this.updateProperties(serviceId, props, "svc");
    }

    @Override
    public boolean updateMetaProperties(DuccId serviceId, Properties props) {
        return this.updateProperties(serviceId, props, "meta");
    }

    public void deleteProperties(long serviceId) {
        String svcfile = this.mkfilename(serviceId, "svc");
        String metafile = this.mkfilename(serviceId, "meta");
        File pf = new File(svcfile);
        pf.delete();
        File mf = new File(metafile);
        mf.delete();
    }

    public void deleteProperties(DuccId id) {
        this.deleteProperties(id.getFriendly());
    }

    @Override
    public boolean moveToHistory(DuccId id, Properties svc, Properties meta) throws Exception {
        String methodName = "moveToHistory";
        boolean ret = true;
        File mfh = new File(svc_hist_dir + id + ".meta");
        try {
            FileOutputStream fos = new FileOutputStream(mfh);
            meta.store(fos, "Archived meta descriptor");
            fos.close();
        }
        catch (Exception e) {
            this.logger.warn(methodName, null, id + ": Unable to save history to \"" + mfh.toString(), ": ", e.toString() + "\"");
        }
        String meta_filename = svc_reg_dir + id + ".meta";
        File mf = new File(meta_filename);
        mf.delete();
        File pfh = new File(svc_hist_dir + id + ".svc");
        try {
            FileOutputStream fos = new FileOutputStream(pfh);
            svc.store(fos, "Archived svc properties.");
            fos.close();
        }
        catch (Exception e) {
            this.logger.warn(methodName, null, id + ":Unable to save history to \"" + pfh.toString(), ": ", e.toString() + "\"");
            ret = false;
        }
        String props_filename = svc_reg_dir + id + ".svc";
        File pf = new File(props_filename);
        pf.delete();
        return ret;
    }

    @Override
    public void shutdown() {
    }
}

