/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.config;

import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class DuccBlastGuardPredicate
implements Predicate {
    private DateTime dt;
    DuccLogger logger;

    public DuccBlastGuardPredicate(DuccLogger logger) {
        this.logger = logger;
    }

    public synchronized boolean matches(Exchange exchange) {
        String methodName = "DuccNodeFilter.matches";
        boolean result = false;
        try {
            if (this.dt == null) {
                this.dt = new DateTime();
                return true;
            }
            Duration interval = new Duration((ReadableInstant)this.dt, (ReadableInstant)new Instant());
            this.dt = new DateTime();
            if (interval.isShorterThan((ReadableDuration)Duration.standardSeconds((long)1L))) {
                this.logger.warn(methodName, null, "...... BlasTGuard ON ... Disposing Message .... Interval Since the Last Message:" + interval.toString());
                return false;
            }
            result = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.logger.error(methodName, null, e, new Object[0]);
        }
        return result;
    }
}

