/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.ducc.common.NodeConfiguration;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.Utils;

public class DuccSchedulerClasses {
    public static final String FAIR_SHARE = "FAIR_SHARE";
    public static final String FIXED_SHARE = "FIXED_SHARE";
    public static final String RESERVE = "RESERVE";
    public static final String JobDriver = "JobDriver";
    private static DuccSchedulerClasses instance = null;
    private long lastModified = 0L;
    private NodeConfiguration nodeConfiguration = null;
    private String fileName = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DuccSchedulerClasses getInstance() {
        Class<DuccSchedulerClasses> clazz = DuccSchedulerClasses.class;
        synchronized (DuccSchedulerClasses.class) {
            if (instance == null) {
                instance = new DuccSchedulerClasses();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DuccSchedulerClasses() {
        String dir_home = Utils.findDuccHome();
        String key = "ducc.rm.class.definitions";
        String file_classes = DuccPropertiesResolver.getInstance().getFileProperty(key);
        String dir_resources = "resources";
        this.fileName = dir_home + File.separator + dir_resources + File.separator + file_classes;
    }

    public String getProperty(Properties properties, String name) {
        if (properties == null) {
            return null;
        }
        String retVal = "";
        String property = properties.getProperty(name);
        if (property != null) {
            retVal = property.trim();
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeConfiguration readConfiguration() throws Exception {
        File file = new File(this.fileName);
        if (this.lastModified != file.lastModified()) {
            DuccSchedulerClasses duccSchedulerClasses = this;
            synchronized (duccSchedulerClasses) {
                if (this.lastModified != file.lastModified()) {
                    this.nodeConfiguration = new NodeConfiguration(this.fileName, null, null, null);
                    this.nodeConfiguration.readConfiguration();
                    this.lastModified = file.lastModified();
                }
            }
        }
        return this.nodeConfiguration;
    }

    public Map<String, DuccProperties> getClasses() throws Exception {
        return this.readConfiguration().getClasses();
    }

    public boolean isPreemptable(String class_name) throws Exception {
        boolean retVal = false;
        DuccProperties properties = this.readConfiguration().getClass(class_name);
        if (properties == null) {
            throw new IllegalArgumentException("Invalid scheduling_class: " + class_name);
        }
        String policy = this.getProperty(properties, "policy");
        if (policy.equals(FAIR_SHARE)) {
            retVal = true;
        }
        return retVal;
    }

    private String getNodepoolDefault(NodeConfiguration nc) {
        String retVal = "--default--";
        String nodepool = nc.getFirstNodepool();
        if (nodepool != null) {
            retVal = nodepool;
        }
        return retVal;
    }

    private String getNodepoolForNode(NodeConfiguration nc, String node, String defaultNodePool) {
        String retVal = defaultNodePool;
        String nodepool = nc.getNodePoolNameForNode(node);
        if (nodepool != null) {
            retVal = nodepool;
        }
        return retVal;
    }

    public String getNodepool(String node) {
        String retVal = "";
        try {
            String defaultNodepool;
            NodeConfiguration nc;
            if (node != null && (retVal = this.getNodepoolForNode(nc = this.readConfiguration(), node, defaultNodepool = this.getNodepoolDefault(nc))).equals(defaultNodepool)) {
                String domainlessNode = node.split("\\.")[0];
                retVal = this.getNodepoolForNode(nc, domainlessNode, defaultNodepool);
            }
        }
        catch (Exception e) {
            System.out.println("getNodepool(" + node + "): ERROR " + e);
        }
        return retVal;
    }

    public String getDefaultClassName() throws Exception {
        String retVal = null;
        DuccProperties properties = this.readConfiguration().getDefaultFairShareClass();
        if (properties != null) {
            retVal = properties.getProperty("name");
        }
        return retVal;
    }

    public String getDebugClassDefaultName() throws Exception {
        String retVal = null;
        DuccProperties properties = this.readConfiguration().getDefaultFixedClass();
        if (properties != null) {
            retVal = properties.getProperty("name");
        }
        return retVal;
    }

    public String getDebugClassSpecificName(String class_name) throws Exception {
        String retVal = null;
        DuccProperties properties = this.readConfiguration().getClass(class_name);
        if (properties != null) {
            retVal = properties.getProperty("debug");
        }
        if (retVal == null) {
            retVal = this.getDebugClassDefaultName();
        }
        return retVal;
    }

    public String[] getReserveClasses() throws Exception {
        Map<String, DuccProperties> allClasses = this.readConfiguration().getClasses();
        ArrayList<String> classList = new ArrayList<String>();
        for (DuccProperties p : allClasses.values()) {
            String pol = p.getProperty("policy");
            String name = p.getProperty("name");
            if (!pol.equals(RESERVE) || name.equals(JobDriver)) continue;
            classList.add(p.getProperty("name"));
        }
        String[] retVal = classList.toArray(new String[0]);
        return retVal;
    }

    public String[] getFixedClasses() throws Exception {
        Map<String, DuccProperties> allClasses = this.readConfiguration().getClasses();
        ArrayList<String> classList = new ArrayList<String>();
        for (DuccProperties p : allClasses.values()) {
            String pol = p.getProperty("policy");
            String name = p.getProperty("name");
            if (!pol.equals(FIXED_SHARE) || name.equals(JobDriver)) continue;
            classList.add(p.getProperty("name"));
        }
        String[] retVal = classList.toArray(new String[0]);
        return retVal;
    }

    public String getReserveClassDefaultName() throws Exception {
        String retVal = "";
        DuccProperties properties = this.readConfiguration().getDefaultReserveClass();
        if (properties != null) {
            retVal = properties.getProperty("name");
        }
        return retVal;
    }
}

