/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import org.apache.uima.ducc.common.utils.AlienAbstract;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.FileHelper;
import org.apache.uima.ducc.common.utils.Utils;

public class AlienFile
extends AlienAbstract {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger(AlienFile.class.getName());
    private static String ducc_ling = Utils.resolvePlaceholderIfExists(System.getProperty("ducc.agent.launcher.ducc_spawn_path"), System.getProperties());
    private String command_cat = "/bin/cat";
    private String file_name;
    private File devNull = new File("/dev/null");

    protected void set_command_cat(String value) {
        this.command_cat = value;
    }

    protected String get_command_cat() {
        return this.command_cat;
    }

    protected void set_file_name(String value) {
        this.file_name = value;
    }

    protected String get_file_name() {
        return this.file_name;
    }

    public AlienFile(String user, String file_name) {
        this.set_user(user);
        this.set_file_name(file_name);
    }

    private String[] getCommand() {
        String[] command_ducc_ling_yes = new String[]{ducc_ling, this.q_parameter, this.u_parameter, this.user, this.command_cat, this.file_name};
        String[] command_ducc_ling_no = new String[]{this.command_cat, this.file_name};
        String[] command = command_ducc_ling_yes;
        if (ducc_ling == null) {
            command = command_ducc_ling_no;
        }
        return command;
    }

    private int getByteSize() throws Exception {
        InputStreamReader isr;
        String methodName = "getByteSize";
        String[] command = this.getCommand();
        this.echo(command);
        ProcessBuilder pb = new ProcessBuilder(command);
        pb = pb.redirectError(this.devNull);
        Process p = pb.start();
        InputStream pOut = p.getInputStream();
        if (FileHelper.isGzFileType(this.file_name)) {
            GZIPInputStream gis = new GZIPInputStream(pOut);
            isr = new InputStreamReader((InputStream)gis, this.encoding);
        } else {
            isr = new InputStreamReader(pOut);
        }
        BufferedReader br = new BufferedReader(isr);
        int size = 0;
        int readChar = 0;
        while (readChar >= 0) {
            readChar = br.read();
            ++size;
        }
        int rc = p.waitFor();
        String text = "rc=" + rc + " " + "size=" + size;
        duccLogger.debug(methodName, this.duccId, text);
        return size;
    }

    private String reader(int size) throws Exception {
        String string;
        String data = null;
        BufferedReader br = null;
        InputStreamReader isr = null;
        try {
            String[] command = this.getCommand();
            this.echo(command);
            ProcessBuilder pb = new ProcessBuilder(command);
            pb = pb.redirectError(this.devNull);
            Process p = pb.start();
            InputStream pOut = p.getInputStream();
            if (FileHelper.isGzFileType(this.file_name)) {
                GZIPInputStream gis = new GZIPInputStream(pOut);
                isr = new InputStreamReader((InputStream)gis, this.encoding);
            } else {
                isr = new InputStreamReader(pOut);
            }
            char[] cbuf = new char[size];
            br = new BufferedReader(isr);
            br.read(cbuf);
            string = data = new String(cbuf);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                this.closer(br);
                this.closer(isr);
                throw throwable;
            }
        }
        this.closer(br);
        this.closer(isr);
        return string;
    }

    public String getString() throws Exception {
        int size = this.getByteSize();
        String data = this.reader(size);
        if (data != null) {
            data = data.trim();
        }
        return data;
    }

    public InputStreamReader getInputStreamReader() throws Exception {
        InputStreamReader isr = null;
        String[] command = this.getCommand();
        this.echo(command);
        ProcessBuilder pb = new ProcessBuilder(command);
        pb = pb.redirectError(this.devNull);
        Process p = pb.start();
        InputStream pOut = p.getInputStream();
        if (FileHelper.isGzFileType(this.file_name)) {
            GZIPInputStream gis = new GZIPInputStream(pOut);
            isr = new InputStreamReader((InputStream)gis, this.encoding);
        } else {
            isr = new InputStreamReader(pOut);
        }
        return isr;
    }

    public DataInputStream getDataInputStream() throws Exception {
        DataInputStream dis = null;
        String[] command = this.getCommand();
        this.echo(command);
        ProcessBuilder pb = new ProcessBuilder(command);
        pb = pb.redirectError(this.devNull);
        Process p = pb.start();
        InputStream pOut = p.getInputStream();
        dis = new DataInputStream(pOut);
        return dis;
    }

    public static void main(String[] args) throws Exception {
        String arg_user = args[0];
        String arg_file = args[1];
        AlienFile alienFile = new AlienFile(arg_user, arg_file);
        String data = alienFile.getString();
        System.out.println(data);
    }
}

