/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.crypto;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Set;
import javax.crypto.Cipher;
import org.apache.uima.ducc.common.crypto.CryptoException;
import org.apache.uima.ducc.common.crypto.ICrypto;
import org.apache.uima.ducc.common.utils.AlienFile;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.LinuxUtils;

public class Crypto
implements ICrypto {
    private boolean traditional = false;
    private String dirDotDucc = ".ducc";
    private String user;
    private String dirUserKeys;
    private String filePvt;
    private String filePub;
    private int keySize = 2048;
    private String keyType = "RSA";
    private Cipher cipher;

    public Crypto(String user, boolean create) throws CryptoException {
        this.init(user, create);
    }

    public Crypto(String user) throws CryptoException {
        this.init(user, false);
    }

    private void init(String user, boolean createRequest) throws CryptoException {
        this.user = user;
        String runmode = DuccPropertiesResolver.get("ducc.runmode");
        boolean testMode = runmode != null && runmode.equals("Test");
        String dirHome = null;
        String ducc_security_home = DuccPropertiesResolver.get("ducc.security.home");
        if (ducc_security_home != null && !ducc_security_home.isEmpty()) {
            String realUser = testMode ? System.getProperty("user.name") : user;
            dirHome = ducc_security_home + File.separator + realUser;
        }
        if (createRequest) {
            if (dirHome == null) {
                dirHome = System.getProperty("user.home");
            }
        } else if (dirHome == null) {
            dirHome = testMode ? System.getProperty("user.home") : LinuxUtils.getUserHome(user);
        }
        this.dirUserKeys = dirHome + File.separator + this.dirDotDucc;
        this.filePub = this.dirUserKeys + File.separator + "public.key";
        this.filePvt = this.dirUserKeys + File.separator + "private.key";
        if (createRequest) {
            this.createKeys();
            this.checkKeys();
        }
        try {
            this.cipher = Cipher.getInstance(this.keyType);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    private boolean isMissingKeys() {
        return !new File(this.filePvt).exists() || !new File(this.filePub).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createKeys() throws CryptoException {
        try {
            Class<Crypto> clazz = Crypto.class;
            synchronized (Crypto.class) {
                if (this.isMissingKeys()) {
                    RSAPrivateKeySpec pvt;
                    this.mkdir(this.dirUserKeys);
                    KeyPairGenerator kpg = KeyPairGenerator.getInstance(this.keyType);
                    kpg.initialize(this.keySize);
                    KeyPair kp = kpg.genKeyPair();
                    KeyFactory keyFactory = KeyFactory.getInstance(this.keyType);
                    RSAPublicKeySpec pub = keyFactory.getKeySpec(kp.getPublic(), RSAPublicKeySpec.class);
                    try {
                        pvt = keyFactory.getKeySpec(kp.getPrivate(), RSAPrivateKeySpec.class);
                    }
                    catch (Exception e) {
                        pvt = keyFactory.getKeySpec(kp.getPrivate(), RSAPrivateCrtKeySpec.class);
                    }
                    this.putKeyToFile(this.filePub, pub.getModulus(), pub.getPublicExponent(), false);
                    this.putKeyToFile(this.filePvt, pvt.getModulus(), pvt.getPrivateExponent(), true);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        {
            return;
        }
    }

    private void checkKeys() throws CryptoException {
        Path file = Paths.get(this.filePub, new String[0]);
        if (!Files.exists(file, new LinkOption[0])) {
            throw new CryptoException("File does not exist: " + this.filePub);
        }
        file = Paths.get(this.filePvt, new String[0]);
        if (!Files.exists(file, new LinkOption[0])) {
            throw new CryptoException("File does not exist: " + this.filePvt);
        }
        try {
            Set<PosixFilePermission> attrs = Files.getPosixFilePermissions(file, new LinkOption[0]);
            if (attrs.size() == 1 && attrs.contains((Object)PosixFilePermission.OWNER_READ)) {
                return;
            }
            System.out.println("Correcting permissions for the private key");
            this.setPermissions(this.filePvt, true, false);
            attrs = Files.getPosixFilePermissions(file, new LinkOption[0]);
            if (attrs.size() == 1 && attrs.contains((Object)PosixFilePermission.OWNER_READ)) {
                return;
            }
            throw new CryptoException("Unable to correct the invalid permissions for private key file " + this.filePvt);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }

    private void setPermissions(String fileName, boolean pvt, boolean dir) throws CryptoException {
        File f = new File(fileName);
        f.setReadable(false, false);
        f.setWritable(false, false);
        f.setReadable(true, pvt);
        f.setWritable(dir, true);
        f.setExecutable(dir, false);
    }

    private void mkdir(String dir) throws CryptoException {
        try {
            File file = new File(dir);
            file.mkdirs();
            this.setPermissions(this.dirUserKeys, false, true);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putKeyToFile(String fileName, BigInteger mod, BigInteger exp, boolean pvt) throws CryptoException {
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));){
            oos.writeObject(mod);
            oos.writeObject(exp);
            this.setPermissions(fileName, pvt, false);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    private boolean isReadablePublic() {
        boolean readable = false;
        File file = new File(this.filePub);
        readable = file.canRead();
        return readable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Key getPubicKeyFromFile() throws CryptoException {
        try {
            String fileName = this.filePub;
            ObjectInputStream ois = null;
            FilterInputStream dis = null;
            try {
                PrivateKey key;
                if (this.isReadablePublic()) {
                    ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(fileName)));
                } else {
                    AlienFile alienFile = new AlienFile(this.user, fileName);
                    dis = alienFile.getDataInputStream();
                    ois = new ObjectInputStream(new BufferedInputStream(dis));
                }
                BigInteger mod = (BigInteger)ois.readObject();
                BigInteger exp = (BigInteger)ois.readObject();
                RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(mod, exp);
                if (this.traditional) {
                    PublicKey publicKey2;
                    KeyFactory keyFactory = KeyFactory.getInstance(this.keyType);
                    PublicKey publicKey = publicKey2 = keyFactory.generatePublic(publicKeySpec);
                    return publicKey;
                }
                RSAPrivateKeySpec spec = new RSAPrivateKeySpec(publicKeySpec.getModulus(), publicKeySpec.getPublicExponent());
                PrivateKey privateKey = key = KeyFactory.getInstance("RSA").generatePrivate(spec);
                return privateKey;
            }
            finally {
                if (ois != null) {
                    ois.close();
                }
                if (dis != null) {
                    dis.close();
                }
            }
        }
        catch (Throwable t) {
            throw new CryptoException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Key getPrivateKeyFromFile() throws CryptoException {
        try {
            String fileName = this.filePvt;
            try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(fileName)));){
                PublicKey key;
                BigInteger mod = (BigInteger)ois.readObject();
                BigInteger exp = (BigInteger)ois.readObject();
                RSAPrivateKeySpec privateKeySpec = new RSAPrivateKeySpec(mod, exp);
                if (this.traditional) {
                    PrivateKey privateKey;
                    KeyFactory keyFactory = KeyFactory.getInstance(this.keyType);
                    PrivateKey privateKey2 = privateKey = keyFactory.generatePrivate(privateKeySpec);
                    return privateKey2;
                }
                RSAPublicKeySpec spec = new RSAPublicKeySpec(privateKeySpec.getModulus(), privateKeySpec.getPrivateExponent());
                PublicKey publicKey = key = KeyFactory.getInstance("RSA").generatePublic(spec);
                return publicKey;
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] o2b(Object object) throws CryptoException {
        byte[] byteArray;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(bos);
            try {
                oo.writeObject(object);
                byteArray = bos.toByteArray();
            }
            finally {
                oo.close();
                bos.close();
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return byteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object b2o(byte[] byteArray) throws CryptoException {
        Object object;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
            ObjectInputStream oi = new ObjectInputStream(bis);
            try {
                object = oi.readObject();
            }
            finally {
                oi.close();
                bis.close();
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return object;
    }

    @Override
    public byte[] encrypt(Object o) throws CryptoException {
        try {
            Key key = this.getPrivateKeyFromFile();
            this.cipher.init(1, key);
            return this.cipher.doFinal(this.o2b(o));
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public byte[] getSignature() throws CryptoException {
        return this.encrypt(this.user);
    }

    public boolean isValid(byte[] signature) throws CryptoException {
        String s = (String)this.decrypt(signature);
        return this.user.equals(s);
    }

    @Override
    public Object decrypt(byte[] byteArray) throws CryptoException {
        try {
            Key key = this.getPubicKeyFromFile();
            this.cipher.init(2, key);
            return this.b2o(this.cipher.doFinal(byteArray));
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static void main(String[] args) throws CryptoException {
        String user = args.length > 1 ? args[1] : System.getProperty("user.name");
        Crypto cr = new Crypto(user, true);
        byte[] sig = cr.getSignature();
        System.out.println("Valid signature: " + cr.isValid(sig));
    }
}

