/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.admin.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ducc.common.admin.event.RmQueriedShare;

public class RmQueriedMachine
implements Serializable {
    private static final long serialVersionUID = 1L;
    String name;
    String nodepoolId;
    long memory;
    int order;
    boolean blacklisted;
    boolean online;
    boolean responsive;
    List<RmQueriedShare> shares = null;

    public RmQueriedMachine(String name, String nodepoolId, long memory, int order, boolean blacklisted) {
        this.name = name;
        this.nodepoolId = nodepoolId;
        this.memory = memory;
        this.order = order;
        this.blacklisted = blacklisted;
        this.online = true;
        this.responsive = true;
    }

    public void setOffline() {
        this.online = false;
    }

    public void setUnresponsive() {
        this.responsive = false;
    }

    public void addShare(RmQueriedShare rqs) {
        if (this.shares == null) {
            this.shares = new ArrayList<RmQueriedShare>();
        }
        this.shares.add(rqs);
    }

    public List<RmQueriedShare> getShares() {
        return this.shares;
    }

    public String getId() {
        return this.name;
    }

    public long getMemory() {
        return this.memory;
    }

    public int getShareOrder() {
        return this.order;
    }

    public boolean isBlacklisted() {
        return this.blacklisted;
    }

    public boolean isOnline() {
        return this.online;
    }

    public boolean isResponsive() {
        return this.responsive;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{'name':'");
        sb.append(this.name);
        sb.append("','nodepool':'");
        sb.append(this.nodepoolId);
        sb.append("','blacklisted':");
        sb.append(this.blacklisted ? "True" : "False");
        sb.append(",'online':");
        sb.append(this.online ? "True" : "False");
        sb.append(",'status': ");
        sb.append(this.responsive ? "'up'" : "'down'");
        sb.append(",'nodepool': '");
        sb.append(this.nodepoolId);
        sb.append("','memory':");
        sb.append(Long.toString(this.memory));
        sb.append(",'order':");
        sb.append(Integer.toString(this.order));
        if (this.shares == null) {
            sb.append(",'shares-free':'");
            sb.append(Integer.toString(this.order));
            sb.append("'");
            sb.append(",'shares':[],\n");
        } else {
            int used = 0;
            for (RmQueriedShare s : this.shares) {
                used += s.getShareOrder();
            }
            sb.append(",'shares-free':");
            sb.append(Integer.toString(this.order - used));
            sb.append(",'shares':[");
            for (RmQueriedShare s : this.shares) {
                sb.append(s.toString());
                sb.append(",");
            }
            sb.append("],\n");
        }
        sb.append("}\n");
        return sb.toString();
    }
}

