/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.crypto;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import org.apache.uima.ducc.common.crypto.CryptoException;
import org.apache.uima.ducc.common.crypto.ICrypto;
import org.apache.uima.ducc.common.utils.AlienFile;

public class Crypto
implements ICrypto {
    private boolean traditional = false;
    private String dirDotDucc = ".ducc";
    private String dirDotDuccPermissions = "0755";
    private String pubFilePermissions = "0755";
    private String pvtFilePermissions = "0700";
    private String user;
    private String dirUserKeys;
    private String filePvt;
    private String filePub;
    private int keySize = 2048;
    private String keyType = "RSA";
    private Cipher cipher;

    public Crypto(String user, String dirHome) throws CryptoException {
        this.init(user, dirHome, this.dirDotDucc, AccessType.WRITER);
    }

    public Crypto(String user, String dirHome, AccessType accessType) throws CryptoException {
        this.init(user, dirHome, this.dirDotDucc, accessType);
    }

    public Crypto(String user, String dirHome, String dirSub) throws CryptoException {
        this.init(user, dirHome, dirSub, AccessType.WRITER);
    }

    public Crypto(String user, String dirHome, String dirSub, AccessType accessType) throws CryptoException {
        this.init(user, dirHome, dirSub, accessType);
    }

    private void init(String tgtUser, String dirHome, String dirSub, AccessType accessType) throws CryptoException {
        this.user = tgtUser;
        this.dirUserKeys = dirHome + File.separator + dirSub;
        this.filePub = this.dirUserKeys + File.separator + "public.key";
        this.filePvt = this.dirUserKeys + File.separator + "private.key";
        switch (accessType) {
            case READER: {
                break;
            }
            case WRITER: {
                this.createKeys();
                this.checkKeys();
            }
        }
        try {
            this.cipher = Cipher.getInstance(this.keyType);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public String getPublic() {
        return this.filePub;
    }

    public String getPrivate() {
        return this.filePvt;
    }

    private boolean isMissingKeys() {
        boolean retVal = false;
        try {
            this.checkFile(this.filePub);
            this.checkFile(this.filePvt);
        }
        catch (Exception e) {
            retVal = true;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createKeys() throws CryptoException {
        try {
            Class<Crypto> clazz = Crypto.class;
            synchronized (Crypto.class) {
                if (this.isMissingKeys()) {
                    RSAPrivateKeySpec pvt;
                    this.mkdir(this.dirUserKeys, this.dirDotDuccPermissions);
                    KeyPairGenerator kpg = KeyPairGenerator.getInstance(this.keyType);
                    kpg.initialize(this.keySize);
                    KeyPair kp = kpg.genKeyPair();
                    KeyFactory keyFactory = KeyFactory.getInstance(this.keyType);
                    RSAPublicKeySpec pub = keyFactory.getKeySpec(kp.getPublic(), RSAPublicKeySpec.class);
                    try {
                        pvt = keyFactory.getKeySpec(kp.getPrivate(), RSAPrivateKeySpec.class);
                    }
                    catch (Exception e) {
                        pvt = keyFactory.getKeySpec(kp.getPrivate(), RSAPrivateCrtKeySpec.class);
                    }
                    this.putKeyToFile(this.filePub, pub.getModulus(), pub.getPublicExponent(), this.pubFilePermissions);
                    this.putKeyToFile(this.filePvt, pvt.getModulus(), pvt.getPrivateExponent(), this.pvtFilePermissions);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (CryptoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        {
            return;
        }
    }

    private void checkDir(String fileName) throws CryptoException {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new CryptoException("Directory does not exist: " + fileName);
        }
    }

    private void checkFile(String fileName) throws CryptoException {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new CryptoException("File does not exist: " + fileName);
        }
    }

    private void checkKeys() throws CryptoException {
        this.checkDir(this.dirUserKeys);
        this.checkFile(this.filePvt);
        this.checkFile(this.filePub);
    }

    private void exec(String cmd) throws CryptoException {
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            process.waitFor();
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    private void chmod(String fileName, String permissions) throws CryptoException {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return;
        }
        try {
            this.exec("chmod " + permissions + " " + fileName);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    private void mkdir(String dir, String permissions) throws CryptoException {
        try {
            File file = new File(dir);
            file.mkdirs();
            this.chmod(this.dirUserKeys, permissions);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putKeyToFile(String fileName, BigInteger mod, BigInteger exp, String permissions) throws CryptoException {
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));){
            oos.writeObject(mod);
            oos.writeObject(exp);
            this.chmod(fileName, permissions);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public boolean isReadablePrivate() {
        boolean readable = false;
        File file = new File(this.filePvt);
        readable = file.canRead();
        return readable;
    }

    public boolean isReadablePublic() {
        boolean readable = false;
        File file = new File(this.filePub);
        readable = file.canRead();
        return readable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Key getPubicKeyFromFile() throws CryptoException {
        try {
            String fileName = this.filePub;
            ObjectInputStream ois = null;
            FilterInputStream dis = null;
            try {
                PrivateKey key;
                if (this.isReadablePublic()) {
                    ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(fileName)));
                } else {
                    AlienFile alienFile = new AlienFile(this.user, fileName);
                    dis = alienFile.getDataInputStream();
                    ois = new ObjectInputStream(new BufferedInputStream(dis));
                }
                BigInteger mod = (BigInteger)ois.readObject();
                BigInteger exp = (BigInteger)ois.readObject();
                RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(mod, exp);
                if (this.traditional) {
                    PublicKey publicKey2;
                    KeyFactory keyFactory = KeyFactory.getInstance(this.keyType);
                    PublicKey publicKey = publicKey2 = keyFactory.generatePublic(publicKeySpec);
                    return publicKey;
                }
                RSAPrivateKeySpec spec = new RSAPrivateKeySpec(publicKeySpec.getModulus(), publicKeySpec.getPublicExponent());
                PrivateKey privateKey = key = KeyFactory.getInstance("RSA").generatePrivate(spec);
                return privateKey;
            }
            finally {
                if (ois != null) {
                    ois.close();
                }
                if (dis != null) {
                    dis.close();
                }
            }
        }
        catch (Throwable t) {
            throw new CryptoException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Key getPrivateKeyFromFile() throws CryptoException {
        try {
            String fileName = this.filePvt;
            try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(fileName)));){
                PublicKey key;
                BigInteger mod = (BigInteger)ois.readObject();
                BigInteger exp = (BigInteger)ois.readObject();
                RSAPrivateKeySpec privateKeySpec = new RSAPrivateKeySpec(mod, exp);
                if (this.traditional) {
                    PrivateKey privateKey;
                    KeyFactory keyFactory = KeyFactory.getInstance(this.keyType);
                    PrivateKey privateKey2 = privateKey = keyFactory.generatePrivate(privateKeySpec);
                    return privateKey2;
                }
                RSAPublicKeySpec spec = new RSAPublicKeySpec(privateKeySpec.getModulus(), privateKeySpec.getPrivateExponent());
                PublicKey publicKey = key = KeyFactory.getInstance("RSA").generatePublic(spec);
                return publicKey;
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] o2b(Object object) throws CryptoException {
        byte[] byteArray;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(bos);
            try {
                oo.writeObject(object);
                byteArray = bos.toByteArray();
            }
            finally {
                oo.close();
                bos.close();
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return byteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object b2o(byte[] byteArray) throws CryptoException {
        Object object;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
            ObjectInputStream oi = new ObjectInputStream(bis);
            try {
                object = oi.readObject();
            }
            finally {
                oi.close();
                bis.close();
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return object;
    }

    @Override
    public byte[] encrypt(Object o) throws CryptoException {
        try {
            Key key = this.getPrivateKeyFromFile();
            this.cipher.init(1, key);
            return this.cipher.doFinal(this.o2b(o));
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    @Override
    public Object decrypt(byte[] byteArray) throws CryptoException {
        try {
            Key key = this.getPubicKeyFromFile();
            this.cipher.init(2, key);
            return this.b2o(this.cipher.doFinal(byteArray));
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static enum AccessType {
        READER,
        WRITER;

    }
}

