/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.id.DuccId;

public class DuccPropertiesResolver {
    private DuccLogger logger = DuccLogger.getLogger(DuccPropertiesResolver.class, null);
    private DuccId duccId = null;
    private AtomicBoolean loadedPrivate = new AtomicBoolean(false);
    private AtomicBoolean e1 = new AtomicBoolean(false);
    private AtomicBoolean e2 = new AtomicBoolean(false);
    private AtomicBoolean e3 = new AtomicBoolean(false);
    private AtomicBoolean e4 = new AtomicBoolean(false);
    private AtomicBoolean e5 = new AtomicBoolean(false);
    private static DuccPropertiesResolver duccPropertiesResolver = new DuccPropertiesResolver();
    private Properties initialProperties = new DuccProperties();
    private Properties defaultProperties = new DuccProperties();
    public static final String ducc_private_resources = "ducc.private.resources";
    public static final String ducc_threads_limit = "ducc.threads.limit";
    public static final String ducc_driver_jvm_args = "ducc.driver.jvm.args";
    public static final String ducc_process_jvm_args = "ducc.process.jvm.args";
    public static final String ducc_environment_propagated = "ducc.environment.propagated";
    public static final String ducc_runmode = "ducc.runmode";
    public static final String ducc_signature_required = "ducc.signature.required";
    public static final String ducc_broker_url = "ducc.broker.url";
    public static final String ducc_broker_protocol = "ducc.broker.protocol";
    public static final String ducc_broker_hostname = "ducc.broker.hostname";
    public static final String ducc_broker_port = "ducc.broker.port";
    public static final String ducc_broker_url_decoration = "ducc.broker.url.decoration";
    public static final String ducc_broker_name = "ducc.broker.name";
    public static final String ducc_broker_jmx_port = "ducc.broker.jmx.port";
    public static final String ducc_jms_provider = "ducc.jms.provider";
    public static final String ducc_orchestrator_state_update_endpoint_type = "ducc.orchestrator.state.update.endpoint.type";
    public static final String ducc_orchestrator_state_update_endpoint = "ducc.orchestrator.state.update.endpoint";
    public static final String ducc_orchestrator_http_port = "ducc.orchestrator.http.port";
    public static final String ducc_orchestrator_http_node = "ducc.orchestrator.http.node";
    public static final String ducc_orchestrator_maintenance_rate = "ducc.orchestrator.maintenance.rate";
    public static final String ducc_orchestrator_job_factory_classpath_order = "ducc.orchestrator.job.factory.classpath.order";
    public static final String ducc_orchestrator_unmanaged_reservations_accepted = "ducc.orchestrator.unmanaged.reservations.accepted";
    public static final String ducc_orchestrator_use_lock_file = "ducc.orchestrator.use.lock.file";
    public static final String default_process_get_meta_time_max = "default.process.get.meta.time.max";
    public static final String ducc_agent_launcher_process_init_timeout = "ducc.agent.launcher.process.init.timeout";
    public static final String default_process_per_item_time_max = "default.process.per.item.time.max";
    public static final String ducc_jd_host_class = "ducc.jd.host.class";
    public static final String ducc_jd_host_description = "ducc.jd.host.description";
    public static final String ducc_jd_host_memory_size = "ducc.jd.host.memory.size";
    public static final String ducc_jd_host_number_of_machines = "ducc.jd.host.number.of.machines";
    public static final String ducc_jd_host_user = "ducc.jd.host.user";
    public static final String ducc_jd_queue_prefix = "ducc.jd.queue.prefix";
    public static final String ducc_jd_queue_timeout_minutes = "ducc.jd.queue.timeout.minutes";
    public static final String ducc_rm_class_definitions = "ducc.rm.class.definitions";
    public static final String ducc_rm_share_quantum = "ducc.rm.share.quantum";
    public static final String ducc_jd_share_quantum = "ducc.jd.share.quantum";
    public static final String ducc_authentication_implementer = "ducc.authentication.implementer";
    public static final String ducc_authentication_users_include = "ducc.authentication.users.include";
    public static final String ducc_authentication_users_exclude = "ducc.authentication.users.exclude";
    public static final String ducc_authentication_groups_include = "ducc.authentication.groups.include";
    public static final String ducc_authentication_groups_exclude = "ducc.authentication.groups.exclude";
    public static final String ducc_ws_host = "ducc.ws.node";
    public static final String ducc_ws_port = "ducc.ws.port";
    public static final String ducc_ws_max_history_entries = "ducc.ws.max.history.entries";
    public static final String ducc_ws_login_enabled = "ducc.ws.login.enabled";
    public static final String ducc_ws_bytes_per_page = "ducc.ws.bytes.per.page";
    public static final String ducc_rm_node_stability = "ducc.rm.node.stability";
    public static final String ducc_agent_node_metrics_publish_rate = "ducc.agent.node.metrics.publish.rate";
    public static final String ducc_rm_state_publish_rate = "ducc.rm.state.publish.rate";
    public static final String ducc_orchestrator_abbreviated_state_publish_rate = "ducc.orchestrator.abbreviated.state.publish.rate";
    public static final String ducc_agent_node_inventory_publish_rate = "ducc.agent.node.inventory.publish.rate";
    public static final String ducc_agent_node_inventory_publish_rate_skip = "ducc.agent.node.inventory.publish.rate.skip";
    public static final String ducc_transport_trace = "ducc.transport.trace";

    public static DuccPropertiesResolver getInstance() {
        return duccPropertiesResolver;
    }

    public static String get(String key) {
        return duccPropertiesResolver.getProperty(key);
    }

    public static String get(String key, String dflt) {
        String value = duccPropertiesResolver.getProperty(key);
        return value != null ? value : dflt;
    }

    public DuccPropertiesResolver() {
        try {
            this.init(this.initialProperties);
            this.initDefaultProperties();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void initDefaultProperties() {
        this.defaultProperties.put(ducc_runmode, "Production");
        this.defaultProperties.put(ducc_broker_url, "tcp://localhost:61616");
        this.defaultProperties.put(ducc_jms_provider, "activemq");
        this.defaultProperties.put(ducc_orchestrator_state_update_endpoint, "ducc.orchestrator.state");
        this.defaultProperties.put(ducc_orchestrator_state_update_endpoint_type, "topic");
        this.defaultProperties.put(default_process_get_meta_time_max, "1");
        this.defaultProperties.put(ducc_agent_launcher_process_init_timeout, "7200000");
        this.defaultProperties.put(default_process_per_item_time_max, "1");
        this.defaultProperties.put(ducc_rm_share_quantum, "10");
        this.defaultProperties.put(ducc_jd_share_quantum, "300");
        this.defaultProperties.put(ducc_orchestrator_unmanaged_reservations_accepted, "true");
        this.defaultProperties.put(ducc_orchestrator_use_lock_file, "false");
        this.defaultProperties.put(ducc_ws_login_enabled, "true");
        this.defaultProperties.put(ducc_authentication_implementer, "org.apache.uima.ducc.ws.authentication.LinuxAuthenticationManager");
        this.defaultProperties.put(ducc_jd_queue_timeout_minutes, "5");
        this.defaultProperties.put(ducc_jd_queue_prefix, "ducc.jd.queue.");
        this.defaultProperties.put(ducc_jd_host_class, "JobDriver");
        this.defaultProperties.put(ducc_jd_host_description, "Job Driver");
        this.defaultProperties.put(ducc_jd_host_memory_size, "2GB");
        this.defaultProperties.put(ducc_jd_host_number_of_machines, "1");
        this.defaultProperties.put(ducc_jd_host_user, "System");
    }

    private void init(Properties properties) {
        block5: {
            String location = "init";
            String fileName = null;
            try {
                String componentProperties = "ducc.deploy.configuration";
                fileName = System.getProperty(componentProperties);
                if (fileName == null) {
                    fileName = IDuccEnv.DUCC_PROPERTIES_FILE;
                }
                File file = new File(fileName);
                FileInputStream fis = new FileInputStream(file);
                properties.load(fis);
                fis.close();
            }
            catch (FileNotFoundException e) {
                if (!this.e1.get()) {
                    this.logger.error(location, this.duccId, "File not found: " + fileName);
                    this.e1.set(true);
                }
            }
            catch (IOException e) {
                if (this.e2.get()) break block5;
                this.logger.debug(location, this.duccId, "Error reading file: " + fileName);
                this.e2.set(true);
            }
        }
        this.enrich(properties);
    }

    private void enrich(Properties properties) {
        Properties privateProperties = this.getPrivateProperties();
        for (Map.Entry<Object, Object> entry : privateProperties.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
    }

    private Properties getPrivateProperties() {
        Properties privateProperties;
        block9: {
            String location = "getPrivateProperties";
            privateProperties = new Properties();
            String key = ducc_private_resources;
            String directory = this.getProperty(key);
            if (directory != null) {
                String fileName = directory + File.separator + "ducc.private.properties";
                try {
                    File file = new File(fileName);
                    FileInputStream fis = new FileInputStream(file);
                    privateProperties.load(fis);
                    fis.close();
                    if (this.loadedPrivate.get()) {
                        this.logger.debug(location, this.duccId, "Reloaded: " + fileName);
                    } else {
                        this.logger.debug(location, this.duccId, "Loaded: " + fileName);
                    }
                    this.loadedPrivate.set(true);
                }
                catch (FileNotFoundException e) {
                    if (!this.e3.get()) {
                        this.logger.debug(location, this.duccId, "File not found: " + fileName);
                        this.e3.set(true);
                    }
                    break block9;
                }
                catch (IOException e) {
                    if (!this.e4.get()) {
                        this.logger.debug(location, this.duccId, "Error reading file: " + fileName);
                        this.e4.set(true);
                    }
                    break block9;
                }
            }
            if (!this.e5.get()) {
                this.logger.debug(location, this.duccId, "Key not found: " + key);
                this.e5.set(true);
            }
        }
        return privateProperties;
    }

    public String getProperty(String key) {
        return this.getCachedProperty(key);
    }

    public String getCachedProperty(String key) {
        String value = this.initialProperties.getProperty(key);
        if (value == null) {
            value = this.defaultProperties.getProperty(key);
        }
        return value == null ? null : value.trim();
    }

    public String getFileProperty(String key) {
        DuccProperties currentProperties = new DuccProperties();
        this.init(currentProperties);
        String value = ((Properties)currentProperties).getProperty(key);
        if (value == null) {
            value = this.defaultProperties.getProperty(key);
        }
        return value == null ? null : value.trim();
    }
}

