/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.uima;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.analysis_engine.metadata.FixedFlow;
import org.apache.uima.analysis_engine.metadata.FlowConstraints;
import org.apache.uima.ducc.Workitem;
import org.apache.uima.flow.FinalStep;
import org.apache.uima.flow.Flow;
import org.apache.uima.flow.FlowControllerContext;
import org.apache.uima.flow.JCasFlowController_ImplBase;
import org.apache.uima.flow.JCasFlow_ImplBase;
import org.apache.uima.flow.SimpleStep;
import org.apache.uima.flow.Step;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.OperationalProperties;

public class DuccJobProcessFC
extends JCasFlowController_ImplBase {
    private List<String> mSequence;
    private boolean mStartsWithCasMultiplier = false;

    public void initialize(FlowControllerContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        FlowConstraints flowConstraints = aContext.getAggregateMetadata().getFlowConstraints();
        this.mSequence = new ArrayList<String>();
        if (!(flowConstraints instanceof FixedFlow)) {
            throw new ResourceInitializationException("flow_controller_requires_flow_constraints", new Object[]{((Object)((Object)this)).getClass().getName(), "fixedFlow", aContext.getAggregateMetadata().getSourceUrlString()});
        }
        String[] sequence = ((FixedFlow)flowConstraints).getFixedFlow();
        this.mSequence.addAll(Arrays.asList(sequence));
        for (Map.Entry entry : this.getContext().getAnalysisEngineMetaDataMap().entrySet()) {
            AnalysisEngineMetaData md = (AnalysisEngineMetaData)entry.getValue();
            OperationalProperties op = md.getOperationalProperties();
            if (!op.getOutputsNewCASes() || !this.mSequence.get(0).equals(entry.getKey())) continue;
            this.mStartsWithCasMultiplier = true;
        }
    }

    public Flow computeFlow(JCas aCAS) throws AnalysisEngineProcessException {
        return new FixedFlowObject(0);
    }

    class FixedFlowObject
    extends JCasFlow_ImplBase {
        private int currentStep;
        private boolean internallyCreatedCas = false;

        private FixedFlowObject(int startStep) {
            this(startStep, false);
        }

        private FixedFlowObject(int startStep, boolean internallyCreatedCas) {
            this.currentStep = startStep;
            this.internallyCreatedCas = internallyCreatedCas;
        }

        public Step next() throws AnalysisEngineProcessException {
            if (DuccJobProcessFC.this.mStartsWithCasMultiplier && !this.internallyCreatedCas && this.currentStep == 1) {
                Iterator fsIter = null;
                if (this.getJCas().getTypeSystem().getType(Workitem.class.getName()) != null) {
                    fsIter = this.getJCas().getJFSIndexRepository().getAllIndexedFS(Workitem.type);
                }
                if (fsIter != null && fsIter.hasNext()) {
                    Workitem wi = (Workitem)((Object)fsIter.next());
                    if (fsIter.hasNext()) {
                        throw new IllegalStateException("More than one instance of Workitem type");
                    }
                    if (!wi.getSendToAll() && wi.getSendToLast()) {
                        this.currentStep = DuccJobProcessFC.this.mSequence.size() - 1;
                    }
                } else {
                    return new FinalStep();
                }
            }
            if (this.currentStep >= DuccJobProcessFC.this.mSequence.size()) {
                return new FinalStep();
            }
            return new SimpleStep((String)DuccJobProcessFC.this.mSequence.get(this.currentStep++));
        }

        public Flow newCasProduced(JCas newCas, String producedBy) throws AnalysisEngineProcessException {
            int i = 0;
            while (!((String)DuccJobProcessFC.this.mSequence.get(i)).equals(producedBy)) {
                ++i;
            }
            return new FixedFlowObject(i + 1, true);
        }
    }
}

