/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.jd.files.workitem.legacy;

import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.uima.ducc.common.jd.files.IWorkItemState;
import org.apache.uima.ducc.common.jd.files.workitem.legacy.WorkItemStateJson;
import org.apache.uima.ducc.common.jd.files.workitem.legacy.WorkItemStateJsonGz;
import org.apache.uima.ducc.common.jd.files.workitem.legacy.WorkItemStateSerializedObjects;

@Deprecated
public class WorkItemStateManager {
    private ConcurrentSkipListMap<Long, IWorkItemState> map = new ConcurrentSkipListMap();
    private WorkItemStateSerializedObjects pSer;
    private WorkItemStateJson pJson;
    private WorkItemStateJsonGz pJsonGz;
    private String user = null;

    public WorkItemStateManager(String component, String dirname, String user) {
        this.setUser(user);
        this.pSer = new WorkItemStateSerializedObjects(dirname);
        this.pJson = new WorkItemStateJson(dirname);
        this.pJsonGz = new WorkItemStateJsonGz(dirname);
    }

    private void setUser(String value) {
        this.user = value;
    }

    public ConcurrentSkipListMap<Long, IWorkItemState> getMap() {
        this.importData();
        return this.map;
    }

    private void importData() {
        try {
            this.map = this.pJsonGz.importData(this.user);
            return;
        }
        catch (Exception e) {
            try {
                this.map = this.pJson.importData();
                return;
            }
            catch (Exception e2) {
                try {
                    this.map = this.pSer.importData();
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
    }

    public double getMin() {
        double retVal = -1.0;
        try {
            for (Map.Entry<Long, IWorkItemState> entry : this.map.entrySet()) {
                IWorkItemState workItemState = entry.getValue();
                switch (workItemState.getState()) {
                    case ended: {
                        long millis = workItemState.getMillisProcessing();
                        if ((double)millis < retVal) {
                            retVal = millis;
                            break;
                        }
                        if (!(retVal < 0.0)) break;
                        retVal = millis;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    public double getMax() {
        double retVal = -1.0;
        try {
            for (Map.Entry<Long, IWorkItemState> entry : this.map.entrySet()) {
                IWorkItemState workItemState = entry.getValue();
                switch (workItemState.getState()) {
                    case ended: {
                        long millis = workItemState.getMillisProcessing();
                        if (!((double)millis > retVal)) break;
                        retVal = millis;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    public double getAvg() {
        double retVal = 0.0;
        try {
            int count = 0;
            for (Map.Entry<Long, IWorkItemState> entry : this.map.entrySet()) {
                IWorkItemState workItemState = entry.getValue();
                switch (workItemState.getState()) {
                    case ended: {
                        retVal += (double)workItemState.getMillisProcessing();
                        ++count;
                    }
                }
            }
            if (count > 0) {
                retVal /= (double)count;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }
}

