/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

public class ExceptionHelper {
    public static String summarize(Exception e) {
        StringBuffer sb = new StringBuffer();
        if (e != null) {
            sb.append(e.getClass().getCanonicalName());
            StackTraceElement[] steArray = e.getStackTrace();
            if (steArray != null && steArray.length > 0) {
                StackTraceElement ste = steArray[0];
                sb.append(" at ");
                sb.append(ste.getClassName());
                sb.append(".");
                sb.append(ste.getMethodName());
                sb.append("(");
                sb.append(ste.getFileName());
                sb.append(":");
                sb.append(ste.getLineNumber());
                sb.append(")");
                if (e.getCause() != null) {
                    sb.append(" cause: ");
                    sb.append(e.getCause());
                }
            }
        }
        return sb.toString();
    }
}

