/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

import java.util.Enumeration;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.uima.InternationalizedException;
import org.apache.uima.ducc.common.utils.LoggingException;
import org.apache.uima.ducc.common.utils.id.DuccId;

public class DuccLogger {
    private Logger logger;
    private String component = "";
    private static DuccLoggingThread log_thread = null;
    private static LinkedBlockingQueue<DuccLoggingEvent> events = null;
    private static boolean threaded = false;
    private String defaultId = "N/A";
    private static Throwable loggingError = null;
    private static boolean disable_logger = false;

    protected static void initLogger() {
        if (log_thread == null) {
            events = new LinkedBlockingQueue();
            log_thread = new DuccLoggingThread();
            log_thread.setName("DuccLoggerThread");
            log_thread.setDaemon(true);
            log_thread.start();
        }
    }

    public static DuccLogger getLogger(Class claz, String component) {
        return new DuccLogger(claz, component);
    }

    public static DuccLogger getLogger(String claz, String component) {
        return new DuccLogger(claz, component);
    }

    public static void setUnthreaded() {
        threaded = false;
    }

    public static void setThreaded() {
        threaded = false;
    }

    public DuccLogger(String claz, String component) {
        if (component == null && (component = (String)MDC.get((String)"COMPONENT")) == null) {
            component = "DUCC";
        }
        this.component = component;
        this.logger = Logger.getLogger((String)claz);
        MDC.put((String)"COMPONENT", (Object)component);
        DuccLogErrorHandler errHandler = new DuccLogErrorHandler(this);
        Enumeration appenders = this.logger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender app = (Appender)appenders.nextElement();
            app.setErrorHandler((ErrorHandler)errHandler);
        }
    }

    public DuccLogger(Class claz, String component) {
        this(claz.getName(), component);
    }

    public DuccLogger(Class claz) {
        this(claz, null);
    }

    public DuccLogger(String claz) {
        this(claz, null);
    }

    public void setLevel(Level l) {
        this.logger.setLevel(l);
    }

    public Level getLevel() {
        return this.logger.getLevel();
    }

    public boolean isLevelEnabled(Level l) {
        return l.isGreaterOrEqual((Priority)this.logger.getEffectiveLevel());
    }

    public boolean isFatal() {
        return this.isLevelEnabled(Level.FATAL);
    }

    public boolean isDebug() {
        return this.isLevelEnabled(Level.DEBUG);
    }

    public boolean isError() {
        return this.isLevelEnabled(Level.ERROR);
    }

    public boolean isInfo() {
        return this.isLevelEnabled(Level.INFO);
    }

    public boolean isWarn() {
        return this.isLevelEnabled(Level.WARN);
    }

    public boolean isTrace() {
        return this.isLevelEnabled(Level.TRACE);
    }

    protected String formatMsg(String loc, DuccId jid, DuccId pid, Object ... args) {
        String jobId = this.format(jid);
        String processId = this.format(pid);
        String header = String.format("%s %7s %7s", loc, jobId, processId);
        return this.formatMsg(loc, header, args);
    }

    protected String formatMsg(String loc, DuccId jid, Object ... args) {
        String jobId = this.format(jid);
        String header = String.format("%s %7s", loc, jobId);
        return this.formatMsg(loc, header, args);
    }

    private void appendStackTrace(StringBuffer s, Throwable t) {
        StackTraceElement[] stacktrace;
        s.append("\nAt:\n");
        for (StackTraceElement ste : stacktrace = t.getStackTrace()) {
            s.append("\t");
            s.append(ste.toString());
            s.append("\n");
        }
    }

    protected String formatMsg(String loc, String header, Object ... args) {
        StringBuffer s = new StringBuffer(header);
        for (Object a : args) {
            if (a == null) {
                a = "<null>";
            }
            s.append(" ");
            if (a instanceof InternationalizedException) {
                InternationalizedException e = (InternationalizedException)a;
                s.append(e.toString());
                s.append("\n");
                Object[] arguments = e.getArguments();
                if (arguments.length > 0) {
                    s.append("UIMA exception arguments:\n");
                }
                for (Object o : arguments) {
                    if (o == null) {
                        o = "<null>";
                    }
                    s.append(o.toString());
                    s.append("\n");
                }
                Throwable nextCause = e.getCause();
                if (nextCause == null) continue;
                while (nextCause.getCause() != null) {
                    nextCause = nextCause.getCause();
                }
                s.append("Caused by:\n");
                s.append(nextCause.toString());
                this.appendStackTrace(s, nextCause);
                continue;
            }
            if (a instanceof Throwable) {
                Throwable t = (Throwable)a;
                s.append(t.toString());
                s.append("\n");
                this.appendStackTrace(s, t);
                continue;
            }
            s.append(a.toString());
        }
        return s.toString();
    }

    public void setDefaultDuccId(String defaultDuccId) {
        if (defaultDuccId != null) {
            this.defaultId = defaultDuccId;
        }
    }

    private String format(DuccId duccId) {
        String id = duccId == null ? this.defaultId : duccId.toString();
        return id;
    }

    protected void setMDC() {
    }

    protected void clearMDC() {
    }

    public void doAppend(Level level, String msg, Throwable t) {
        DuccLoggingEvent ev = new DuccLoggingEvent(this.logger, this.component, level, msg, t, Thread.currentThread().getId(), Thread.currentThread().getName());
        if (threaded) {
            events.offer(ev);
        } else {
            DuccLogger.doLog(ev);
        }
    }

    public void doAppend(Level level, String msg) {
        DuccLoggingEvent ev = new DuccLoggingEvent(this.logger, this.component, level, msg, null, Thread.currentThread().getId(), Thread.currentThread().getName());
        if (threaded) {
            events.offer(ev);
        } else {
            DuccLogger.doLog(ev);
        }
    }

    public void fatal(String location, DuccId jobid, Object ... args) {
        if (this.isLevelEnabled(Level.FATAL)) {
            this.doAppend(Level.FATAL, this.formatMsg(location, jobid, args));
        }
    }

    public void fatal(String location, DuccId jobid, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.FATAL)) {
            this.doAppend(Level.FATAL, this.formatMsg(location, jobid, args), t);
        }
    }

    public void fatal(String location, DuccId jobid, DuccId processId, Object ... args) {
        if (this.isLevelEnabled(Level.FATAL)) {
            this.doAppend(Level.FATAL, this.formatMsg(location, jobid, processId, args));
        }
    }

    public void fatal(String location, DuccId jobid, DuccId processId, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.FATAL)) {
            this.doAppend(Level.FATAL, this.formatMsg(location, jobid, processId, args), t);
        }
    }

    public void debug(String location, DuccId jobid, Object ... args) {
        if (this.isLevelEnabled(Level.DEBUG)) {
            this.doAppend(Level.DEBUG, this.formatMsg(location, jobid, args));
        }
    }

    public void debug(String location, DuccId jobid, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.DEBUG)) {
            this.doAppend(Level.DEBUG, this.formatMsg(location, jobid, args), t);
        }
    }

    public void debug(String location, DuccId jobid, DuccId processId, Object ... args) {
        if (this.isLevelEnabled(Level.DEBUG)) {
            this.doAppend(Level.DEBUG, this.formatMsg(location, jobid, processId, args));
        }
    }

    public void debug(String location, DuccId jobid, DuccId processId, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.DEBUG)) {
            this.doAppend(Level.DEBUG, this.formatMsg(location, jobid, processId, args), t);
        }
    }

    public void error(String location, DuccId jobid, Object ... args) {
        if (this.isLevelEnabled(Level.ERROR)) {
            this.doAppend(Level.ERROR, this.formatMsg(location, jobid, args));
        }
    }

    public void error(String location, DuccId jobid, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.ERROR)) {
            this.doAppend(Level.ERROR, this.formatMsg(location, jobid, args), t);
        }
    }

    public void error(String location, DuccId jobid, DuccId processId, Object ... args) {
        if (this.isLevelEnabled(Level.ERROR)) {
            this.doAppend(Level.ERROR, this.formatMsg(location, jobid, processId, args));
        }
    }

    public void error(String location, DuccId jobid, DuccId processId, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.ERROR)) {
            this.doAppend(Level.ERROR, this.formatMsg(location, jobid, processId, args), t);
        }
    }

    public void info(String location, DuccId jobid, Object ... args) {
        if (this.isLevelEnabled(Level.INFO)) {
            this.doAppend(Level.INFO, this.formatMsg(location, jobid, args));
        }
    }

    public void info(String location, DuccId jobid, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.INFO)) {
            this.doAppend(Level.INFO, this.formatMsg(location, jobid, args), t);
        }
    }

    public void info(String location, DuccId jobid, DuccId processId, Object ... args) {
        if (this.isLevelEnabled(Level.INFO)) {
            this.doAppend(Level.INFO, this.formatMsg(location, jobid, processId, args));
        }
    }

    public void info(String location, DuccId jobid, DuccId processId, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.INFO)) {
            this.doAppend(Level.INFO, this.formatMsg(location, jobid, processId, args), t);
        }
    }

    public void trace(String location, DuccId jobid, Object ... args) {
        if (this.isLevelEnabled(Level.TRACE)) {
            this.doAppend(Level.TRACE, this.formatMsg(location, jobid, args));
        }
    }

    public void trace(String location, DuccId jobid, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.TRACE)) {
            this.doAppend(Level.TRACE, this.formatMsg(location, jobid, args), t);
        }
    }

    public void trace(String location, DuccId jobid, DuccId processId, Object ... args) {
        if (this.isLevelEnabled(Level.TRACE)) {
            this.doAppend(Level.TRACE, this.formatMsg(location, jobid, processId, args));
        }
    }

    public void trace(String location, DuccId jobid, DuccId processId, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.TRACE)) {
            this.doAppend(Level.TRACE, this.formatMsg(location, jobid, processId, args), t);
        }
    }

    public void warn(String location, DuccId jobid, Object ... args) {
        if (this.isLevelEnabled(Level.WARN)) {
            this.doAppend(Level.WARN, this.formatMsg(location, jobid, args));
        }
    }

    public void warn(String location, DuccId jobid, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.WARN)) {
            this.doAppend(Level.WARN, this.formatMsg(location, jobid, args), t);
        }
    }

    public void warn(String location, DuccId jobid, DuccId processId, Object ... args) {
        if (this.isLevelEnabled(Level.WARN)) {
            this.doAppend(Level.WARN, this.formatMsg(location, jobid, processId, args));
        }
    }

    public void warn(String location, DuccId jobid, DuccId processId, Throwable t, Object ... args) {
        if (this.isLevelEnabled(Level.WARN)) {
            this.doAppend(Level.WARN, this.formatMsg(location, jobid, processId, args), t);
        }
    }

    public void shutdown() {
        if (threaded) {
            DuccLoggingEvent ev = new DuccLoggingEvent(null, null, null, null, null, 0L, null);
            ev.done = true;
            events.offer(ev);
        }
    }

    protected static void setThrowable(Throwable t) {
        loggingError = t;
    }

    protected static synchronized void doLog(DuccLoggingEvent ev) {
        if (disable_logger) {
            return;
        }
        MDC.put((String)"COMPONENT", (Object)ev.component);
        MDC.put((String)"TID", (Object)ev.tid);
        MDC.put((String)"TNAME", (Object)ev.threadName);
        try {
            if (ev.throwable == null) {
                ev.logger.log((Priority)ev.level, ev.msg);
            } else {
                ev.logger.log((Priority)ev.level, ev.msg, ev.throwable);
            }
            if (loggingError != null) {
                throw loggingError;
            }
        }
        catch (Throwable t) {
            loggingError = null;
            System.out.println("Disabling logging due to logging exception.");
            disable_logger = true;
            throw new LoggingException("Error writing to DUCC logs", t);
        }
    }

    static class DuccLogErrorHandler
    implements ErrorHandler {
        DuccLogger duccLogger = null;

        DuccLogErrorHandler(DuccLogger dl) {
            this.duccLogger = dl;
        }

        public void error(String msg) {
            System.err.println("A " + msg);
        }

        public void error(String msg, Exception e, int code) {
            System.err.println("B " + msg);
            loggingError = e;
        }

        public void error(String msg, Exception e, int code, LoggingEvent ev) {
            System.err.println("C " + msg);
            loggingError = e;
        }

        public void setAppender(Appender appender) {
            System.err.println("D");
        }

        public void setBackupAppender(Appender appender) {
            System.err.println("E");
        }

        public void setLogger(Logger logger) {
            System.err.println("F");
        }

        public void activateOptions() {
            System.err.println("G");
        }
    }

    static class DuccLoggingThread
    extends Thread {
        DuccLoggingThread() {
        }

        @Override
        public void run() {
            while (true) {
                DuccLoggingEvent ev = null;
                try {
                    ev = (DuccLoggingEvent)events.take();
                }
                catch (InterruptedException e) {
                    System.out.println("Logger is interrupted!");
                    continue;
                }
                if (ev.done) {
                    return;
                }
                DuccLogger.doLog(ev);
            }
        }
    }

    class DuccLoggingEvent {
        Logger logger;
        String component;
        Level level;
        Object msg;
        Throwable throwable;
        boolean done = false;
        long tid;
        String threadName;

        DuccLoggingEvent(Logger logger, String component, Level level, Object msg, Throwable throwable, long threadId, String threadName) {
            this.logger = logger;
            this.component = component;
            this.level = level;
            this.msg = msg;
            this.throwable = throwable;
            this.tid = threadId;
            this.threadName = threadName;
        }
    }
}

