/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.mq;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.uima.ducc.common.exception.DuccConfigurationException;
import org.apache.uima.ducc.common.exception.DuccRuntimeException;
import org.apache.uima.ducc.common.utils.DuccPropertiesHelper;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;

public class MqHelper {
    private String broker_hostname = null;
    private String broker_jmx_port = null;
    private String broker_name = null;
    private String broker_url = null;
    private String objectName = null;
    private ObjectName activeMQ = null;
    private BrokerViewMBean mbean = null;
    private JMXServiceURL url = null;
    private JMXConnector jmxc = null;
    private MBeanServerConnection conn = null;
    private DuccPropertiesResolver duccPropertiesResolver = null;

    public MqHelper() throws IOException, MalformedObjectNameException, NullPointerException, DuccConfigurationException {
        this.resolve();
        this.init();
        this.connect();
    }

    public MqHelper(String broker_hostname, String broker_jmx_port, String broker_name) throws DuccRuntimeException, DuccConfigurationException, MalformedObjectNameException, NullPointerException, IOException {
        this.nonempty("broker_host_name", broker_hostname);
        this.nonempty("broker_jmx_port", broker_jmx_port);
        this.nonempty("broker_name", broker_name);
        this.init();
        this.connect();
    }

    public String get_broker_hostname() {
        return this.broker_hostname;
    }

    public String get_broker_jmx_port() {
        return this.broker_jmx_port;
    }

    public String get_broker_name() {
        return this.broker_name;
    }

    public String get_broker_url() {
        return this.broker_url;
    }

    private void nonempty(String key, String value) throws DuccRuntimeException {
        if (value == null) {
            throw new DuccRuntimeException("missing value for " + key);
        }
    }

    private void init() throws DuccConfigurationException {
        this.broker_url = "service:jmx:rmi:///jndi/rmi://" + this.broker_hostname + ":" + this.broker_jmx_port + "/jmxrmi";
        this.objectName = "org.apache.activemq:BrokerName=" + this.broker_name + ",Type=Broker";
    }

    private void resolve() throws DuccConfigurationException {
        if (this.broker_hostname == null) {
            this.broker_hostname = this.getDuccProperty("ducc.broker.hostname");
        }
        if (this.broker_jmx_port == null) {
            this.broker_jmx_port = this.getDuccProperty("ducc.broker.jmx.port");
        }
        if (this.broker_name == null) {
            this.broker_name = this.getDuccProperty("ducc.broker.name");
        }
    }

    private void configure() {
        this.duccPropertiesResolver = DuccPropertiesHelper.configure();
    }

    private String getDuccProperty(String key) throws DuccConfigurationException {
        String value;
        if (this.duccPropertiesResolver == null) {
            this.configure();
        }
        if ((value = this.duccPropertiesResolver.getFileProperty(key)) == null) {
            throw new DuccConfigurationException("ducc.properties missing " + key);
        }
        if ((value = value.trim()).length() == 0) {
            throw new DuccConfigurationException("ducc.properties undefined " + key);
        }
        return value;
    }

    public void connect() throws IOException, MalformedObjectNameException, NullPointerException {
        this.url = new JMXServiceURL(this.broker_url);
        this.jmxc = JMXConnectorFactory.connect(this.url);
        this.conn = this.jmxc.getMBeanServerConnection();
        this.activeMQ = new ObjectName(this.objectName);
        this.mbean = MBeanServerInvocationHandler.newProxyInstance(this.conn, this.activeMQ, BrokerViewMBean.class, true);
    }

    public String getBrokerUrl() {
        return this.broker_url;
    }

    private boolean isEqual(String a, String b) {
        boolean retVal = false;
        if (a != null && b != null && a.equals(b)) {
            retVal = true;
        }
        return retVal;
    }

    public ArrayList<String> getQueueList() {
        ObjectName[] queues;
        ArrayList<String> qNames = new ArrayList<String>();
        for (ObjectName queue : queues = this.mbean.getQueues()) {
            Hashtable<String, String> propertyTable = queue.getKeyPropertyList();
            if (propertyTable == null) continue;
            String type = propertyTable.get("Type");
            String destination = propertyTable.get("Destination");
            if (!this.isEqual(type, "Queue")) continue;
            qNames.add(destination);
        }
        return qNames;
    }

    public boolean removeQueue(String qName) throws Exception {
        boolean retVal = false;
        this.mbean.removeQueue(qName);
        retVal = true;
        return retVal;
    }

    public static void main(String[] args) {
        try {
            MqHelper mqManager = new MqHelper();
            System.out.println(mqManager.getBrokerUrl());
            ArrayList<String> qList = mqManager.getQueueList();
            for (String qName : qList) {
                System.out.println(qName);
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DuccConfigurationException e) {
            e.printStackTrace();
        }
    }
}

