/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.jd.plugin;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.cas.CAS;
import org.apache.uima.ducc.common.jd.plugin.IJdProcessExceptionHandler;

public abstract class AbstractJdProcessExceptionHandler
implements IJdProcessExceptionHandler {
    protected static final String className = AbstractJdProcessExceptionHandler.class.getName();
    protected static final int maxJobErrors = 15;
    protected static final int maxProcessErrors = 3;
    protected static final int maxCasTimeouts = 2;
    protected AtomicInteger jobErrorCounter = new AtomicInteger(0);
    protected ConcurrentHashMap<String, AtomicInteger> mapProcessErrorCounts = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, AtomicInteger> mapCasTimeoutCounts = new ConcurrentHashMap();

    @Override
    public IJdProcessExceptionHandler.Directive handle(String processId, CAS cas, Throwable t, Properties properties) {
        IJdProcessExceptionHandler.Directive directive = null;
        try {
            directive = this.handleRetry(processId, cas, t, properties);
            if (directive != null) {
                return directive;
            }
            directive = this.handleError(processId, cas, t, properties);
            if (directive != null) {
                return directive;
            }
            directive = IJdProcessExceptionHandler.Directive.ProcessContinue_CasNoRetry;
            directive.setReason("default");
        }
        catch (Exception e) {
            directive = IJdProcessExceptionHandler.Directive.ProcessContinue_CasNoRetry;
            directive.setReason("exception during exception handler");
        }
        return directive;
    }

    protected void record(String message) {
        System.out.println(className + ": " + message);
    }

    protected void record(StringBuffer message) {
        this.record(message.toString());
    }

    protected boolean isEqual(String s1, String s2) {
        if (s1 == null) {
            return false;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    protected AnalysisOfCause getAnalysisOfCause(Throwable t) {
        AnalysisOfCause retVal = AnalysisOfCause.Other;
        if (t != null) {
            Throwable nextCause = t.getCause();
            int level = 0;
            while (nextCause != null) {
                String sCause = nextCause.toString();
                this.record(sCause);
                if (this.isEqual(sCause, "org.apache.uima.aae.error.UimaASProcessCasTimeout")) {
                    if (level > 0) {
                        retVal = AnalysisOfCause.RemoteTimeout;
                        break;
                    }
                    retVal = AnalysisOfCause.LocalTimeout;
                    break;
                }
                nextCause = nextCause.getCause();
                ++level;
            }
        }
        return retVal;
    }

    protected boolean isLocalTimeout(AnalysisOfCause analysisOfCause) {
        boolean retVal = false;
        if (analysisOfCause != null) {
            switch (analysisOfCause) {
                case LocalTimeout: {
                    retVal = true;
                }
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IJdProcessExceptionHandler.Directive handleRetry(String processId, CAS cas, Throwable t, Properties properties) {
        IJdProcessExceptionHandler.Directive directive = null;
        AnalysisOfCause analysisOfCause = this.getAnalysisOfCause(t);
        if (this.isLocalTimeout(analysisOfCause)) {
            AtomicInteger casTimeoutCounter;
            String casId = (String)properties.get((Object)IJdProcessExceptionHandler.JdProperties.SequenceNumber);
            ConcurrentHashMap<String, AtomicInteger> concurrentHashMap = this.mapCasTimeoutCounts;
            synchronized (concurrentHashMap) {
                if (!this.mapCasTimeoutCounts.containsKey(casId)) {
                    casTimeoutCounter = new AtomicInteger(0);
                    this.mapCasTimeoutCounts.put(casId, casTimeoutCounter);
                }
            }
            casTimeoutCounter = this.mapCasTimeoutCounts.get(casId);
            Integer casTimeouts = casTimeoutCounter.addAndGet(1);
            if (casTimeouts >= 2) {
                directive = IJdProcessExceptionHandler.Directive.ProcessStop_CasNoRetry;
                directive.setReason("casTimeouts:" + casTimeouts + " >= " + "maxCasTimeouts:" + 2);
            } else {
                directive = IJdProcessExceptionHandler.Directive.ProcessStop_CasRetry;
                directive.setReason("CasTimeout");
            }
            StringBuffer message = new StringBuffer();
            message.append("directive=" + (Object)((Object)directive));
            message.append(", ");
            message.append("[" + casId + "]=" + casTimeouts + " " + "timeouts");
            this.record(message);
        }
        return directive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IJdProcessExceptionHandler.Directive handleError(String processId, CAS cas, Throwable t, Properties properties) {
        Integer jobErrors;
        AtomicInteger processErrorCounter;
        IJdProcessExceptionHandler.Directive directive = IJdProcessExceptionHandler.Directive.ProcessContinue_CasNoRetry;
        directive.setReason("default");
        if (processId == null) {
            StringBuffer message = new StringBuffer();
            message.append("processId missing");
            this.record(message);
            processId = "unknown";
        }
        ConcurrentHashMap<String, AtomicInteger> concurrentHashMap = this.mapProcessErrorCounts;
        synchronized (concurrentHashMap) {
            if (!this.mapProcessErrorCounts.containsKey(processId)) {
                processErrorCounter = new AtomicInteger(0);
                this.mapProcessErrorCounts.put(processId, processErrorCounter);
            }
        }
        processErrorCounter = this.mapProcessErrorCounts.get(processId);
        Integer processErrors = processErrorCounter.addAndGet(1);
        if (processErrors >= 3) {
            directive = IJdProcessExceptionHandler.Directive.ProcessStop_CasNoRetry;
            directive.setReason("processErrors:" + processErrors + " >= " + "maxProcessErrors:" + 3);
        }
        if ((jobErrors = Integer.valueOf(this.jobErrorCounter.addAndGet(1))) >= 15) {
            directive = IJdProcessExceptionHandler.Directive.JobStop;
            directive.setReason("jobErrors:" + jobErrors + " >= " + "maxJobErrors:" + 15);
        }
        StringBuffer message = new StringBuffer();
        message.append("directive=" + (Object)((Object)directive));
        message.append(", ");
        message.append("[" + processId + "]=" + processErrors);
        message.append(", ");
        message.append("[total]=" + jobErrors);
        this.record(message);
        return directive;
    }

    private static enum AnalysisOfCause {
        RemoteTimeout,
        LocalTimeout,
        Other;

    }
}

