/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.jd.files;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.uima.ducc.common.jd.files.IWorkItemState;
import org.apache.uima.ducc.common.jd.files.WorkItemState;
import org.apache.uima.ducc.common.jd.files.WorkItemStateJson;
import org.apache.uima.ducc.common.jd.files.WorkItemStateJsonGz;
import org.apache.uima.ducc.common.jd.files.WorkItemStateSerializedObjects;

public class WorkItemStateManager {
    private ConcurrentSkipListMap<Long, IWorkItemState> map = new ConcurrentSkipListMap();
    private WorkItemStateSerializedObjects pSer;
    private WorkItemStateJson pJson;
    private WorkItemStateJsonGz pJsonGz;

    public WorkItemStateManager(String dirname) {
        this.pSer = new WorkItemStateSerializedObjects(dirname);
        this.pJson = new WorkItemStateJson(dirname);
        this.pJsonGz = new WorkItemStateJsonGz(dirname);
    }

    public ConcurrentSkipListMap<Long, IWorkItemState> getMap() {
        return this.map;
    }

    public void exportData() throws IOException {
        try {
            this.pJsonGz.exportData(this.map);
            return;
        }
        catch (Exception e) {
            try {
                this.pJson.exportData(this.map);
                return;
            }
            catch (Exception exception) {
                this.pSer.exportData(this.map);
                return;
            }
        }
    }

    public void importData() throws IOException, ClassNotFoundException {
        String userId = null;
        this.importData(userId);
    }

    public void importData(String userId) throws IOException, ClassNotFoundException {
        try {
            this.map = this.pJsonGz.importData(userId);
            return;
        }
        catch (Exception e) {
            try {
                this.map = this.pJson.importData();
                return;
            }
            catch (Exception exception) {
                this.map = this.pSer.importData();
                return;
            }
        }
    }

    public void start(int seqNo, String wiId) {
        WorkItemState wis = new WorkItemState(seqNo);
        Long key = new Long(seqNo);
        this.map.put(key, wis);
        wis.setWiId(wiId);
        wis.stateStart();
    }

    public void queued(String seqNo) {
        Long key = new Long(seqNo);
        this.queued(key.intValue());
    }

    public void queued(int seqNo) {
        Long key = new Long(seqNo);
        IWorkItemState wis = this.map.get(key);
        wis.stateQueued();
    }

    public void operating(String seqNo) {
        Long key = new Long(seqNo);
        this.operating(key.intValue());
    }

    public void operating(int seqNo) {
        Long key = new Long(seqNo);
        IWorkItemState wis = this.map.get(key);
        wis.stateOperating();
    }

    public void ended(int seqNo) {
        Long key = new Long(seqNo);
        IWorkItemState wis = this.map.get(key);
        wis.stateEnded();
    }

    public void error(int seqNo) {
        Long key = new Long(seqNo);
        IWorkItemState wis = this.map.get(key);
        wis.stateError();
    }

    public void lost(int seqNo) {
        Long key = new Long(seqNo);
        IWorkItemState wis = this.map.get(key);
        wis.stateLost();
    }

    public void retry(int seqNo) {
        Long key = new Long(seqNo);
        IWorkItemState wis = this.map.get(key);
        wis.stateRetry();
    }

    public void location(String seqNo, String node, String pid) {
        Long key = new Long(seqNo);
        this.location(key.intValue(), node, pid);
    }

    public void location(int seqNo, String node, String pid) {
        Long key = new Long(seqNo);
        IWorkItemState wis = this.map.get(key);
        wis.setNode(node);
        wis.setPid(pid);
    }

    public double getMin() {
        double retVal = -1.0;
        try {
            for (Map.Entry<Long, IWorkItemState> entry : this.map.entrySet()) {
                IWorkItemState workItemState = entry.getValue();
                switch (workItemState.getState()) {
                    case ended: {
                        long millis = workItemState.getMillisProcessing();
                        if ((double)millis < retVal) {
                            retVal = millis;
                            break;
                        }
                        if (!(retVal < 0.0)) break;
                        retVal = millis;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    public double getMax() {
        double retVal = -1.0;
        try {
            for (Map.Entry<Long, IWorkItemState> entry : this.map.entrySet()) {
                IWorkItemState workItemState = entry.getValue();
                switch (workItemState.getState()) {
                    case ended: {
                        long millis = workItemState.getMillisProcessing();
                        if (!((double)millis > retVal)) break;
                        retVal = millis;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    public double getAvg() {
        double retVal = 0.0;
        try {
            int count = 0;
            for (Map.Entry<Long, IWorkItemState> entry : this.map.entrySet()) {
                IWorkItemState workItemState = entry.getValue();
                switch (workItemState.getState()) {
                    case ended: {
                        retVal += (double)workItemState.getMillisProcessing();
                        ++count;
                    }
                }
            }
            if (count > 0) {
                retVal /= (double)count;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }
}

