/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli.aio;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.ducc.cli.aio.AllInOne;
import org.apache.uima.ducc.common.utils.QuotedOptions;
import org.apache.uima.ducc.user.common.UimaUtils;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;

public class CasGenerator {
    public static String cid = CasGenerator.class.getSimpleName();
    protected AllInOne.MsgHandler mh;
    protected Properties properties = new Properties();
    private CollectionReader cr;
    private TypePriorities cr_tp;
    private TypeSystemDescription cr_tsd;
    private FsIndexDescription[] cr_fid;
    private Properties cr_properties = new Properties();
    private int total;

    public CasGenerator(Properties properties, AllInOne.MsgHandler mh) {
        if (properties != null) {
            this.properties = properties;
        }
        if (mh != null) {
            this.mh = mh;
        }
    }

    public void initialize() throws InvalidXMLException, ResourceConfigurationException, ResourceInitializationException {
        String mid = "initialize";
        String crDescriptor = this.properties.getProperty(AllInOne.DriverDescriptorCR);
        String crOverrides = this.properties.getProperty(AllInOne.DriverDescriptorCROverrides);
        XMLParser xmlParser = UIMAFramework.getXMLParser();
        XMLInputSource in = UimaUtils.getXMLInputSource((String)crDescriptor);
        CollectionReaderDescription crrs = xmlParser.parseCollectionReaderDescription(in);
        ResourceCreationSpecifier specifier = (ResourceCreationSpecifier)crrs;
        ConfigurationParameterDeclarations configurationParameterDeclarations = specifier.getMetaData().getConfigurationParameterDeclarations();
        ConfigurationParameterSettings cps = specifier.getMetaData().getConfigurationParameterSettings();
        if (crOverrides != null) {
            ArrayList toks = QuotedOptions.tokenizeList((String)crOverrides, (boolean)true);
            Map map = QuotedOptions.parseAssignments((List)toks, (int)0);
            for (Map.Entry ent : map.entrySet()) {
                String name = (String)ent.getKey();
                String value = (String)ent.getValue();
                String message = "config param: " + name + " = '" + value + "'";
                this.mh.frameworkDebug(cid, mid, message);
                ConfigurationParameter configurationParameter = UimaUtils.findConfigurationParameter((ConfigurationParameterDeclarations)configurationParameterDeclarations, (String)name);
                if (configurationParameter == null) {
                    throw new ResourceConfigurationException("nonexistent_parameter", new Object[]{name, "CollectionReader"});
                }
                Object object = UimaUtils.getOverrideValueObject((ConfigurationParameter)configurationParameter, (String)value);
                cps.setParameterValue(name, object);
            }
        }
        this.cr = UIMAFramework.produceCollectionReader((ResourceSpecifier)crrs);
        this.cr_properties.setProperty("cas_initial_heap_size", "1000");
        this.cr_tp = this.cr.getProcessingResourceMetaData().getTypePriorities();
        this.cr_tsd = this.cr.getProcessingResourceMetaData().getTypeSystem();
        this.cr_fid = this.cr.getProcessingResourceMetaData().getFsIndexes();
        this.initTotal();
        this.mh.frameworkInfo(cid, mid, "total:" + this.getTotal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Progress[] getProgressArray() {
        Progress[] retVal;
        CollectionReader collectionReader = this.cr;
        synchronized (collectionReader) {
            retVal = this.cr.getProgress();
        }
        return retVal;
    }

    public Progress getProgress() {
        Progress progress = null;
        Progress[] progressArray = this.getProgressArray();
        if (progressArray != null) {
            progress = progressArray[0];
        }
        return progress;
    }

    private void initTotal() {
        Progress progress = this.getProgress();
        if (progress != null) {
            this.total = (int)progress.getTotal();
        }
    }

    public int getTotal() {
        return this.total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private CAS getEmptyCas() throws ResourceInitializationException {
        CAS cas = null;
        while (cas == null) {
            Class<CasCreationUtils> clazz = CasCreationUtils.class;
            // MONITORENTER : org.apache.uima.util.CasCreationUtils.class
            cas = CasCreationUtils.createCas((TypeSystemDescription)this.cr_tsd, (TypePriorities)this.cr_tp, (FsIndexDescription[])this.cr_fid, (Properties)this.cr_properties);
            // MONITOREXIT : clazz
        }
        return cas;
    }

    private CAS getNewCas() throws ResourceInitializationException, CollectionException, IOException {
        CAS cas = this.getEmptyCas();
        this.cr.getNext(cas);
        return cas;
    }

    public CAS getUsedCas(CAS cas) throws CollectionException, IOException, ResourceInitializationException {
        cas.reset();
        this.cr.getNext(cas);
        return cas;
    }

    public CAS getCas(CAS cas) throws CollectionException, IOException, ResourceInitializationException {
        if (cas == null) {
            return this.getNewCas();
        }
        return this.getUsedCas(cas);
    }

    public boolean hasNext() throws CollectionException, IOException {
        return this.cr.hasNext();
    }
}

