/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli.aio;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DDParser
extends DefaultHandler {
    private File file = null;
    private FileInputStream fis = null;
    private SAXParser parser = null;
    private String ddImport = null;

    public DDParser(String filename) throws ParserConfigurationException, SAXException, IOException {
        this.file = new File(filename);
        this.parse();
    }

    public DDParser(File file) throws ParserConfigurationException, SAXException, IOException {
        this.file = file;
        this.parse();
    }

    private void parse() throws ParserConfigurationException, SAXException, IOException {
        this.fis = new FileInputStream(this.file);
        this.parser = SAXParserFactory.newInstance().newSAXParser();
        this.parser.parse((InputStream)this.fis, (DefaultHandler)this);
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName != null && qName.trim().equalsIgnoreCase("import")) {
            int count = attributes.getLength();
            for (int i = 0; i < count; ++i) {
                String name = attributes.getQName(i);
                String value = attributes.getValue(i);
                if (name == null || !name.trim().equalsIgnoreCase("name") && !name.trim().equalsIgnoreCase("location")) continue;
                this.ddImport = value;
            }
        }
    }

    public String getDDImport() {
        return this.ddImport;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(args[0]);
        DDParser ddParser = new DDParser(args[0]);
        System.out.println(ddParser.getDDImport());
    }
}

