/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli.ws;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.apache.uima.ducc.cli.ws.DuccWebQuery;
import org.apache.uima.ducc.cli.ws.json.MachineFacts;
import org.apache.uima.ducc.cli.ws.json.MachineFactsList;

public class DuccWebQueryMachines
extends DuccWebQuery {
    private DuccWebQueryMachines() {
        super("/ducc-servlet/json-format-machines");
    }

    private MachineFactsList get() throws Exception {
        URL url = new URL(this.getUrlString());
        URLConnection ucon = url.openConnection();
        BufferedReader br = new BufferedReader(new InputStreamReader(ucon.getInputStream()));
        String jSon = br.readLine();
        Gson gson = new Gson();
        MachineFactsList fl = (MachineFactsList)gson.fromJson(jSon, MachineFactsList.class);
        br.close();
        return fl;
    }

    private String stringify(List<String> list) {
        StringBuffer sb = new StringBuffer();
        for (String item : list) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(item);
        }
        return "[" + sb.toString() + "]";
    }

    private void display(MachineFactsList fl) {
        if (fl != null) {
            for (MachineFacts f : fl) {
                System.out.println(f.name);
                System.out.println("  status: " + f.status);
                System.out.println("  aliens: " + this.stringify(f.aliens));
                System.out.println("  swapInuse: " + f.swapInuse);
                System.out.println("  swapFree: " + f.swapFree);
                System.out.println("  memoryEffective: " + f.memoryEffective);
                System.out.println("  memoryTotal: " + f.memoryTotal);
                System.out.println("  sharesTotal: " + f.sharesTotal);
                System.out.println("  sharesInuse: " + f.sharesInuse);
                System.out.println("  ip: " + f.ip);
                System.out.println("  heartbeat: " + f.heartbeat);
            }
        } else {
            System.out.println("?");
        }
    }

    private void main_instance(String[] args) throws Exception {
        MachineFactsList fl = this.get();
        this.display(fl);
    }

    public static void main(String[] args) {
        try {
            DuccWebQueryMachines dwq = new DuccWebQueryMachines();
            dwq.main_instance(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

