/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli.aio;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.uima.ducc.cli.CliBase;
import org.apache.uima.ducc.cli.DuccJobSubmit;
import org.apache.uima.ducc.cli.DuccManagedReservationSubmit;
import org.apache.uima.ducc.cli.IDuccCallback;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.cli.aio.AllInOne;
import org.apache.uima.ducc.cli.aio.IMessageHandler;
import org.apache.uima.ducc.cli.aio.MessageHandler;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.DuccSchedulerClasses;
import org.apache.uima.ducc.common.utils.QuotedOptions;
import org.apache.uima.ducc.transport.event.cli.JobRequestProperties;

public class AllInOneLauncher
extends CliBase {
    private static String cid = AllInOneLauncher.class.getSimpleName();
    private static String remote = "remote";
    private static String local = "local";
    private static String enter = "enter";
    private static String exit = "exit";
    private String allInOneType = null;
    private String jvm = null;
    private String log_directory = null;
    private String working_directory = null;
    private String classpath = null;
    private String environment = null;
    private String process_jvm_args = null;
    private String debug_jvm_args = null;
    private String driver_descriptor_CR = null;
    private String driver_descriptor_CR_overrides = null;
    private String process_descriptor_CM = null;
    private String process_descriptor_CM_overrides = null;
    private String process_descriptor_AE = null;
    private String process_descriptor_AE_overrides = null;
    private String process_descriptor_CC = null;
    private String process_descriptor_CC_overrides = null;
    private String process_DD = null;
    private String process_memory_size = null;
    private String description = null;
    private String scheduling_class = null;
    private String specification = null;
    private String signature = null;
    private String user = null;
    private boolean wait_for_completion = false;
    private boolean cancel_on_interrupt = false;
    private boolean classpath_user_first = true;
    private IMessageHandler mh = new MessageHandler();
    private JobRequestProperties jobRequestProperties = new JobRequestProperties();
    private IUiOptions.UiOption[] opts = DuccJobSubmit.opts;
    private HashMap<String, String> optionsMap = new HashMap();
    IUiOptions.UiOption[] allInOneOpts = new IUiOptions.UiOption[]{IUiOptions.UiOption.Debug, IUiOptions.UiOption.Timestamp, IUiOptions.UiOption.DriverDescriptorCR, IUiOptions.UiOption.DriverDescriptorCROverrides, IUiOptions.UiOption.ProcessDD, IUiOptions.UiOption.ProcessDescriptorCM, IUiOptions.UiOption.ProcessDescriptorCMOverrides, IUiOptions.UiOption.ProcessDescriptorAE, IUiOptions.UiOption.ProcessDescriptorAEOverrides, IUiOptions.UiOption.ProcessDescriptorCC, IUiOptions.UiOption.ProcessDescriptorCCOverrides};

    public AllInOneLauncher(String[] args) throws Exception {
        this.init(this.getClass().getName(), this.opts, args, (DuccProperties)this.jobRequestProperties, null);
    }

    public AllInOneLauncher(String[] args, IDuccCallback consoleCb) throws Exception {
        this.mh = new MessageHandler(consoleCb);
        this.init(this.getClass().getName(), this.opts, args, (DuccProperties)this.jobRequestProperties, consoleCb);
    }

    private boolean isLocal() {
        return this.allInOneType.equalsIgnoreCase(local);
    }

    private void ignored() {
        String mid = "ignored";
        this.mh.frameworkTrace(cid, mid, enter);
        Enumeration keys = this.jobRequestProperties.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            boolean examined = this.optionsMap.containsKey(key);
            if (examined) continue;
            String message = "ignoring " + key;
            this.mh.warn(cid, mid, message);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void used(String opt) {
        String mid = "used";
        this.mh.frameworkTrace(cid, mid, enter);
        this.optionsMap.put(opt, opt);
        String message = opt;
        this.mh.frameworkDebug(cid, mid, message);
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void enableDebugFlags() {
        String mid = "enableDebugFlags";
        this.mh.frameworkTrace(cid, mid, enter);
        this.mh.setLevel(IMessageHandler.Level.FrameworkInfo, IMessageHandler.Toggle.On);
        this.mh.setLevel(IMessageHandler.Level.FrameworkDebug, IMessageHandler.Toggle.On);
        this.mh.setLevel(IMessageHandler.Level.FrameworkError, IMessageHandler.Toggle.On);
        this.mh.setLevel(IMessageHandler.Level.FrameworkWarn, IMessageHandler.Toggle.On);
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_debug() {
        String mid = "examine_debug";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.Debug.pname();
        this.debug = this.jobRequestProperties.containsKey((Object)pname);
        if (this.debug) {
            this.enableDebugFlags();
            String message = "true";
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_process_debug() {
        String mid = "examine_process_debug";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.ProcessDebug.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            int port = Integer.parseInt(this.jobRequestProperties.getProperty(pname));
            this.debug_jvm_args = "-Xdebug -Xrunjdwp:transport=dt_socket,address=" + this.host_address + ":" + port;
            this.mh.frameworkDebug(cid, mid, this.debug_jvm_args);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_driver_debug() {
        String mid = "examine_driver_debug";
        this.mh.frameworkTrace(cid, mid, enter);
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_timestamp() {
        String mid = "examine_timestamp";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.Timestamp.pname();
        boolean timestamp = this.jobRequestProperties.containsKey((Object)pname);
        if (timestamp) {
            this.mh.setTimestamping(IMessageHandler.Toggle.On);
            String message = "true";
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_allInOne() throws MissingArgumentException, IllegalArgumentException {
        String mid = "examine_allInOne";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.AllInOne.pname();
        this.allInOneType = this.jobRequestProperties.getProperty(pname);
        if (this.allInOneType == null) {
            throw new MissingArgumentException(pname);
        }
        if (this.allInOneType.equalsIgnoreCase(local)) {
            String message = this.allInOneType;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        } else if (this.allInOneType.equalsIgnoreCase(remote)) {
            String message = this.allInOneType;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        } else {
            throw new IllegalArgumentException(pname + ": " + this.allInOneType);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_process_attach_console() {
        String mid = "examine_process_attach_console";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.AttachConsole.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            String message = "attach_console";
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_jvm() {
        String mid = "examine_jvm";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.Jvm.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            String message = this.jvm = this.jobRequestProperties.getProperty(pname);
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        } else {
            String message = this.jvm = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            this.mh.frameworkDebug(cid, mid, message);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_log_directory() {
        String mid = "examine_log_directory";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.LogDirectory.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            String message = this.log_directory = this.jobRequestProperties.getProperty(pname);
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_working_directory() {
        String mid = "examine_working_directory";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.WorkingDirectory.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            String message = this.working_directory = this.jobRequestProperties.getProperty(pname);
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        } else {
            String message = this.working_directory = System.getProperty("user.dir");
            this.mh.frameworkDebug(cid, mid, message);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_process_jvm_args() {
        String mid = "examine_process_jvm_args";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.ProcessJvmArgs.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            this.process_jvm_args = this.jobRequestProperties.getProperty(pname);
            if (this.debug_jvm_args != null) {
                this.process_jvm_args = this.process_jvm_args + " " + this.debug_jvm_args;
            }
            String message = this.process_jvm_args;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        } else {
            this.process_jvm_args = this.debug_jvm_args;
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_classpath() {
        String mid = "examine_classpath";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.Classpath.pname();
        this.classpath = this.jobRequestProperties.getProperty(pname);
        if (this.classpath == null) {
            this.classpath = System.getProperty("java.class.path");
        }
        this.used(pname);
        String message = this.classpath;
        this.mh.frameworkDebug(cid, mid, message);
        pname = IUiOptions.UiOption.ClasspathOrder.pname();
        String value = this.jobRequestProperties.getProperty(pname);
        this.used(pname);
        this.classpath_user_first = value.equals(IUiOptions.ClasspathOrderParms.UserBeforeDucc.pname());
        message = value;
        this.mh.frameworkDebug(cid, mid, message);
        String duccClasspath = this.ducc_home + "/lib/uima-ducc-cli.jar";
        this.classpath = this.classpath_user_first ? this.classpath + File.pathSeparatorChar + duccClasspath : duccClasspath + File.pathSeparatorChar + this.classpath;
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_environment() {
        String mid = "examine_environment";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.Environment.pname();
        this.environment = this.jobRequestProperties.getProperty(pname);
        if (this.environment != null) {
            String message = this.environment;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_description() {
        String mid = "examine_description";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.Description.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            this.description = this.jobRequestProperties.getProperty(pname);
            String message = pname + "=" + this.description;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_scheduling_class() throws Exception {
        String mid = "examine_scheduling_class";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.SchedulingClass.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            String specific_scheduling_class;
            DuccSchedulerClasses duccSchedulerClasses = DuccSchedulerClasses.getInstance();
            this.scheduling_class = this.jobRequestProperties.getProperty(pname);
            String message = pname + "=" + this.scheduling_class + " [original]";
            if (this.isLocal()) {
                message = pname + "=" + this.scheduling_class + " not considered";
                this.mh.debug(cid, mid, message);
            } else if (duccSchedulerClasses.isPreemptable(this.scheduling_class) && (specific_scheduling_class = duccSchedulerClasses.getDebugClassSpecificName(this.scheduling_class)) != null) {
                this.scheduling_class = specific_scheduling_class;
                this.jobRequestProperties.put((Object)pname, (Object)this.scheduling_class);
                message = pname + "=" + this.scheduling_class + " [replacement, specific]";
                this.mh.info(cid, mid, message);
            }
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_signature() {
        String mid = "examine_signature";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.Signature.pname();
        if (this.isLocal()) {
            this.used(pname);
        }
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            this.signature = this.jobRequestProperties.getProperty(pname);
            String message = pname + "=" + this.signature;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_user() {
        String mid = "examine_user";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.User.pname();
        if (this.isLocal()) {
            this.used(pname);
        }
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            this.user = this.jobRequestProperties.getProperty(pname);
            String message = pname + "=" + this.user;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_driver_descriptor_CR() {
        String mid = "examine_driver_descriptor_CR";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.DriverDescriptorCR.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            this.driver_descriptor_CR = this.jobRequestProperties.getProperty(pname);
            String message = pname + "=" + this.driver_descriptor_CR;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_driver_descriptor_CR_overrides() {
        String mid = "examine_driver_descriptor_CR_overrides";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.DriverDescriptorCROverrides.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            this.driver_descriptor_CR_overrides = this.jobRequestProperties.getProperty(pname);
            String message = pname + "=" + this.driver_descriptor_CR_overrides;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_process_memory_size() {
        String mid = "examine_process_memory_size";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.ProcessMemorySize.pname();
        if (this.jobRequestProperties.containsKey((Object)pname) && !this.isLocal()) {
            this.process_memory_size = this.jobRequestProperties.getProperty(pname);
            String message = pname + "=" + this.process_memory_size;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_process_DD() {
        String mid = "examine_process_DD";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.ProcessDD.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            this.process_DD = this.jobRequestProperties.getProperty(pname);
            String message = pname + "=" + this.process_DD;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_process_descriptor_CM() {
        String mid = "examine_process_descriptor_CM";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.ProcessDescriptorCM.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            this.process_descriptor_CM = this.jobRequestProperties.getProperty(pname);
            String message = pname + "=" + this.process_descriptor_CM;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_process_descriptor_CM_overrides() {
        String mid = "examine_process_descriptor_CMOverrides";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.ProcessDescriptorCMOverrides.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            this.process_descriptor_CM_overrides = this.jobRequestProperties.getProperty(pname);
            String message = pname + "=" + this.process_descriptor_CM_overrides;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_process_descriptor_AE() {
        String mid = "examine_process_descriptor_AE";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.ProcessDescriptorAE.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            this.process_descriptor_AE = this.jobRequestProperties.getProperty(pname);
            String message = pname + "=" + this.process_descriptor_AE;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_process_descriptor_AE_overrides() {
        String mid = "examine_process_descriptor_AE_overrides";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.ProcessDescriptorAEOverrides.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            this.process_descriptor_AE_overrides = this.jobRequestProperties.getProperty(pname);
            String message = pname + "=" + this.process_descriptor_AE_overrides;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_process_descriptor_CC() {
        String mid = "examine_process_descriptor_CC";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.ProcessDescriptorCC.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            this.process_descriptor_CC = this.jobRequestProperties.getProperty(pname);
            String message = pname + "=" + this.process_descriptor_CC;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_process_descriptor_CC_overrides() {
        String mid = "examine_process_descriptor_CC_overrides";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.ProcessDescriptorCCOverrides.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            this.process_descriptor_CC_overrides = this.jobRequestProperties.getProperty(pname);
            String message = pname + "=" + this.process_descriptor_CC_overrides;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_specification() {
        String mid = "examine_specification";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.Specification.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            this.specification = this.jobRequestProperties.getProperty(pname);
            String message = pname + "=" + this.specification;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_wait_for_completion() {
        String mid = "examine_wait_for_completion";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.WaitForCompletion.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            this.wait_for_completion = true;
            String message = pname + "=" + this.wait_for_completion;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_cancel_on_interrupt() {
        String mid = "examine_cancel_on_interrupt";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = IUiOptions.UiOption.CancelOnInterrupt.pname();
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            this.cancel_on_interrupt = true;
            this.wait_for_completion = true;
            String message = pname + "=" + this.cancel_on_interrupt;
            this.mh.frameworkDebug(cid, mid, message);
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine_submitter_pid_at_host() {
        String mid = "examine_submitter_pid_at_host";
        this.mh.frameworkTrace(cid, mid, enter);
        String pname = "submitter_pid_at_host";
        if (this.jobRequestProperties.containsKey((Object)pname)) {
            this.used(pname);
        }
        this.mh.frameworkTrace(cid, mid, exit);
    }

    private void examine() throws Exception {
        String mid = "examine";
        this.mh.frameworkTrace(cid, mid, "enter");
        this.examine_debug();
        this.examine_process_debug();
        this.examine_driver_debug();
        this.examine_process_attach_console();
        this.examine_timestamp();
        this.examine_allInOne();
        this.examine_jvm();
        this.examine_log_directory();
        this.examine_working_directory();
        this.examine_process_jvm_args();
        this.examine_classpath();
        this.examine_environment();
        this.examine_driver_descriptor_CR();
        this.examine_driver_descriptor_CR_overrides();
        this.examine_process_descriptor_CM();
        this.examine_process_descriptor_CM_overrides();
        this.examine_process_descriptor_AE();
        this.examine_process_descriptor_AE_overrides();
        this.examine_process_descriptor_CC();
        this.examine_process_descriptor_CC_overrides();
        this.examine_process_DD();
        this.examine_process_memory_size();
        this.examine_description();
        this.examine_scheduling_class();
        this.examine_wait_for_completion();
        this.examine_cancel_on_interrupt();
        this.examine_specification();
        this.examine_signature();
        this.examine_user();
        this.examine_submitter_pid_at_host();
        this.ignored();
        this.mh.frameworkTrace(cid, mid, "exit");
    }

    private void launch_local() throws IOException {
        String line;
        String mid = "launch_local";
        this.mh.frameworkTrace(cid, mid, "enter");
        String message = "local";
        this.mh.frameworkDebug(cid, mid, message);
        ArrayList<String> commandArray = new ArrayList<String>();
        commandArray.add(this.jvm);
        commandArray.add("-classpath");
        commandArray.add(this.classpath);
        if (this.process_jvm_args != null) {
            ArrayList jvmargs = QuotedOptions.tokenizeList((String)this.process_jvm_args, (boolean)true);
            for (String jvmarg : jvmargs) {
                commandArray.add(jvmarg);
            }
        }
        commandArray.add(AllInOne.class.getCanonicalName());
        for (IUiOptions.UiOption opt : this.allInOneOpts) {
            String val = this.jobRequestProperties.getProperty(opt.pname());
            if (val == null) continue;
            commandArray.add("--" + opt.pname());
            if (opt.argname() == null) continue;
            commandArray.add(val);
        }
        String[] command = commandArray.toArray(new String[0]);
        ProcessBuilder pb = new ProcessBuilder(command);
        if (this.working_directory != null) {
            message = "working directory: " + this.working_directory;
            this.mh.frameworkDebug(cid, mid, message);
            File wd = new File(this.working_directory);
            pb.directory(wd);
        }
        if (this.environment != null) {
            ArrayList envList = QuotedOptions.tokenizeList((String)this.environment, (boolean)true);
            Map envMap = QuotedOptions.parseAssignments((List)envList, (boolean)false);
            Map<String, String> env = pb.environment();
            env.clear();
            env.putAll(envMap);
        }
        for (String arg : commandArray) {
            this.mh.frameworkDebug(cid, mid, arg);
        }
        pb.redirectErrorStream(true);
        Process process = pb.start();
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader ibr = new BufferedReader(isr);
        while ((line = ibr.readLine()) != null) {
            this.consoleCb.console(1, line);
        }
        ibr.close();
        try {
            this.returnCode = process.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.mh.frameworkTrace(cid, mid, "exit");
    }

    private void addArg(ArrayList<String> cmdLine, String arg) {
        String mid = "launch_remote";
        this.mh.frameworkTrace(cid, mid, "enter");
        cmdLine.add(arg);
        this.mh.frameworkDebug(cid, mid, arg);
        this.mh.frameworkTrace(cid, mid, "exit");
    }

    private String getProcessExecutableArgs() {
        String mid = "getProcessExecutableArgs";
        this.mh.frameworkTrace(cid, mid, "enter");
        StringBuffer sb = new StringBuffer();
        if (this.process_jvm_args != null) {
            sb.append(this.process_jvm_args);
        }
        sb.append(" -classpath");
        sb.append(" ");
        sb.append(this.classpath);
        sb.append(" ");
        sb.append(AllInOne.class.getCanonicalName());
        sb.append(" ");
        for (IUiOptions.UiOption opt : this.allInOneOpts) {
            String val = this.jobRequestProperties.getProperty(opt.pname());
            if (val == null) continue;
            sb.append(" --" + opt.pname());
            if (opt.argname() == null) continue;
            if (val.indexOf(32) >= 0) {
                sb.append(" \"" + val + "\"");
                continue;
            }
            sb.append(" " + val);
        }
        this.mh.frameworkTrace(cid, mid, "exit");
        return sb.toString();
    }

    private void launch_remote() throws Exception {
        String mid = "launch_remote";
        this.mh.frameworkTrace(cid, mid, "enter");
        ArrayList<String> cmdLine = new ArrayList<String>();
        this.addArg(cmdLine, "--" + IUiOptions.UiOption.ProcessExecutable.pname());
        this.addArg(cmdLine, this.jvm);
        this.addArg(cmdLine, "--" + IUiOptions.UiOption.ProcessExecutableArgs.pname());
        this.addArg(cmdLine, this.getProcessExecutableArgs());
        if (this.scheduling_class != null) {
            this.addArg(cmdLine, "--" + IUiOptions.UiOption.SchedulingClass.pname());
            this.addArg(cmdLine, this.scheduling_class);
        }
        if (this.environment != null) {
            this.addArg(cmdLine, "--" + IUiOptions.UiOption.Environment.pname());
            this.addArg(cmdLine, this.environment);
        }
        if (this.process_memory_size != null) {
            this.addArg(cmdLine, "--" + IUiOptions.UiOption.ProcessMemorySize.pname());
            this.addArg(cmdLine, this.process_memory_size);
        }
        if (this.log_directory != null) {
            this.addArg(cmdLine, "--" + IUiOptions.UiOption.LogDirectory.pname());
            this.addArg(cmdLine, this.log_directory);
        }
        if (this.working_directory != null) {
            this.addArg(cmdLine, "--" + IUiOptions.UiOption.WorkingDirectory.pname());
            this.addArg(cmdLine, this.working_directory);
        }
        if (this.description != null) {
            this.addArg(cmdLine, "--" + IUiOptions.UiOption.Description.pname());
            this.addArg(cmdLine, this.description);
        }
        if (this.wait_for_completion) {
            this.addArg(cmdLine, "--" + IUiOptions.UiOption.WaitForCompletion.pname());
        }
        if (this.cancel_on_interrupt) {
            this.addArg(cmdLine, "--" + IUiOptions.UiOption.CancelOnInterrupt.pname());
        }
        this.addArg(cmdLine, "--" + IUiOptions.UiOption.AttachConsole.pname());
        String[] argList = cmdLine.toArray(new String[cmdLine.size()]);
        DuccManagedReservationSubmit mr = new DuccManagedReservationSubmit(argList, this.consoleCb);
        boolean rc = mr.execute();
        String dt = "Managed Reservation";
        if (rc) {
            String line = dt + " " + mr.getDuccId() + " submitted.";
            this.consoleCb.status(line);
            this.returnCode = mr.getReturnCode();
        } else {
            String line = "Could not submit " + dt;
            this.consoleCb.status(line);
        }
        this.mh.frameworkDebug(cid, mid, "rc=" + rc);
        this.mh.frameworkTrace(cid, mid, "exit");
    }

    private void launch() throws Exception {
        String mid = "launch";
        this.mh.frameworkTrace(cid, mid, "enter");
        if (this.allInOneType.equalsIgnoreCase(local)) {
            this.launch_local();
        } else if (this.allInOneType.equalsIgnoreCase(remote)) {
            this.launch_remote();
        } else {
            String message = "type " + this.allInOneType + " not supported";
            this.mh.error(cid, mid, message);
        }
        this.mh.frameworkTrace(cid, mid, "exit");
    }

    @Override
    public boolean execute() throws Exception {
        String mid = "execute";
        this.mh.frameworkTrace(cid, mid, "enter");
        this.examine();
        this.returnCode = -1;
        this.launch();
        this.mh.frameworkTrace(cid, mid, "exit");
        return true;
    }

    @Override
    public int getReturnCode() {
        return this.returnCode;
    }

    public static void main(String[] args) throws Exception {
        AllInOneLauncher allInOneLauncher = new AllInOneLauncher(args);
        allInOneLauncher.execute();
        System.exit(allInOneLauncher.getReturnCode());
    }
}

