/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.util.Map;
import org.apache.uima.ducc.common.IServiceStatistics;
import org.apache.uima.ducc.common.utils.DuccLogger;

public abstract class AServicePing {
    protected int[] failure_window = null;
    protected int failure_cursor = 0;
    protected int total_failures = 0;
    protected int failure_max = 3;
    protected int failure_window_period;
    protected int failure_window_size = this.failure_window_period = 30;
    protected int monitor_rate = 1;
    protected boolean autostart_enabled;
    protected long last_use = 0L;
    protected boolean log_enabled = false;
    protected long service_id = 0L;
    protected Map<String, Object> smState;
    protected Map<String, Object> initializationState;
    protected DuccLogger duccLogger = DuccLogger.getLogger((String)this.getClass().getName(), (String)"PING");

    public abstract void init(String var1, String var2) throws Exception;

    public void init(String arguments, String endpoint, Map<String, Object> initState) throws Exception {
        this.initializationState = initState;
        this.monitor_rate = (Integer)this.initializationState.get("monitor-rate");
        this.service_id = (Long)this.initializationState.get("service-id");
        this.log_enabled = (Boolean)this.initializationState.get("do-log");
        this.failure_max = (Integer)this.initializationState.get("failure-max");
        this.failure_window_period = (Integer)this.initializationState.get("failure-window");
        this.autostart_enabled = (Boolean)this.initializationState.get("autostart-enabled");
        this.last_use = (Long)this.initializationState.get("last-use");
        double calls_per_minute = 60000.0 / (double)this.monitor_rate;
        this.failure_window_size = (int)((double)this.failure_window_period * calls_per_minute);
        this.failure_window = new int[this.failure_window_size];
        this.failure_cursor = 0;
        this.init(arguments, endpoint);
    }

    public abstract void stop();

    public abstract IServiceStatistics getStatistics();

    public void setSmState(Map<String, Object> props) {
        this.smState = props;
    }

    public Map<String, Object> getSmState() {
        return this.smState;
    }

    public int getAdditions() {
        return 0;
    }

    public Long[] getDeletions() {
        return null;
    }

    public boolean isAutostart() {
        if (this.smState == null) {
            return (Boolean)this.initializationState.get("autostart-enabled");
        }
        return (Boolean)this.smState.get("autostart-enabled");
    }

    public long getLastUse() {
        return 0L;
    }

    private String fmtArray(int[] array) {
        Object[] vals = new Object[array.length];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append("%3s ");
            vals[i] = Integer.toString(array[i]);
        }
        return String.format(sb.toString(), vals);
    }

    public void setLogger(DuccLogger logger) {
        this.duccLogger = logger;
    }

    public void doLog(String methodName, Object ... msg) {
        if (!this.log_enabled) {
            return;
        }
        StringBuffer buf = new StringBuffer(methodName);
        buf.append(" ");
        buf.append(Long.toString(this.service_id));
        for (Object o : msg) {
            buf.append(" ");
            if (o == null) {
                buf.append("<null>");
                continue;
            }
            buf.append(o.toString());
        }
        if (this.duccLogger != null) {
            this.duccLogger.info(methodName, null, new Object[]{buf});
        } else {
            System.out.println(buf);
        }
    }

    private void resetFailureWindow() {
        this.total_failures = 0;
        this.failure_cursor = 0;
        for (int i = 0; i < this.failure_window_size; ++i) {
            this.failure_window[i] = 0;
        }
    }

    public boolean isExcessiveFailures() {
        String methodName = "isExcessiveFailures";
        boolean excessive_failures = false;
        int failures = (Integer)this.smState.get("run-failures");
        this.doLog(methodName, "failures:", failures, "total_failures", this.total_failures);
        if (failures > 0) {
            int diff = Math.max(0, failures - this.total_failures);
            if (diff < 0) {
                this.resetFailureWindow();
            } else if (diff > 0) {
                this.total_failures += diff;
                int n = this.failure_cursor++;
                this.failure_window[n] = this.failure_window[n] + diff;
            } else {
                this.failure_window[this.failure_cursor++] = 0;
            }
            this.failure_cursor %= this.failure_window_size;
            this.doLog(methodName, "failures", failures, "total_failures", this.total_failures, "failure_window", this.fmtArray(this.failure_window), "failure_cursor", this.failure_cursor);
            int windowed_failures = 0;
            excessive_failures = false;
            for (int i = 0; i < this.failure_window_size; ++i) {
                windowed_failures += this.failure_window[i];
            }
            if (windowed_failures >= this.failure_max) {
                excessive_failures = true;
            }
            this.doLog(methodName, "windowed_failures", windowed_failures, "excessive_failures", excessive_failures);
        } else if (this.total_failures > 0) {
            this.resetFailureWindow();
        }
        return excessive_failures;
    }
}

