/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli;

import java.util.ArrayList;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.uima.ducc.cli.DuccJobCancel;
import org.apache.uima.ducc.cli.DuccMonitor;
import org.apache.uima.ducc.cli.IDuccCallback;
import org.apache.uima.ducc.cli.IDuccMonitor;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.transport.event.IDuccContext;

public class DuccJobMonitor
extends DuccMonitor
implements IDuccMonitor {
    public static String servlet = "/ducc-servlet/proxy-job-status";

    public DuccJobMonitor() {
        super(IDuccContext.DuccContext.Job, true);
    }

    public DuccJobMonitor(IDuccCallback messageProcessor) {
        super(IDuccContext.DuccContext.Job, true, messageProcessor);
    }

    private DuccJobMonitor(String uniqueSignature) {
        super(IDuccContext.DuccContext.Job, false);
    }

    public static void main(String[] args) {
        int code = 1;
        try {
            String unique = null;
            DuccJobMonitor jobMonitor = new DuccJobMonitor(unique);
            code = jobMonitor.run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(code);
    }

    @Override
    public void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(120);
        formatter.printHelp(DuccJobMonitor.class.getName(), options);
    }

    @Override
    public void cancel() {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("--" + IUiOptions.UiOption.JobId.pname());
            arrayList.add(this.getId());
            arrayList.add("--" + IUiOptions.UiOption.Reason.pname());
            arrayList.add("\"submitter was terminated via interrupt\"");
            String[] argList = arrayList.toArray(new String[0]);
            DuccJobCancel jobCancel = new DuccJobCancel(argList);
            boolean retVal = jobCancel.execute();
            this.debug("cancel rc:" + retVal);
        }
        catch (Exception e) {
            this.messageProcessor.status(e.toString());
        }
    }

    @Override
    public String getUrl(String id) {
        String urlString = "http://" + this.getHost() + ":" + this.getPort() + servlet + "?id=" + id;
        this.debug(urlString);
        return urlString;
    }
}

