/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.event;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.Body;
import org.apache.uima.ducc.agent.NodeAgent;
import org.apache.uima.ducc.agent.ProcessLifecycleController;
import org.apache.uima.ducc.agent.deploy.DuccWorkHelper;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.agent.ProcessStateUpdate;
import org.apache.uima.ducc.transport.cmdline.ICommandLine;
import org.apache.uima.ducc.transport.dispatcher.DuccEventDispatcher;
import org.apache.uima.ducc.transport.event.DuccJobsStateEvent;
import org.apache.uima.ducc.transport.event.ProcessPurgeDuccEvent;
import org.apache.uima.ducc.transport.event.ProcessStartDuccEvent;
import org.apache.uima.ducc.transport.event.ProcessStateUpdateDuccEvent;
import org.apache.uima.ducc.transport.event.ProcessStopDuccEvent;
import org.apache.uima.ducc.transport.event.common.DuccWorkPopDriver;
import org.apache.uima.ducc.transport.event.common.IDuccJobDeployment;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessType;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkExecutable;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.transport.event.delegate.DuccEventDelegateListener;
import org.springframework.beans.factory.annotation.Qualifier;

@Qualifier(value="ael")
public class AgentEventListener
implements DuccEventDelegateListener {
    DuccLogger logger = DuccLogger.getLogger(this.getClass(), (String)"Agent");
    ProcessLifecycleController lifecycleController = null;
    private boolean cleanupPhase = true;
    private AtomicLong lastSequence = new AtomicLong();
    private volatile boolean forceInventoryUpdateDueToSequence = false;
    private NodeAgent agent;
    private static DuccWorkHelper dwHelper = null;

    public AgentEventListener(NodeAgent agent, ProcessLifecycleController lifecycleController) {
        this.agent = agent;
        this.lifecycleController = lifecycleController;
        dwHelper = new DuccWorkHelper();
    }

    public AgentEventListener(NodeAgent agent) {
        this(agent, null);
    }

    public void setDuccEventDispatcher(DuccEventDispatcher eventDispatcher) {
    }

    private void reportIncomingStateForThisNode(DuccJobsStateEvent duccEvent) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (IDuccJobDeployment jobDeployment : duccEvent.getJobList()) {
            if (this.isTargetNodeForProcess(jobDeployment.getJdProcess())) {
                IDuccProcess process = jobDeployment.getJdProcess();
                sb.append("\nJD--> JobId:" + jobDeployment.getJobId() + " ProcessId:" + process.getDuccId() + " PID:" + process.getPID() + " Status:" + process.getProcessState() + " Resource State:" + process.getResourceState() + " isDeallocated:" + process.isDeallocated());
            }
            for (IDuccProcess process : jobDeployment.getJpProcessList()) {
                if (!this.isTargetNodeForProcess(process)) continue;
                sb.append("\n\tJob ID:" + jobDeployment.getJobId() + " ProcessId:" + process.getDuccId() + " PID:" + process.getPID() + " Status:" + process.getProcessState() + " Resource State:" + process.getResourceState() + " isDeallocated:" + process.isDeallocated());
            }
        }
        this.logger.info("reportIncomingStateForThisNode", null, new Object[]{sb.toString()});
    }

    public boolean forceInvotoryUpdate() {
        return this.forceInventoryUpdateDueToSequence;
    }

    public void resetForceInventoryUpdateFlag() {
        this.forceInventoryUpdateDueToSequence = false;
    }

    private void handleJobOrPOPState(IDuccJobDeployment jobDeployment, IDuccWork dw, IDuccProcess process) throws Exception {
        this.logger.info("onDuccJobsStateEvent", jobDeployment.getJobId(), new Object[]{"JP>>>>>>>>>>>> -PID:" + process.getPID()});
        IDuccWorkExecutable dwe = (IDuccWorkExecutable)dw;
        this.agent.reconcileProcessStateAndTakeAction(this.lifecycleController, process, dwe.getCommandLine(), jobDeployment.getStandardInfo(), jobDeployment.getProcessMemoryAssignment(), jobDeployment.getJobId());
    }

    private void handleServiceState(IDuccJobDeployment jobDeployment, IDuccWork dw, IDuccProcess process) throws Exception {
        this.logger.info("onDuccJobsStateEvent", jobDeployment.getJobId(), new Object[]{"SERVICE>>>>>>>>>>>> -PID:" + process.getPID()});
        IDuccWorkJob service = (IDuccWorkJob)dw;
        ICommandLine processCmdLine = service.getCommandLine();
        processCmdLine.addOption("-Dducc.deploy.components=service");
        this.agent.reconcileProcessStateAndTakeAction(this.lifecycleController, process, processCmdLine, jobDeployment.getStandardInfo(), jobDeployment.getProcessMemoryAssignment(), jobDeployment.getJobId());
    }

    private void handleJobDriverState(IDuccJobDeployment jobDeployment, Map<DuccId, IDuccProcess> processes) throws Exception {
        IDuccWork dw = null;
        boolean callReconcile = false;
        ICommandLine cmdLine = null;
        if (!processes.containsKey(jobDeployment.getJdProcess().getDuccId())) {
            dw = dwHelper.fetch(jobDeployment.getJobId());
            if (dw == null) {
                this.logger.info("onDuccJobsStateEvent", jobDeployment.getJobId(), new Object[]{"!!!!! The OR did not provide commndline spec and other details required to launch processes for the Job. Received value of NULL from the OR"});
            } else {
                IDuccWorkJob job = (IDuccWorkJob)dw;
                DuccWorkPopDriver driver = job.getDriver();
                if (driver != null) {
                    callReconcile = true;
                    cmdLine = driver.getCommandLine();
                }
            }
        } else {
            callReconcile = true;
        }
        if (callReconcile) {
            this.agent.reconcileProcessStateAndTakeAction(this.lifecycleController, jobDeployment.getJdProcess(), cmdLine, jobDeployment.getStandardInfo(), jobDeployment.getProcessMemoryAssignment(), jobDeployment.getJobId());
        }
    }

    private void handleAPJobServiceProcesses(IDuccJobDeployment jobDeployment, Map<DuccId, IDuccProcess> processes) throws Exception {
        if (jobDeployment.getJpProcessList() != null) {
            IDuccWork dw = null;
            for (IDuccProcess process : jobDeployment.getJpProcessList()) {
                if (!this.isTargetNodeForProcess(process)) continue;
                if (!processes.containsKey(process.getDuccId())) {
                    dw = dwHelper.fetch(jobDeployment.getJobId());
                    if (dw == null) {
                        this.logger.info("onDuccJobsStateEvent", jobDeployment.getJobId(), new Object[]{"!!!!! The OR did not provide commndline spec and other details required to launch processes for the Job. Received value of NULL from the OR"});
                        continue;
                    }
                    this.logger.debug("onDuccJobsStateEvent", jobDeployment.getJobId(), new Object[]{"........... Job Type:" + jobDeployment.getType().name()});
                    if (IDuccTypes.DuccType.Service.equals((Object)jobDeployment.getType())) {
                        this.handleServiceState(jobDeployment, dw, process);
                        continue;
                    }
                    if (dw instanceof IDuccWorkExecutable) {
                        this.handleJobOrPOPState(jobDeployment, dw, process);
                        continue;
                    }
                    this.logger.error("onDuccJobsStateEvent", jobDeployment.getJobId(), new Object[]{"Unexpected process type -PID:" + process.getPID()});
                    continue;
                }
                this.agent.reconcileProcessStateAndTakeAction(this.lifecycleController, process, null, jobDeployment.getStandardInfo(), jobDeployment.getProcessMemoryAssignment(), jobDeployment.getJobId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDuccJobsStateEvent(@Body DuccJobsStateEvent duccEvent) throws Exception {
        long sequence = duccEvent.getSequence();
        try {
            AgentEventListener agentEventListener = this;
            synchronized (agentEventListener) {
                if (sequence <= this.lastSequence.get()) {
                    this.logger.warn("reportIncomingStateForThisNode", null, new Object[]{"Received Out of Band Message. Expected Sequence Greater Than " + this.lastSequence + " Received " + sequence + " Instead"});
                    this.forceInventoryUpdateDueToSequence = true;
                    return;
                }
                this.lastSequence.set(sequence);
                this.logger.info("reportIncomingStateForThisNode", null, new Object[]{"Received OR Sequence:" + sequence + " Thread ID:" + Thread.currentThread().getId()});
                if (this.lifecycleController == null) {
                    this.lifecycleController = this.agent;
                }
                this.reportIncomingStateForThisNode(duccEvent);
                this.agent.setReservations(duccEvent.getUserReservations());
                this.agent.takeDownProcessWithNoJob(this.agent, duccEvent.getJobList());
                HashMap<DuccId, IDuccProcess> processes = this.agent.getInventoryCopy();
                for (IDuccJobDeployment jobDeployment : duccEvent.getJobList()) {
                    if (jobDeployment.getJdProcess() != null && this.isTargetNodeForProcess(jobDeployment.getJdProcess())) {
                        this.handleJobDriverState(jobDeployment, processes);
                    }
                    this.handleAPJobServiceProcesses(jobDeployment, processes);
                }
            }
            if (!this.agent.receivedDuccState) {
                this.agent.receivedDuccState = true;
            }
        }
        catch (Exception e) {
            this.logger.error("onDuccJobsStateEvent", null, (Throwable)e, new Object[0]);
        }
    }

    private boolean isTargetNodeForProcess(IDuccProcess process) throws Exception {
        boolean retVal = false;
        if (process != null) {
            retVal = Utils.isTargetNodeForMessage((String)process.getNodeIdentity().getIp(), (String)this.agent.getIdentity().getIp());
        }
        return retVal;
    }

    public void onProcessStartEvent(@Body ProcessStartDuccEvent duccEvent) throws Exception {
        for (Map.Entry processEntry : duccEvent.getProcessMap().entrySet()) {
            if (!Utils.isTargetNodeForMessage((String)((IDuccProcess)processEntry.getValue()).getNodeIdentity().getIp(), (String)this.agent.getIdentity().getIp())) continue;
            this.logger.info(">>> onProcessStartEvent", null, new Object[]{"... Agent [" + this.agent.getIdentity().getIp() + "] Matches Target Node Assignment:" + ((IDuccProcess)processEntry.getValue()).getNodeIdentity().getIp() + " For Share Id:" + ((IDuccProcess)processEntry.getValue()).getDuccId()});
            this.agent.doStartProcess((IDuccProcess)processEntry.getValue(), duccEvent.getCommandLine(), duccEvent.getStandardInfo(), duccEvent.getDuccWorkId());
            if (!((IDuccProcess)processEntry.getValue()).getProcessType().equals((Object)IDuccProcessType.ProcessType.Pop)) continue;
            break;
        }
    }

    public void onProcessStopEvent(@Body ProcessStopDuccEvent duccEvent) throws Exception {
        for (Map.Entry processEntry : duccEvent.getProcessMap().entrySet()) {
            if (!Utils.isTargetNodeForMessage((String)((IDuccProcess)processEntry.getValue()).getNodeIdentity().getIp(), (String)this.agent.getIdentity().getIp())) continue;
            this.logger.info(">>> onProcessStopEvent", null, new Object[]{"... Agent Received StopProces Event - Process Ducc Id:" + ((IDuccProcess)processEntry.getValue()).getDuccId() + " PID:" + ((IDuccProcess)processEntry.getValue()).getPID()});
            this.agent.doStopProcess((IDuccProcess)processEntry.getValue());
        }
    }

    public void onProcessStateUpdate(@Body ProcessStateUpdateDuccEvent duccEvent) throws Exception {
        this.logger.info(">>> onProcessStateUpdate", null, new Object[]{"... Agent Received ProcessStateUpdateDuccEvent - Process State:" + duccEvent.getState() + " Process ID:" + duccEvent.getDuccProcessId()});
        this.agent.updateProcessStatus(duccEvent);
    }

    public void onProcessStateUpdate(@Body String serviceUpdate) throws Exception {
        this.logger.info(">>> onProcessStateUpdate", null, new Object[]{"Recv'd Process Update from Custom Service"});
        String[] stateUpdateProperties = serviceUpdate.split(",");
        String duccProcessId = null;
        String duccProcessState = null;
        IProcessState.ProcessState state = null;
        for (String prop : stateUpdateProperties) {
            String[] nv = prop.split("=");
            if (nv[0].equals("DUCC_PROCESS_UNIQUEID")) {
                duccProcessId = nv[1];
                continue;
            }
            if (!nv[0].equals("DUCC_PROCESS_STATE")) continue;
            duccProcessState = nv[1];
            try {
                state = IProcessState.ProcessState.valueOf((String)nv[1]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (state == null) {
            this.logger.info(">>> onProcessStateUpdate", null, new Object[]{"... Agent Received Invalid State Update event - Unsupported Process State:" + duccProcessState + " Process ID:" + duccProcessId});
        } else if (duccProcessId == null) {
            this.logger.info(">>> onProcessStateUpdate", null, new Object[]{"... Agent Received Invalid State Update event - Process State:" + duccProcessState + " Missing Process ID"});
        } else {
            ProcessStateUpdate update = new ProcessStateUpdate(state, duccProcessId);
            ProcessStateUpdateDuccEvent duccEvent = new ProcessStateUpdateDuccEvent(update);
            this.logger.info(">>> onProcessStateUpdate", null, new Object[]{"... Agent Received ProcessStateUpdateDuccEvent - Process State:" + duccEvent.getState() + " Process ID:" + duccEvent.getDuccProcessId()});
            this.agent.updateProcessStatus(duccEvent);
        }
    }

    public void onProcessPurgeEvent(@Body ProcessPurgeDuccEvent duccEvent) throws Exception {
        this.logger.info(">>> onProcessPurgeEvent", null, new Object[]{"... Agent Received ProcessPurgeDuccEvent - Process ID:" + duccEvent.getProcess().getPID()});
        this.agent.purgeProcess(duccEvent.getProcess());
    }

    public long getLastSequence() {
        return this.lastSequence.get();
    }
}

