/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.processors;

import java.io.FileNotFoundException;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.camel.Exchange;
import org.apache.uima.ducc.agent.NodeAgent;
import org.apache.uima.ducc.agent.launcher.ManagedProcess;
import org.apache.uima.ducc.agent.metrics.collectors.DuccGarbageStatsCollector;
import org.apache.uima.ducc.agent.metrics.collectors.ProcessCpuUsageCollector;
import org.apache.uima.ducc.agent.metrics.collectors.ProcessMajorFaultCollector;
import org.apache.uima.ducc.agent.metrics.collectors.ProcessResidentMemoryCollector;
import org.apache.uima.ducc.agent.metrics.collectors.ProcessSwapUsageCollector;
import org.apache.uima.ducc.agent.processors.BaseProcessor;
import org.apache.uima.ducc.agent.processors.ProcessMetricsProcessor;
import org.apache.uima.ducc.common.agent.metrics.cpu.ProcessCpuUsage;
import org.apache.uima.ducc.common.agent.metrics.memory.ProcessResidentMemory;
import org.apache.uima.ducc.common.agent.metrics.swap.ProcessMemoryPageLoadUsage;
import org.apache.uima.ducc.common.agent.metrics.swap.ProcessSwapSpaceUsage;
import org.apache.uima.ducc.common.node.metrics.ProcessGarbageCollectionStats;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessType;
import org.apache.uima.ducc.transport.event.common.IProcessState;

public class LinuxProcessMetricsProcessor
extends BaseProcessor
implements ProcessMetricsProcessor {
    private long previousCPUReadingInMillis = 0L;
    private long previousSnapshotTime = 0L;
    private final ExecutorService pool;
    private IDuccProcess process;
    private DuccGarbageStatsCollector gcStatsCollector;
    private int blockSize = 4096;
    private DuccLogger logger;
    private ManagedProcess managedProcess;
    private NodeAgent agent;
    private int fudgeFactor = 5;
    private volatile boolean closed = true;
    private long percentCPU = 0L;

    public LinuxProcessMetricsProcessor(DuccLogger logger, IDuccProcess process, NodeAgent agent, ManagedProcess managedProcess) throws FileNotFoundException {
        this.logger = logger;
        this.managedProcess = managedProcess;
        this.agent = agent;
        this.pool = Executors.newCachedThreadPool();
        this.process = process;
        this.gcStatsCollector = new DuccGarbageStatsCollector(logger, process);
        managedProcess.setMetricsProcessor(this);
        this.blockSize = agent.getOSPageSize();
        if (System.getProperty("ducc.agent.share.size.fudge.factor") != null) {
            try {
                this.fudgeFactor = Integer.parseInt(System.getProperty("ducc.agent.share.size.fudge.factor"));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        this.closed = false;
    }

    @Override
    public void stop() {
        try {
            if (this.pool != null) {
                this.pool.shutdown();
            }
        }
        catch (Exception e) {
            this.logger.error("LinuxProcessMetricsProcessor.stop()", null, (Throwable)e, new Object[0]);
        }
    }

    public void close() {
        this.closed = true;
        try {
            this.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean collectStats(IProcessState.ProcessState state) {
        return !this.process.getProcessState().equals((Object)IProcessState.ProcessState.Stopped) && !this.process.getProcessState().equals((Object)IProcessState.ProcessState.Killed) && !this.process.getProcessState().equals((Object)IProcessState.ProcessState.Failed) && !this.process.getProcessState().equals((Object)IProcessState.ProcessState.Stopping);
    }

    private long getSwapUsage() throws Exception {
        long swapUsage = -1L;
        if (this.agent.useCgroups) {
            String containerId = this.agent.cgroupsManager.getContainerId(this.managedProcess);
            ProcessSwapUsageCollector processSwapCollector = new ProcessSwapUsageCollector(this.logger, this.agent.cgroupsManager, containerId);
            this.logger.info("LinuxProcessMetricsProcessor.getSwapUsage", null, new Object[]{"Fetching Swap Usage PID:" + this.process.getPID()});
            Future<ProcessSwapSpaceUsage> processFaults = this.pool.submit(processSwapCollector);
            swapUsage = processFaults.get().getSwapUsage();
            this.logger.info("LinuxProcessMetricsProcessor.getSwapUsage", null, new Object[]{" Process Swap Usage:" + swapUsage});
        }
        return swapUsage;
    }

    private long getFaults() throws Exception {
        long faults = -1L;
        if (this.agent.useCgroups) {
            String containerId = this.agent.cgroupsManager.getContainerId(this.managedProcess);
            ProcessMajorFaultCollector processFaultsCollector = new ProcessMajorFaultCollector(this.logger, this.agent.cgroupsManager, containerId);
            this.logger.info("LinuxProcessMetricsProcessor.getFaults", null, new Object[]{"Fetching Page Faults PID:" + this.process.getPID()});
            Future<ProcessMemoryPageLoadUsage> processFaults = this.pool.submit(processFaultsCollector);
            faults = processFaults.get().getMajorFaults();
            this.logger.info("LinuxProcessMetricsProcessor.getFaults", null, new Object[]{" Process Faults (pgpgin):" + faults});
        }
        return faults;
    }

    private long getRss() throws Exception {
        long rss = -1L;
        if (this.agent.useCgroups) {
            String containerId = this.agent.cgroupsManager.getContainerId(this.managedProcess);
            ProcessResidentMemoryCollector processRSSCollector = new ProcessResidentMemoryCollector(this.logger, this.agent.cgroupsManager, containerId);
            this.logger.info("LinuxProcessMetricsProcessor.getRss", null, new Object[]{"Fetching RSS Usage for PID:" + this.process.getPID()});
            Future<ProcessResidentMemory> processRss = this.pool.submit(processRSSCollector);
            rss = processRss.get().get();
            this.logger.info("LinuxProcessMetricsProcessor.getRss", null, new Object[]{" Process RSS:" + rss});
        }
        return rss;
    }

    private long getCpuUsage() throws Exception {
        long cpuUsage = -1L;
        if (this.agent.useCgroups) {
            String containerId = this.agent.cgroupsManager.getContainerId(this.managedProcess);
            Future<ProcessCpuUsage> processCpuUsage = null;
            ProcessCpuUsageCollector processCpuUsageCollector = new ProcessCpuUsageCollector(this.logger, this.agent.cgroupsManager, containerId);
            this.logger.info("LinuxProcessMetricsProcessor.getCpuUsage", null, new Object[]{"Fetching CPU Usage for PID:" + this.process.getPID()});
            processCpuUsage = this.pool.submit(processCpuUsageCollector);
            long cpuUsageInNanos = processCpuUsage.get().getCpuUsage();
            if (cpuUsageInNanos >= 0L) {
                cpuUsage = Math.round(cpuUsageInNanos / 1000000L);
            }
            this.logger.info("LinuxProcessMetricsProcessor.getCpuUsage", null, new Object[]{"CPU USAGE:" + cpuUsageInNanos + " CLOCK RATE:" + this.agent.cpuClockRate + " Total CPU USAGE:" + cpuUsage});
        }
        return cpuUsage;
    }

    private long getCpuTime(long totalCpuUsageInMillis) throws Exception {
        long cp = -1L;
        if (this.managedProcess.getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Running) || this.managedProcess.getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Initializing)) {
            if (this.agent.useCgroups && totalCpuUsageInMillis != -1L) {
                long timeRunning = 1L;
                if (this.process.getTimeWindowInit() != null) {
                    timeRunning = this.process.getTimeWindowInit().getElapsedMillis();
                }
                if (this.process.getTimeWindowRun() != null) {
                    timeRunning += this.process.getTimeWindowRun().getElapsedMillis();
                }
                cp = this.percentCPU = Math.round(100.0 * ((double)totalCpuUsageInMillis * 1.0 / ((double)timeRunning * 1.0)));
            }
        } else {
            cp = this.percentCPU;
        }
        return cp;
    }

    private long getCurrentCpu(long totalCpuUsageInMillis) {
        long currentCpu = -1L;
        if (totalCpuUsageInMillis > 0L) {
            double millisCPU = (double)(totalCpuUsageInMillis - this.previousCPUReadingInMillis) * 1.0;
            double millisRun = (double)(System.currentTimeMillis() - this.previousSnapshotTime) * 1.0;
            currentCpu = Math.round(100.0 * (millisCPU / millisRun));
            this.previousCPUReadingInMillis = totalCpuUsageInMillis;
            this.previousSnapshotTime = System.currentTimeMillis();
        } else if (this.agent.useCgroups && totalCpuUsageInMillis != -1L) {
            currentCpu = 0L;
        }
        return currentCpu;
    }

    private void killProcsIfExceedingMemoryThreshold() throws Exception {
        if (!this.agent.useCgroups) {
            return;
        }
        if (this.process.getSwapUsage() <= 0L || this.process.getSwapUsage() <= this.managedProcess.getMaxSwapThreshold()) {
            String containerId = this.agent.cgroupsManager.getContainerId(this.managedProcess);
            String[] cgroupPids = this.agent.cgroupsManager.getPidsInCgroup(containerId);
            this.logger.info("LinuxProcessMetricsProcessor.process", null, new Object[]{"Container ID:" + containerId + " cgroup pids " + cgroupPids.length});
            if (this.fudgeFactor > -1 && this.managedProcess.getProcessMemoryAssignment().getMaxMemoryWithFudge() > 0L) {
                long rss = this.process.getResidentMemory() / 1024L / 1024L;
                this.logger.trace("process", null, new Object[]{"*** Process with PID:" + this.managedProcess.getPid() + " Assigned Memory (MB): " + this.managedProcess.getProcessMemoryAssignment() + " MBs. Current RSS (MB):" + rss});
                if (rss > this.managedProcess.getProcessMemoryAssignment().getMaxMemoryWithFudge()) {
                    this.logger.error("process", null, new Object[]{"\n\n********************************************************\n\tProcess with PID:" + this.managedProcess.getPid() + " Exceeded its max memory assignment (including a fudge factor) of " + this.managedProcess.getProcessMemoryAssignment().getMaxMemoryWithFudge() + " MBs. This Process Resident Memory Size: " + rss + " MBs .Killing process ...\n********************************************************\n\n"});
                    try {
                        this.managedProcess.kill();
                        this.process.setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.ExceededShareSize.toString());
                        this.agent.stopProcess(this.process);
                        if (this.agent.useCgroups) {
                            for (String pid : cgroupPids) {
                                if (pid.equals(this.managedProcess.getDuccProcess().getPID())) continue;
                                this.killChildProcess(pid, "-15");
                            }
                        }
                    }
                    catch (Exception ee) {
                        if (!this.collectStats(this.process.getProcessState())) {
                            return;
                        }
                        this.logger.error("process", null, (Throwable)ee, new Object[0]);
                    }
                    return;
                }
            }
        }
    }

    private ProcessGarbageCollectionStats getGCStats() throws Exception {
        if (!this.process.getProcessType().equals((Object)IDuccProcessType.ProcessType.Pop)) {
            this.logger.info("LinuxProcessMetricsProcessor.getGCStats", null, new Object[]{"Collecting GC Stats"});
            ProcessGarbageCollectionStats gcStats = this.gcStatsCollector.collect();
            return gcStats;
        }
        return new ProcessGarbageCollectionStats();
    }

    public boolean processIsActive() {
        return this.process.getProcessState().equals((Object)IProcessState.ProcessState.Starting) || this.process.getProcessState().equals((Object)IProcessState.ProcessState.Started) || this.process.getProcessState().equals((Object)IProcessState.ProcessState.Initializing) || this.process.getProcessState().equals((Object)IProcessState.ProcessState.Running);
    }

    public void process(Exchange e) {
        if (this.closed || !this.processIsActive()) {
            this.logger.info("LinuxProcessMetricsProcessor.process", null, new Object[]{"Process with PID:" + this.process.getPID() + " not in Running or Initializing state. Returning"});
            return;
        }
        try {
            this.process.setSwapUsage(this.getSwapUsage());
            this.process.setMajorFaults(this.getFaults());
            long rssInBytes = this.getRss();
            this.process.setResidentMemory(rssInBytes);
            long totalCpuUsageInMillis = this.getCpuUsage();
            this.process.setCpuTime(this.getCpuTime(totalCpuUsageInMillis));
            this.process.setCurrentCPU(this.getCurrentCpu(totalCpuUsageInMillis));
            ProcessGarbageCollectionStats gcStats = this.getGCStats();
            this.process.setGarbageCollectionStats(gcStats);
            this.logger.info("process", null, new Object[]{"----------- PID:" + this.process.getPID() + " RSS:" + (rssInBytes > -1L ? rssInBytes / 0x100000L + " MB" : "-1") + " Total CPU Time (%):" + this.process.getCpuTime() + " Delta CPU Time (%):" + this.process.getCurrentCPU() + " Major Faults:" + this.process.getMajorFaults() + " Process Swap Usage:" + this.process.getSwapUsage() + " Max Swap Usage Allowed:" + this.managedProcess.getMaxSwapThreshold() + " Total GC Collection Count :" + gcStats.getCollectionCount() + " Total GC Collection Time :" + gcStats.getCollectionTime()});
            this.killProcsIfExceedingMemoryThreshold();
        }
        catch (Exception exc) {
            if (!this.collectStats(this.process.getProcessState())) {
                return;
            }
            this.logger.error("LinuxProcessMetricsProcessor.process", null, (Throwable)exc, new Object[0]);
        }
    }

    private void killChildProcess(String pid, final String signal) {
        new Thread(){

            @Override
            public void run() {
                String c_launcher_path = Utils.resolvePlaceholderIfExists((String)System.getProperty("ducc.agent.launcher.ducc_spawn_path"), (Properties)System.getProperties());
                try {
                    String[] killCmd = null;
                    String useSpawn = System.getProperty("ducc.agent.launcher.use.ducc_spawn");
                    killCmd = useSpawn != null && useSpawn.toLowerCase().equals("true") ? new String[]{c_launcher_path, "-u", LinuxProcessMetricsProcessor.this.managedProcess.getOwner(), "--", "/bin/kill", signal, LinuxProcessMetricsProcessor.this.managedProcess.getDuccProcess().getPID()} : new String[]{"/bin/kill", "-15", LinuxProcessMetricsProcessor.this.managedProcess.getDuccProcess().getPID()};
                    ProcessBuilder pb = new ProcessBuilder(killCmd);
                    Process p = pb.start();
                    p.wait(60000L);
                    p.destroy();
                }
                catch (Exception e) {
                    LinuxProcessMetricsProcessor.this.logger.error("killChildProcess", LinuxProcessMetricsProcessor.this.managedProcess.getWorkDuccId(), (Throwable)e, new Object[0]);
                }
            }
        }.start();
    }
}

