/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.launcher;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.apache.uima.ducc.agent.event.ProcessLifecycleObserver;
import org.apache.uima.ducc.agent.launcher.ManagedServiceInfo;
import org.apache.uima.ducc.agent.launcher.Process;
import org.apache.uima.ducc.agent.launcher.ProcessStreamConsumer;
import org.apache.uima.ducc.agent.processors.LinuxProcessMetricsProcessor;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.cmdline.ICommandLine;
import org.apache.uima.ducc.transport.event.common.DuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessType;
import org.apache.uima.ducc.transport.event.common.IDuccStandardInfo;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.transport.event.common.ProcessMemoryAssignment;

public class ManagedProcess
implements Process {
    private static final long serialVersionUID = 1L;
    private ManagedServiceInfo.ServiceState state = ManagedServiceInfo.ServiceState.STARTING;
    StopPriority stopPriority = StopPriority.NONE;
    private volatile boolean destroyed = false;
    private IDuccProcess duccProcess;
    private volatile boolean killAfterLaunch = false;
    private String processCorrelationId;
    private String port = null;
    private String socketEndpoint = null;
    private int tgCounter = 1;
    private String logPath;
    private String absoluteLogPath;
    private String agentLogPath;
    private boolean agentProcess = false;
    private String nodeIp;
    private String nodeName;
    private String description;
    private String parent;
    private ProcessType processType;
    private volatile boolean attached;
    private String clientId;
    private Throwable exceptionStackTrace;
    private transient List<String> command;
    private transient java.lang.Process process;
    protected transient ProcessStreamConsumer stdOutReader;
    protected transient ProcessStreamConsumer stdErrReader;
    private transient CountDownLatch pidReadyCount = new CountDownLatch(1);
    private ICommandLine commandLine;
    private transient ProcessLifecycleObserver observer;
    private transient Timer initTimer;
    private transient Timer cleanupTimer;
    private DuccId workDuccId;
    private IDuccStandardInfo processInfo;
    private transient Future<?> future;
    private volatile transient boolean isstopping;
    private volatile transient boolean forceKill;
    private transient DuccLogger logger;
    private long maxSwapThreshold;
    private ProcessMemoryAssignment processMemoryAssignment;
    private transient LinuxProcessMetricsProcessor metricsProcessor;
    private volatile boolean isJD;
    private long initializationTimeout;

    public ManagedProcess(IDuccProcess process, ICommandLine commandLine) {
        this(process, commandLine, null, null, new ProcessMemoryAssignment());
    }

    public ManagedProcess(IDuccProcess process, ICommandLine commandLine, boolean agentProcess) {
        this(process, commandLine, null, null, new ProcessMemoryAssignment());
        this.agentProcess = agentProcess;
    }

    public ManagedProcess(IDuccProcess process, ICommandLine commandLine, ProcessLifecycleObserver observer, DuccLogger logger, ProcessMemoryAssignment processMemoryAssignment) {
        this.commandLine = commandLine;
        this.duccProcess = process;
        this.observer = observer;
        this.logger = logger;
        this.processMemoryAssignment = processMemoryAssignment;
    }

    public void setMetricsProcessor(LinuxProcessMetricsProcessor processor) {
        this.metricsProcessor = processor;
    }

    public void setStopPriority(StopPriority sp) {
        this.stopPriority = sp;
    }

    public StopPriority getStopPriority() {
        return this.stopPriority;
    }

    public LinuxProcessMetricsProcessor getMetricsProcessor() {
        return this.metricsProcessor;
    }

    public ManagedProcess(java.lang.Process process, boolean agentProcess, String correlationId) {
        this.process = process;
        this.agentProcess = agentProcess;
    }

    public ManagedProcess(java.lang.Process process, boolean agentProcess) {
        this(process, agentProcess, null);
    }

    public boolean doKill() {
        return this.forceKill;
    }

    public void kill() {
        this.forceKill = true;
    }

    public void setStopping() {
        this.isstopping = true;
    }

    public boolean isStopping() {
        return this.isstopping;
    }

    public void setWorkDuccId(DuccId workDuccId) {
        this.workDuccId = workDuccId;
    }

    public DuccId getWorkDuccId() {
        return this.workDuccId;
    }

    public DuccId getDuccId() {
        return this.duccProcess.getDuccId();
    }

    @Override
    public void setParent(String parent) {
        this.parent = parent;
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    @Override
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public boolean isAttached() {
        return this.attached;
    }

    @Override
    public void setAttached() {
        this.attached = true;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public String getNodeIp() {
        return this.nodeIp;
    }

    @Override
    public void setNodeIp(String nodeIp) {
        this.nodeIp = nodeIp;
    }

    public Process getInstance() {
        return this;
    }

    public ProcessType getProcessType() {
        return this.processType;
    }

    public void setProcessType(ProcessType processType) {
        this.processType = processType;
    }

    @Override
    public void setLogStream(OutputStream os) {
    }

    @Override
    public boolean isAgentProcess() {
        return this.agentProcess;
    }

    @Override
    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    @Override
    public String getLogPath() {
        return this.logPath;
    }

    @Override
    public void setAgentLogPath(String logPath) {
        this.agentLogPath = logPath;
    }

    @Override
    public String getAgentLogPath() {
        return this.agentLogPath;
    }

    public String getOwner() {
        if (this.processInfo != null) {
            return this.processInfo.getUser();
        }
        return null;
    }

    public void setOSProcess(java.lang.Process process) {
        this.process = process;
    }

    private void log(String method, String message) {
        if (this.logger != null) {
            this.logger.info(method, null, new Object[]{message});
        }
    }

    public void drainProcessStreams(java.lang.Process process, DuccLogger logger, PrintStream pStream, boolean isKillCmd) {
        boolean initError;
        ThreadGroup group = new ThreadGroup("AgentDeployer" + this.tgCounter++);
        InputStream stdin = process.getInputStream();
        InputStream stderr = process.getErrorStream();
        this.stdOutReader = new ProcessStreamConsumer(logger, group, "StdOutputReader", stdin, pStream, this.workDuccId);
        this.stdErrReader = new ProcessStreamConsumer(logger, group, "StdErrorReader", stderr, pStream, this.workDuccId);
        this.stdOutReader.start();
        this.stdErrReader.start();
        boolean finished = false;
        int exitcode = 0;
        while (!finished) {
            try {
                process.waitFor();
                if (this.getMetricsProcessor() != null) {
                    this.getMetricsProcessor().close();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                exitcode = process.exitValue();
                finished = true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
        }
        boolean isAP = this.isJd() && this.getDuccProcess().getProcessType().equals((Object)IDuccProcessType.ProcessType.Pop);
        try {
            this.stdOutReader.join(2000L);
            this.stdErrReader.join(2000L);
        }
        catch (InterruptedException ie) {
            this.log("ManagedProcess.drainProcessStreams", "Interrupted While Awaiting Termination of StdOutReader and StdErrReader Threads");
        }
        String reason = this.getDuccProcess().getReasonForStoppingProcess();
        IProcessState.ProcessState pstate = this.getDuccProcess().getProcessState();
        boolean bl = initError = reason != null && (reason.equals(IDuccProcess.ReasonForStoppingProcess.FailedInitialization.toString()) || reason.equals(IDuccProcess.ReasonForStoppingProcess.InitializationTimeout.toString()));
        if (isKillCmd || reason != null && initError) {
            if (!(initError || exitcode - 128 != 9 && exitcode - 128 != 15)) {
                this.getDuccProcess().setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.KilledByDucc.toString());
            }
        } else {
            this.log("ManagedProcess.drainProcessStreams", "Ducc Process with PID:" + this.getPid() + " Terminated while in " + pstate + " State");
            if (this.doKill()) {
                if (isAP) {
                    pstate = IProcessState.ProcessState.Stopped;
                    if (exitcode - 128 == 9 || exitcode - 128 == 15) {
                        this.getDuccProcess().setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.KilledByDucc.toString());
                    }
                } else {
                    pstate = IProcessState.ProcessState.Killed;
                }
            } else {
                if (!isAP && !this.isstopping && (IProcessState.ProcessState.Initializing.equals((Object)pstate) || IProcessState.ProcessState.Starting.equals((Object)pstate))) {
                    this.getDuccProcess().setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.FailedInitialization.toString());
                    this.log("ManagedProcess.drainProcessStreams", "Process Failed while in initializing state - setting reason to " + this.getDuccProcess().getReasonForStoppingProcess());
                }
                pstate = IProcessState.ProcessState.Stopped;
                if (!this.isstopping) {
                    String errors = this.stdErrReader.getDataFromStream();
                    if (errors != null && errors.trim().length() > 0) {
                        this.getDuccProcess().setExtendedReasonForStoppingProcess(errors.trim());
                        this.log("ManagedProcess.drainProcessStreams", "Process Failed - stderr stream:" + this.getDuccProcess().getReasonForStoppingProcess());
                    }
                    if (!isAP) {
                        pstate = IProcessState.ProcessState.Failed;
                        if (errors != null && errors.trim().length() > 0) {
                            if (this.getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Stopping)) {
                                this.getDuccProcess().setProcessState(IProcessState.ProcessState.Stopped);
                            } else {
                                this.getDuccProcess().setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.Croaked.toString());
                            }
                        } else if (exitcode - 128 == 9 || exitcode - 128 == 15) {
                            this.getDuccProcess().setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.Croaked.toString());
                        }
                    }
                } else if (exitcode - 128 == 9 || exitcode - 128 == 15) {
                    this.addReasonForStopping(this.getDuccProcess(), IDuccProcess.ReasonForStoppingProcess.KilledByDucc.toString());
                } else {
                    this.addReasonForStopping(this.getDuccProcess(), IDuccProcess.ReasonForStoppingProcess.Deallocated.toString());
                }
                this.notifyProcessObserver(pstate);
                this.log("ManagedProcess.drainProcessStreams", "************ Remote Process PID:" + this.getPid() + " Terminated ***************");
            }
        }
    }

    private void addReasonForStopping(IDuccProcess process, String reason) {
        if (this.getDuccProcess().getReasonForStoppingProcess() == null || this.getDuccProcess().getReasonForStoppingProcess().trim().length() == 0) {
            this.getDuccProcess().setReasonForStoppingProcess(reason);
        }
    }

    public ManagedServiceInfo.ServiceState getStatus() {
        return this.state;
    }

    @Override
    public String getPid() {
        return this.duccProcess.getPID();
    }

    @Override
    public void setPid(String pid) {
        this.duccProcess.setPID(pid);
        this.pidReadyCount.countDown();
    }

    public void awaitPid() {
        try {
            this.pidReadyCount.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void releasePidLatch() {
        this.pidReadyCount.countDown();
    }

    @Override
    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(List<String> commandToRun) {
        this.command = commandToRun;
    }

    @Override
    public String getProcessId() {
        return this.processCorrelationId;
    }

    @Override
    public void setProcessId(String processId) {
        this.processCorrelationId = processId;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public void setPort(String port) {
        this.port = port;
    }

    public void terminateRemoteProcess() throws Exception {
        System.out.println("Stopping Remote Managed Process via JMX");
    }

    public void failed() {
        this.cleanup();
    }

    private void cleanup() {
        if (this.process != null) {
            this.process.destroy();
        }
        this.destroyed = true;
    }

    public void stop() {
        this.cleanup();
    }

    public void waitFor() throws InterruptedException {
        this.process.waitFor();
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public String getAbsoluteLogPath() {
        return this.absoluteLogPath;
    }

    @Override
    public void setAbsoluteLogPath(String absoluteLogPath) {
        this.absoluteLogPath = absoluteLogPath;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Throwable getExceptionStackTrace() {
        return this.exceptionStackTrace;
    }

    @Override
    public void setExceptionStackTrace(Throwable exceptionStackTrace) {
        this.exceptionStackTrace = exceptionStackTrace;
    }

    public ICommandLine getCommandLine() {
        return this.commandLine;
    }

    public IDuccProcess getDuccProcess() {
        return this.duccProcess;
    }

    public void notifyProcessObserver(IProcessState.ProcessState state) {
        if (this.observer != null && this.getDuccProcess() != null) {
            if (IProcessState.ProcessState.InitializationTimeout.equals((Object)state)) {
                this.observer.onJPInitTimeout(this.getDuccProcess(), this.initializationTimeout);
            } else {
                this.getDuccProcess().setProcessState(state);
                this.observer.onProcessExit(this.getDuccProcess());
            }
        }
    }

    public void startInitializationTimer(long timeout) {
        this.initTimer = new Timer();
        try {
            if (timeout == 0L) {
                String str_timeout = System.getProperty("ducc.default.process.init.time.max");
                timeout = str_timeout != null ? Long.parseLong(str_timeout) * 60L * 1000L : 14400000L;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.initTimer.schedule((TimerTask)new InitializationTask(), timeout);
        this.initializationTimeout = timeout;
    }

    public void stopInitializationTimer() {
        if (this.initTimer != null) {
            this.initTimer.cancel();
            long timeout = 60000L;
            if (this.getDuccProcess().getUimaPipelineComponents() != null && this.getDuccProcess().getUimaPipelineComponents().size() > 0) {
                this.cleanupTimer = new Timer();
                try {
                    String inv_publish_rate = System.getProperty("ducc.agent.node.inventory.publish.rate");
                    if (inv_publish_rate != null) {
                        timeout = Long.parseLong(inv_publish_rate) * 4L;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.cleanupTimer.schedule((TimerTask)new CleanupTask(), timeout);
            }
        }
    }

    public IDuccStandardInfo getProcessInfo() {
        return this.processInfo;
    }

    public void setProcessInfo(IDuccStandardInfo processInfo) {
        this.processInfo = processInfo;
    }

    public boolean killAfterLaunch() {
        return this.killAfterLaunch;
    }

    public void killAfterLaunch(boolean killAfterLaunch) {
        this.killAfterLaunch = killAfterLaunch;
    }

    public Future<?> getFuture() {
        return this.future;
    }

    public void setFuture(Future<?> future) {
        this.future = future;
    }

    public ProcessMemoryAssignment getProcessMemoryAssignment() {
        return this.processMemoryAssignment;
    }

    public String getSocketEndpoint() {
        return this.socketEndpoint;
    }

    public void setSocketEndpoint(String socketEndpoint) {
        this.socketEndpoint = socketEndpoint;
    }

    public long getMaxSwapThreshold() {
        return this.maxSwapThreshold;
    }

    public void setMaxSwapThreshold(long maxSwapThreshold) {
        this.maxSwapThreshold = maxSwapThreshold;
    }

    public void setIsJD() {
        this.isJD = true;
    }

    public boolean isJd() {
        return this.isJD;
    }

    private class CleanupTask
    extends TimerTask {
        private CleanupTask() {
        }

        @Override
        public void run() {
            ManagedProcess.this.cleanupTimer.cancel();
            ((DuccProcess)ManagedProcess.this.getDuccProcess()).setUimaPipelineComponents(null);
        }
    }

    private class InitializationTask
    extends TimerTask {
        private InitializationTask() {
        }

        @Override
        public void run() {
            ManagedProcess.this.initTimer.cancel();
            ManagedProcess.this.notifyProcessObserver(IProcessState.ProcessState.InitializationTimeout);
        }
    }

    public static enum StopPriority {
        NONE,
        KILL_9,
        QUIESCE_AND_STOP,
        DONT_WAIT;

    }

    public static enum ProcessType {
        UIMA_SERVICE{}
        ,
        APPLICATION{}
        ,
        LAUNCHER{};

    }
}

