/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.ducc.agent.NodeAgent;
import org.apache.uima.ducc.agent.launcher.ManagedProcess;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.transport.event.common.IDuccProcessType;

public class CGroupsManager {
    private DuccLogger agentLogger = null;
    private static final String SYSTEM = "ducc";
    private static final String CGDuccMemoryPath = "/memory/ducc/";
    private static final String CGDuccCpuPath = "/cpu/ducc/";
    private static final String CGProcsFile = "/cgroup.procs";
    private boolean legacyCgConfig = false;
    private Set<String> containerIds = new LinkedHashSet<String>();
    private String cgroupBaseDir = "";
    private String cgroupUtilsDir = null;
    private boolean cpuInfoSymlinked = true;
    private String cgroupSubsystems = "";
    private long retryMax = 4L;
    private long delayFactor = 2000L;
    private long maxTimeToWaitForProcessToStop;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fetchCgroupsBaseDir(String mounts) {
        String cbaseDir;
        block15: {
            cbaseDir = null;
            BufferedReader br = null;
            ArrayList<String> cgroupsEntries = new ArrayList<String>();
            try {
                List<String> lines = Files.readAllLines(Paths.get(mounts, new String[0]), Charset.defaultCharset());
                for (String line : lines) {
                    if (!line.trim().startsWith("cgroup")) continue;
                    cgroupsEntries.add(line);
                }
                if (cgroupsEntries.size() == 1) {
                    String[] cgroupsInfo = ((String)cgroupsEntries.get(0)).split(" ");
                    cbaseDir = cgroupsInfo[1].trim();
                    break block15;
                }
                for (String line : cgroupsEntries) {
                    String[] cgroupsInfo = line.split(" ");
                    if (cgroupsInfo[1].indexOf("/memory") == -1) continue;
                    cbaseDir = cgroupsInfo[1].substring(0, cgroupsInfo[1].indexOf("/memory"));
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return cbaseDir;
    }

    public static void main(String[] args) {
        String[] paths;
        String cgroupsUtilsDirs = "/usr/bin,/bin";
        String cgUtilsPath = null;
        DuccLogger logger = DuccLogger.getLogger(CGroupsManager.class, (String)"CGroupsManager");
        for (String path : paths = cgroupsUtilsDirs.split(",")) {
            File file = new File(path.trim() + "/cgexec");
            if (!file.exists()) continue;
            cgUtilsPath = path;
            break;
        }
        String cgroupsBaseDir = CGroupsManager.fetchCgroupsBaseDir("/proc/mounts");
        if (cgUtilsPath == null) {
            System.out.println("------- CGroups Disabled - Unable to Find Cgroups Utils Directory. Add/Modify ducc.agent.launcher.cgroups.utils.dir property in ducc.properties");
        } else if (cgroupsBaseDir == null || cgroupsBaseDir.trim().length() == 0) {
            System.out.println("------- CGroups Disabled - Unable to Find Cgroups Root Directory in /proc/mounts");
        } else {
            System.out.println("Agent found cgroups runtime in " + cgUtilsPath + " cgroups base dir=" + cgroupsBaseDir);
            String cgroupsSubsystems = "memory,cpu";
            long maxTimeToWaitForProcessToStop = 60000L;
            CGroupsManager cgroupsManager = new CGroupsManager(cgUtilsPath, cgroupsBaseDir, cgroupsSubsystems, logger, maxTimeToWaitForProcessToStop);
            try {
                if (cgroupsManager.cgroupExists(cgroupsBaseDir)) {
                    System.out.println("Agent found cgroup base directory in " + cgroupsBaseDir);
                    String containerId = "test";
                    cgroupsManager.validator(cgroupsBaseDir, containerId, System.getProperty("user.name"), false).cgcreate().cgset(100L);
                    cgroupsManager.destroyContainer(containerId, System.getProperty("user.name"), -9);
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    public CGroupsManager(String cgroupUtilsDir, String cgroupBaseDir, String subsystems, DuccLogger agentLogger, long maxTimeToWaitForProcessToStop) {
        this.cgroupUtilsDir = cgroupUtilsDir;
        this.cgroupBaseDir = cgroupBaseDir;
        this.cgroupSubsystems = subsystems;
        this.agentLogger = agentLogger;
        this.maxTimeToWaitForProcessToStop = maxTimeToWaitForProcessToStop;
        try {
            File f = new File(cgroupBaseDir + "/memory");
            if (!f.exists()) {
                this.cgroupBaseDir = this.cgroupBaseDir + "/ducc/";
                this.legacyCgConfig = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cpuInfoSymlinked = this.symbolicLinksForCpu();
        String location = this.getCGroupLocation("cpuacct").trim();
        if (!this.legacyCgConfig) {
            if (!location.endsWith(System.getProperty("file.separator"))) {
                location = location + System.getProperty("file.separator");
            }
            location = location + SYSTEM + System.getProperty("file.separator");
        }
        System.out.println("------------- Location:" + location);
        File cpuacctUsageFile = new File(location + "cpuacct.usage");
        if (cpuacctUsageFile.exists()) {
            System.out.println("Got cpuacct.usage file");
            this.cgroupSubsystems = this.cgroupSubsystems + ",cpuacct";
        }
    }

    public String getCGroupsUtilsDir() {
        return this.cgroupUtilsDir;
    }

    private String getCGroupLocation(String subsystem) {
        String location = this.cgroupBaseDir.trim();
        if (this.legacyCgConfig) {
            return location;
        }
        if (!this.cgroupBaseDir.endsWith(System.getProperty("file.separator"))) {
            location = location + System.getProperty("file.separator");
        }
        return location + subsystem;
    }

    private boolean isCpuSubmodule(String[] parts, String submoduleName) {
        return parts.length > 10 && parts[10].equals(submoduleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean symbolicLinksForCpu() {
        File f = new File(this.cgroupBaseDir);
        if (!f.exists()) {
            return false;
        }
        InputStreamReader isr = null;
        BufferedReader reader = null;
        try {
            String line;
            String[] cmd = new String[]{"/bin/ls", "-l", this.cgroupBaseDir};
            StringBuffer sb = new StringBuffer();
            for (String s : cmd) {
                sb.append(s).append(" ");
            }
            this.agentLogger.info("symbolicLinksForCpu", null, new Object[]{"Launching Process - Commandline:" + sb.toString()});
            ProcessBuilder processLauncher = new ProcessBuilder(new String[0]);
            processLauncher.command(cmd);
            processLauncher.redirectErrorStream(true);
            Process process = processLauncher.start();
            isr = new InputStreamReader(process.getInputStream());
            reader = new BufferedReader(isr);
            String cpuLinkDir = "";
            String cpuacctLinkDir = "";
            this.agentLogger.info("symbolicLinksForCpu", null, new Object[]{"Consuming Process Streams"});
            while ((line = reader.readLine()) != null) {
                this.agentLogger.info("symbolicLinksForCpu", null, new Object[]{">>>>" + line});
                String[] parts = line.split(" ");
                if (parts.length <= 0 || parts[0].charAt(0) != 'l') continue;
                if (this.isCpuSubmodule(parts, "cpu")) {
                    cpuLinkDir = parts[parts.length - 1];
                } else if (this.isCpuSubmodule(parts, "cpuacct")) {
                    cpuacctLinkDir = parts[parts.length - 1];
                }
                if (cpuLinkDir.length() <= 0 || cpuacctLinkDir.length() <= 0) continue;
                break;
            }
            this.agentLogger.info("symbolicLinksForCpu", null, new Object[]{"Waiting for Process to Exit"});
            int retCode = process.waitFor();
            this.agentLogger.info("symbolicLinksForCpu", null, new Object[]{"Pocess Exit Code=" + retCode});
            if (cpuLinkDir.length() > 0 && cpuacctLinkDir.length() > 0 && cpuLinkDir.trim().equals(cpuLinkDir.trim())) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            this.agentLogger.error("symbolicLinksForCpu", null, (Throwable)e, new Object[0]);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public void configure(NodeAgent agent) {
        if (agent != null) {
            if (agent.configurationFactory.maxRetryCount != null) {
                this.retryMax = Integer.valueOf(agent.configurationFactory.maxRetryCount).intValue();
            }
            if (agent.configurationFactory.retryDelayFactor != null) {
                this.delayFactor = Integer.valueOf(agent.configurationFactory.retryDelayFactor).intValue();
            }
        }
    }

    public Validator validator(String cgroupsBaseDir, String containerId, String userName, boolean useDuccling) throws Exception {
        return new Validator(this, this.getCGroupLocation("memory"), containerId, userName, this.getUserGroupName(userName), useDuccling);
    }

    public String[] getPidsInCgroup(String cgroupName) throws Exception {
        File f = new File(this.getCGroupLocation(CGDuccMemoryPath) + cgroupName + CGProcsFile);
        return this.readPids(f);
    }

    private String[] readPids(File f) throws Exception {
        String line;
        ArrayList<String> pids = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(f));
        while ((line = br.readLine()) != null) {
            pids.add(line.trim());
        }
        br.close();
        return pids.toArray(new String[pids.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws Exception {
        Set<NodeProcessInfo> processes = this.getProcessesOnNode();
        Pattern p = Pattern.compile("((\\d+)\\.(\\d+)\\.(\\d+))");
        File cgroupsFolder = new File(this.getCGroupLocation(CGDuccMemoryPath));
        String[] files = cgroupsFolder.list();
        if (files == null || files.length == 0) {
            return;
        }
        for (String cgroupFolder : files) {
            Matcher m = p.matcher(cgroupFolder);
            if (!m.find()) continue;
            try {
                File f = new File(this.getCGroupLocation(CGDuccMemoryPath) + cgroupFolder + CGProcsFile);
                String[] pids = this.readPids(f);
                if (pids != null && pids.length > 0) {
                    this.agentLogger.info("cleanupOnStartup", null, new Object[]{"Agent found " + pids.length + " cgroup proceses still active. Proceeding to remove running processes"});
                }
                int zombieCount = 0;
                if (pids != null && pids.length > 0) {
                    for (String pid : pids) {
                        for (NodeProcessInfo proc : processes) {
                            if (proc.isZombie()) {
                                ++zombieCount;
                                continue;
                            }
                            if (!proc.getPid().equals(pid)) continue;
                            this.kill(proc.getUserid(), proc.getPid(), NodeAgent.SIGKILL);
                        }
                    }
                    long logCount = 0L;
                    while ((pids = this.readPids(f)) != null && pids.length != 0 && zombieCount != pids.length) {
                        try {
                            CGroupsManager i$ = this;
                            synchronized (i$) {
                                if (logCount % 10000L == 0L) {
                                    this.agentLogger.info("cleanupOnStartup", null, new Object[]{"--- CGroup:" + cgroupFolder + " procs file still showing processes running. Wait until CGroups updates acccounting"});
                                }
                                ++logCount;
                                this.wait(200L);
                            }
                        }
                        catch (InterruptedException ee) {
                            // empty catch block
                            break;
                        }
                    }
                }
                if (zombieCount == 0) {
                    this.destroyContainer(cgroupFolder, SYSTEM, NodeAgent.SIGTERM);
                    this.agentLogger.info("cleanupOnStartup", null, new Object[]{"--- Agent Removed Empty CGroup:" + cgroupFolder});
                    continue;
                }
                this.agentLogger.info("cleanupOnStartup", null, new Object[]{"CGroup " + cgroupFolder + " Contains Zombie Processing. Not Removing the Container"});
            }
            catch (FileNotFoundException f) {
            }
            catch (Exception e) {
                this.agentLogger.error("cleanupOnStartup", null, (Throwable)e, new Object[0]);
            }
        }
    }

    public boolean isPidInCGroup(String pid) throws Exception {
        String[] pids;
        for (String p : pids = this.getAllCGroupPids()) {
            if (!p.equals(pid)) continue;
            return true;
        }
        return false;
    }

    public String[] getAllCGroupPids() throws Exception {
        ArrayList<String> cgroupPids = new ArrayList<String>();
        Pattern p = Pattern.compile("((\\d+)\\.(\\d+)\\.(\\d+))");
        File cgroupsFolder = new File(this.getCGroupLocation(CGDuccMemoryPath));
        String[] files = cgroupsFolder.list();
        if (files == null || files.length == 0) {
            return new String[0];
        }
        for (String cgroupFolder : files) {
            Matcher m = p.matcher(cgroupFolder);
            if (!m.find()) continue;
            try {
                String[] pids;
                File f = new File(this.getCGroupLocation(CGDuccMemoryPath) + cgroupFolder + CGProcsFile);
                for (String pid : pids = this.readPids(f)) {
                    cgroupPids.add(pid);
                }
            }
            catch (Exception e) {
                this.agentLogger.error("getAllCGroupPids", null, (Throwable)e, new Object[0]);
                throw e;
            }
        }
        String[] pids = new String[cgroupPids.size()];
        return cgroupPids.toArray(pids);
    }

    public void kill(String user, String pid, int signal) {
        String methodName = "kill";
        String c_launcher_path = "";
        try {
            String arg;
            String cmdLine;
            boolean useDuccling = false;
            String useSpawn = System.getProperty("ducc.agent.launcher.use.ducc_spawn");
            if (useSpawn != null && useSpawn.toLowerCase().equals("true")) {
                useDuccling = true;
                c_launcher_path = Utils.resolvePlaceholderIfExists((String)System.getProperty("ducc.agent.launcher.ducc_spawn_path"), (Properties)System.getProperties());
            }
            if (Utils.isWindows()) {
                cmdLine = "taskkill";
                arg = "/PID";
            } else {
                cmdLine = "/bin/kill";
                arg = "-" + signal;
            }
            String[] command = useDuccling ? new String[]{c_launcher_path, "-u", user, "--", cmdLine, arg, pid} : new String[]{cmdLine, arg, pid};
            this.launchCommand(command);
            StringBuffer sb = new StringBuffer();
            for (String part : command) {
                sb.append(part).append(" ");
            }
            if (this.agentLogger == null) {
                System.out.println("--------- Killed Process:" + pid + " Owned by:" + user + " Command:" + sb.toString());
            } else {
                this.agentLogger.info("kill", null, new Object[]{"--------- Killed CGroup Process:" + pid + " Owned by:" + user + " Command:" + sb.toString()});
            }
        }
        catch (Exception e) {
            this.agentLogger.error("kill", null, (Throwable)e, new Object[0]);
        }
    }

    public String getContainerId(ManagedProcess managedProcess) {
        String containerId = managedProcess.getDuccProcess().getProcessType().equals((Object)IDuccProcessType.ProcessType.Service) ? String.valueOf(managedProcess.getDuccProcess().getCGroup().getId()) : managedProcess.getWorkDuccId().getFriendly() + "." + managedProcess.getDuccProcess().getCGroup().getId();
        return containerId;
    }

    public boolean createContainer(String containerId, String userName, String groupName, boolean useDuccSpawn) throws Exception {
        String message = "";
        this.agentLogger.info("createContainer", null, new Object[]{"Creating CGroup Container:" + containerId});
        String[] command = new String[]{this.cgroupUtilsDir + "/cgcreate", "-t", userName + ":" + groupName, "-a", userName + ":" + groupName, "-g", this.cgroupSubsystems + ":" + SYSTEM + "/" + containerId};
        int retCode = this.launchCommand(command);
        if (this.cgroupExists(this.getCGroupLocation(CGDuccMemoryPath) + containerId)) {
            if (retCode == 0 || retCode == 96) {
                this.containerIds.add(containerId);
                this.agentLogger.info("createContainer", null, new Object[]{">>>>SUCCESS - Created CGroup Container:" + containerId + ". The cgcreate return code:" + retCode});
                return true;
            }
        } else {
            message = ">>> CGroup Container:" + containerId + " not found in " + this.getCGroupLocation(CGDuccMemoryPath) + containerId;
        }
        this.agentLogger.error("createContainer", null, new Object[]{message});
        System.out.println(message);
        return false;
    }

    private String composeCpuAccountingFileName(String id) {
        String location = this.getCGroupLocation("cpuacct").trim();
        if (!location.endsWith(System.getProperty("file.separator"))) {
            location = location + System.getProperty("file.separator");
        }
        if (!this.legacyCgConfig) {
            location = location + SYSTEM + System.getProperty("file.separator");
        }
        return location + id + "cpuacct.usage";
    }

    private String composeMemoryStatFileName(String id) {
        String location = this.getCGroupLocation("memory").trim();
        if (!location.endsWith(System.getProperty("file.separator"))) {
            location = location + System.getProperty("file.separator");
        }
        if (!this.legacyCgConfig) {
            location = location + SYSTEM + System.getProperty("file.separator");
        }
        return location + id + "memory.stat";
    }

    public boolean isCpuReportingEnabled() {
        File f = new File(this.composeCpuAccountingFileName(""));
        System.out.println(f.getAbsolutePath());
        return f.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCpuUsage(String containerId) throws Exception {
        long usage;
        block9: {
            String file;
            block10: {
                block7: {
                    usage = 0L;
                    if (!containerId.endsWith(System.getProperty("file.separator"))) {
                        containerId = containerId + System.getProperty("file.separator");
                    }
                    file = this.composeCpuAccountingFileName(containerId.trim());
                    this.agentLogger.info("getCpuUsage", null, new Object[]{"CPUACCT.USAGE file:" + file});
                    File f = new File(file);
                    if (!f.exists()) break block10;
                    InputStreamReader isr = new InputStreamReader(new FileInputStream(f));
                    BufferedReader br = new BufferedReader(isr);
                    try {
                        String line = br.readLine();
                        if (line != null) {
                            this.agentLogger.trace("getCpuUsage", null, new Object[]{"CPUACCT.USAGE Line:" + line});
                            usage = Long.parseLong(line.trim());
                        }
                        if (isr == null) break block7;
                    }
                    catch (Exception e) {
                        block8: {
                            try {
                                this.agentLogger.error("getCpuUsage", null, (Throwable)e, new Object[0]);
                                if (isr == null) break block8;
                            }
                            catch (Throwable throwable) {
                                if (isr != null) {
                                    isr.close();
                                }
                                this.agentLogger.trace("getCpuUsage", null, new Object[]{"Done Reading cpuacct.stat file:" + file});
                                throw throwable;
                            }
                            isr.close();
                        }
                        this.agentLogger.trace("getCpuUsage", null, new Object[]{"Done Reading cpuacct.stat file:" + file});
                        break block9;
                    }
                    isr.close();
                }
                this.agentLogger.trace("getCpuUsage", null, new Object[]{"Done Reading cpuacct.stat file:" + file});
                break block9;
            }
            this.agentLogger.info("getCpuUsage", null, new Object[]{"CPUACCT.USAGE file:" + file + " Not Found - Process CPU Usage is Unavailable"});
            usage = -1L;
        }
        return usage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUsageForMemoryStat(CgroupMemoryStat stat, String containerId) throws Exception {
        long usage;
        block9: {
            String file;
            block10: {
                block7: {
                    usage = -1L;
                    if (!containerId.endsWith(System.getProperty("file.separator"))) {
                        containerId = containerId + System.getProperty("file.separator");
                    }
                    file = this.composeMemoryStatFileName(containerId.trim());
                    this.agentLogger.info("getUsageForMemoryStat", null, new Object[]{"MEMORY.STAT file:" + file});
                    File f = new File(file);
                    if (!f.exists()) break block10;
                    InputStreamReader isr = new InputStreamReader(new FileInputStream(f));
                    BufferedReader br = new BufferedReader(isr);
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            this.agentLogger.trace("getUsageForMemoryStat", null, new Object[]{"MEMORY.STAT Line:" + line});
                            if (!line.startsWith(stat.getKey())) continue;
                            usage = Long.parseLong(line.trim().split(" ")[1]);
                            break;
                        }
                        if (isr == null) break block7;
                    }
                    catch (Exception e) {
                        block8: {
                            try {
                                this.agentLogger.error("getUsageForMemoryStat", null, (Throwable)e, new Object[0]);
                                if (isr == null) break block8;
                            }
                            catch (Throwable throwable) {
                                if (isr != null) {
                                    isr.close();
                                }
                                this.agentLogger.trace("getUsageForMemoryStat", null, new Object[]{"Done Reading memory.stat file:" + file});
                                throw throwable;
                            }
                            isr.close();
                        }
                        this.agentLogger.trace("getUsageForMemoryStat", null, new Object[]{"Done Reading memory.stat file:" + file});
                        break block9;
                    }
                    isr.close();
                }
                this.agentLogger.trace("getUsageForMemoryStat", null, new Object[]{"Done Reading memory.stat file:" + file});
                break block9;
            }
            this.agentLogger.info("getUsageForMemoryStat", null, new Object[]{"MEMORY.STAT file:" + file + " Not Found - Process RSS Usage is Unavailable"});
            usage = -1L;
        }
        return usage;
    }

    public boolean setContainerMaxMemoryLimit(String containerId, String userId, boolean useDuccSpawn, long containerMaxSize) throws Exception {
        try {
            String[] command = new String[]{this.cgroupUtilsDir + "/cgset", "-r", "memory.limit_in_bytes=" + containerMaxSize, "ducc/" + containerId};
            int retCode = this.launchCommand(command);
            if (retCode == 0) {
                this.agentLogger.info("setContainerMaxMemoryLimit", null, new Object[]{">>>>SUCCESS - Created CGroup Limit on Container:" + containerId});
                return true;
            }
            this.agentLogger.info("setContainerMaxMemoryLimit", null, new Object[]{">>>>FAILURE - Unable To Create CGroup Container:" + containerId});
            return false;
        }
        catch (Exception e) {
            this.agentLogger.error("setContainerMaxMemoryLimit", null, new Object[]{">>>>FAILURE - Unable To Set Limit On CGroup Container:" + containerId, e});
            return false;
        }
    }

    public boolean setContainerCpuShares(String containerId, String userId, boolean useDuccSpawn, long containerCpuShares) throws Exception {
        try {
            String[] command = new String[]{this.cgroupUtilsDir + "/cgset", "-r", "cpu.shares=" + containerCpuShares, "ducc/" + containerId};
            int retCode = this.launchCommand(command);
            if (retCode == 0) {
                this.agentLogger.info("setContainerCpuShares", null, new Object[]{">>>>SUCCESS - Created CGroup with CPU Shares=" + containerCpuShares + " on Container:" + containerId});
                return true;
            }
            this.agentLogger.info("setContainerCpuShares", null, new Object[]{">>>>FAILURE - Unable To Set CPU shares on CGroup Container:" + containerId});
            return false;
        }
        catch (Exception e) {
            this.agentLogger.error("setContainerCpuShares", null, new Object[]{">>>>FAILURE - Unable To Set CPU shares On CGroup Container:" + containerId, e});
            return false;
        }
    }

    public boolean setContainerSwappiness(String containerId, String userId, boolean useDuccSpawn, long swappiness) throws Exception {
        try {
            String[] command = new String[]{this.cgroupUtilsDir + "/cgset", "-r", "memory.swappiness=" + swappiness, "ducc/" + containerId};
            int retCode = this.launchCommand(command);
            if (retCode == 0) {
                this.agentLogger.info("setContainerSwappiness", null, new Object[]{">>>>SUCCESS - Updated CGroup with Memory Swappiness=" + swappiness + " on Container:" + containerId});
                return true;
            }
            this.agentLogger.info("setContainerSwappiness", null, new Object[]{">>>>FAILURE - Unable To Set Swappiness on CGroup Container:" + containerId});
            return false;
        }
        catch (Exception e) {
            this.agentLogger.error("setContainerSwappiness", null, new Object[]{">>>>FAILURE - Unable To Set Swappiness On CGroup Container:" + containerId, e});
            return false;
        }
    }

    private int killChildProcesses(String containerId, String userId, int signal) throws Exception {
        int childCount = 0;
        String[] pids = this.getPidsInCgroup(containerId);
        if (pids != null) {
            if (pids.length > 0) {
                childCount = pids.length;
                this.agentLogger.info("killChildProcesses", null, new Object[]{"Found " + pids.length + " child processes still in container:" + containerId + " - killing all"});
            }
            for (String pid : pids) {
                try {
                    this.kill(userId, pid, signal);
                }
                catch (Exception ee) {
                    this.agentLogger.warn("killChildProcesses", null, new Object[]{"Unable to kill child process with PID:" + pid + " from cgroup:" + containerId + "\n" + ee});
                }
            }
        }
        return childCount;
    }

    private String adjustSubsystems() {
        if (this.cpuInfoSymlinked && this.cgroupSubsystems.indexOf(",cpuacct") > -1) {
            return this.cgroupSubsystems.substring(0, this.cgroupSubsystems.indexOf(",cpuacct"));
        }
        return this.cgroupSubsystems;
    }

    public boolean destroyContainer(String containerId, String userId, int signal) throws Exception {
        try {
            if (this.cgroupExists(this.getCGroupLocation(CGDuccMemoryPath) + containerId)) {
                if (signal == NodeAgent.SIGTERM) {
                    this.agentLogger.info("destroyContainer", null, new Object[]{"Destroying Container " + containerId + " Using signal:" + signal + " to kill child processes if any still exist in cgroups container"});
                    int childProcessCount = this.killChildProcesses(containerId, userId, NodeAgent.SIGTERM);
                    if (childProcessCount > 0) {
                        this.agentLogger.info("destroyContainer", null, new Object[]{"Killed " + childProcessCount + "Child Processes with kill -15"});
                        try {
                            this.wait(this.maxTimeToWaitForProcessToStop);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this.killChildProcesses(containerId, userId, NodeAgent.SIGKILL);
                String subsystems = this.adjustSubsystems();
                String[] command = new String[]{this.cgroupUtilsDir + "/cgdelete", subsystems + ":" + SYSTEM + "/" + containerId};
                int retCode = this.launchCommand(command);
                if (this.cgroupExists(this.getCGroupLocation(CGDuccMemoryPath) + containerId)) {
                    this.agentLogger.info("destroyContainer", null, new Object[]{"Failed to remove Container " + containerId + " Using cgdelete command. Exit code:" + retCode});
                    return false;
                }
                this.containerIds.remove(containerId);
                return true;
            }
            return true;
        }
        catch (Exception e) {
            this.agentLogger.info("destroyContainer", null, (Throwable)e, new Object[0]);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserGroupName(String userName) throws Exception {
        String groupName = "";
        InputStreamReader isr = null;
        try (BufferedReader reader = null;){
            String line;
            String[] cmd = new String[]{"/usr/bin/id", "-g", "-n", userName};
            StringBuffer sb = new StringBuffer();
            for (String s : cmd) {
                sb.append(s).append(" ");
            }
            this.agentLogger.info("getuserGroupName", null, new Object[]{"Launching Process - Commandline:" + sb.toString()});
            ProcessBuilder processLauncher = new ProcessBuilder(new String[0]);
            processLauncher.command(cmd);
            processLauncher.redirectErrorStream(true);
            Process process = processLauncher.start();
            isr = new InputStreamReader(process.getInputStream());
            reader = new BufferedReader(isr);
            this.agentLogger.info("getUserGroupName", null, new Object[]{"Consuming Process Streams"});
            while ((line = reader.readLine()) != null) {
                this.agentLogger.info("getUserGroupName", null, new Object[]{">>>>" + line});
                System.out.println(line);
                groupName = line.trim();
            }
            this.agentLogger.info("getUserGroupName", null, new Object[]{"Waiting for Process to Exit"});
            int retCode = process.waitFor();
            this.agentLogger.info("getUserGroupName", null, new Object[]{"Pocess Exit Code=" + retCode});
        }
        return groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int launchCommand(String[] command) throws Exception {
        int retryCount = 0;
        Object sleepMonitor = new Object();
        if (command == null) {
            return -1;
        }
        Class<CGroupsManager> clazz = CGroupsManager.class;
        synchronized (CGroupsManager.class) {
            long delay = this.delayFactor;
            while ((long)retryCount <= this.retryMax) {
                StringBuffer sb;
                String message;
                block29: {
                    int n;
                    BufferedReader reader;
                    block28: {
                        message = "";
                        InputStreamReader in = null;
                        reader = null;
                        sb = new StringBuffer();
                        if (command != null) {
                            for (int i = 0; i < command.length; ++i) {
                                sb.append(command[i]).append(" ");
                            }
                        }
                        try {
                            String line;
                            this.agentLogger.info("launchCommand", null, new Object[]{"Launching Process - Commandline:" + sb.toString()});
                            ProcessBuilder processLauncher = new ProcessBuilder(new String[0]);
                            processLauncher.command(command);
                            processLauncher.redirectErrorStream(true);
                            Process process = processLauncher.start();
                            in = new InputStreamReader(process.getInputStream());
                            reader = new BufferedReader(in);
                            this.agentLogger.info("launchCommand", null, new Object[]{"Consuming Process Streams"});
                            while ((line = reader.readLine()) != null) {
                                if (line.indexOf("Operation not permitted") > -1 || line.indexOf("cannot remove group") > -1) continue;
                                this.agentLogger.info("launchCommand", null, new Object[]{">>>>" + line});
                                System.out.println(line);
                            }
                            this.agentLogger.info("launchCommand", null, new Object[]{"Waiting for Process to Exit"});
                            int retCode = process.waitFor();
                            if (retCode == 0 || retCode == 96) {
                                System.out.println("--------- Returning Code:" + retCode + " Command:" + sb.toString());
                                n = retCode;
                                break block28;
                            }
                            message = ">>>>FAILURE - return code:" + retCode + " Unable To exec command:" + sb.toString() + " Retrying in " + delay + " millis - retry#" + (retryCount + 1);
                            break block29;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            message = ">>>>FAILURE - Unable To exec command:" + sb.toString() + " Retrying in " + delay + " millis - retry#" + (retryCount + 1);
                            break block29;
                        }
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return n;
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                if (this.retryMax == 0L) {
                    this.agentLogger.error("launchCommand", null, new Object[]{">>>>Not configured to retry command:" + sb.toString()});
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return -1;
                }
                this.agentLogger.error("launchCommand", null, new Object[]{message});
                System.out.println(message);
                try {
                    Object object = sleepMonitor;
                    synchronized (object) {
                        sleepMonitor.wait(delay);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++retryCount;
                delay += this.delayFactor;
            }
            return -1;
        }
    }

    public Set<String> collectExistingContainers() throws Exception {
        File[] existingCGroups;
        File duccCGroupBaseDir = new File(this.getCGroupLocation(CGDuccMemoryPath));
        if (duccCGroupBaseDir.exists() && (existingCGroups = duccCGroupBaseDir.listFiles()) != null) {
            for (File cgroup : existingCGroups) {
                if (!cgroup.isDirectory()) continue;
                this.containerIds.add(cgroup.getName());
            }
        }
        return this.containerIds;
    }

    public String getDuccCGroupBaseDir() {
        return this.cgroupBaseDir;
    }

    public String getSubsystems() {
        return this.cgroupSubsystems;
    }

    public boolean cgroupExists(String cgroup) throws Exception {
        File duccCGroupBaseDir = new File(cgroup);
        return duccCGroupBaseDir.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NodeProcessInfo> getProcessesOnNode() throws Exception {
        String location = "getProcessesOnNode";
        HashSet<NodeProcessInfo> processList = new HashSet<NodeProcessInfo>();
        InputStream stream = null;
        try (BufferedReader reader = null;){
            String line;
            ProcessBuilder pb = new ProcessBuilder("ps", "-Ao", "user:12,pid,ppid,args,stat", "--no-heading");
            pb.redirectErrorStream(true);
            Process proc = pb.start();
            stream = proc.getInputStream();
            reader = new BufferedReader(new InputStreamReader(stream));
            String regex = "\\s+";
            while ((line = reader.readLine()) != null) {
                String[] tokens = line.split(regex);
                String user = tokens[0];
                String pid = tokens[1];
                String ppid = tokens[2];
                String stat = tokens[4];
                if (tokens.length <= 0) continue;
                processList.add(new NodeProcessInfo(pid, ppid, user, stat));
            }
        }
        return processList;
    }

    public class Validator {
        private CGroupsManager cgmgr = null;
        String containerId;
        String userName;
        String userGroupName;
        boolean useDuccling;
        String cgroupsBaseDir;

        Validator(CGroupsManager instance, String cgroupsBaseDir, String containerId, String uid, String usergroup, boolean useDuccling) {
            this.cgmgr = instance;
            this.containerId = containerId;
            this.userName = uid;
            this.useDuccling = useDuccling;
            this.userGroupName = usergroup;
            this.cgroupsBaseDir = cgroupsBaseDir;
        }

        public Validator cgcreate() throws CGroupsException {
            String msg1 = "------- CGroups cgcreate failed to create a cgroup - disabling cgroups";
            String msg2 = "------- CGroups cgcreate failed to validate a cgroup - disabling cgroups";
            String msg3 = "------- CGroups cgcreate failed - disabling cgroups";
            try {
                if (!this.cgmgr.createContainer(this.containerId, this.userName, this.userGroupName, this.useDuccling)) {
                    throw new CGroupsException().addCommand(CGroupCommand.CGCREATE.cmd()).addMessage(msg1);
                }
                if (!this.cgmgr.cgroupExists(CGroupsManager.this.getCGroupLocation(CGroupsManager.CGDuccMemoryPath) + this.containerId)) {
                    throw new CGroupsException().addCommand(CGroupCommand.CGCREATE.cmd()).addMessage(msg2);
                }
            }
            catch (Exception e) {
                throw new CGroupsException(e).addCommand(CGroupCommand.CGCREATE.cmd()).addMessage(msg3);
            }
            return this;
        }

        public Validator cgset(long cpuShares) throws CGroupsException {
            String msg1 = "------- Check cgconfig.conf CPU control. The cgset failed to set cpu.shares";
            String msg2 = "------- Check cgconfig.conf CPU control. The cgset failed to find cpu.shares file";
            String msg3 = "------- Check cgconfig.conf CPU control. The cgset failed to write to cpu.shares file. Expected 100 shares found ";
            BufferedReader reader = null;
            String shares = "";
            try {
                if (!this.cgmgr.setContainerCpuShares(this.containerId, this.userName, this.useDuccling, cpuShares)) {
                    throw new CGroupsException().addCommand(CGroupCommand.CGSET.cmd()).addMessage(msg1);
                }
                File f = new File(CGroupsManager.this.getCGroupLocation(CGroupsManager.CGDuccCpuPath) + this.containerId + "/cpu.shares");
                reader = new BufferedReader(new FileReader(f));
                if (reader != null && (shares = reader.readLine()) != null) {
                    shares = shares.trim();
                }
                System.out.println("----- Cgroup cgset verifier - cpu.shares read from file:" + shares);
                if (!String.valueOf(cpuShares).equals(shares)) {
                    throw new CGroupsException().addCommand(CGroupCommand.CGSET.cmd()).addMessage(msg3 + shares);
                }
            }
            catch (FileNotFoundException e) {
                throw new CGroupsException(e).addCommand(CGroupCommand.CGSET.cmd()).addMessage(msg2);
            }
            catch (Exception e) {
                throw new CGroupsException(e).addCommand(CGroupCommand.CGSET.cmd()).addMessage(msg3 + shares);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return this;
        }
    }

    public class CGroupsException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private String command;
        private String msg;

        public CGroupsException() {
        }

        public CGroupsException(Exception e) {
            super(e);
        }

        public CGroupsException addCommand(String command) {
            this.command = command;
            return this;
        }

        public CGroupsException addMessage(String msg) {
            this.msg = msg;
            return this;
        }

        public String getCommand() {
            return this.command;
        }

        @Override
        public String getMessage() {
            return this.msg;
        }
    }

    public class NodeProcessInfo {
        private String pid;
        private String ppid;
        private String userid;
        private String stat;

        NodeProcessInfo(String pid, String ppid, String uid, String stat) {
            this.pid = pid;
            this.ppid = ppid;
            this.userid = uid;
            this.stat = stat;
        }

        public boolean isZombie() {
            return this.stat == "Z";
        }

        public String getPid() {
            return this.pid;
        }

        public String getPpid() {
            return this.ppid;
        }

        public String getUserid() {
            return this.userid;
        }

        public void setUserid(String userid) {
            this.userid = userid;
        }
    }

    public static enum CgroupMemoryStat {
        RSS("rss"),
        SWAP("swap"),
        FAULTS("pgpgin");

        String key;

        private CgroupMemoryStat(String aKey) {
            this.key = aKey;
        }

        public String getKey() {
            return this.key;
        }
    }

    static enum CGroupCommand {
        CGSET("cgset"),
        CGCREATE("cgcreate");

        String cmd;

        private CGroupCommand(String cmd) {
            this.cmd = cmd;
        }

        public String cmd() {
            return this.cmd;
        }
    }
}

