/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.event;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.Body;
import org.apache.uima.ducc.agent.NodeAgent;
import org.apache.uima.ducc.agent.ProcessLifecycleController;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.transport.dispatcher.DuccEventDispatcher;
import org.apache.uima.ducc.transport.event.DuccJobsStateEvent;
import org.apache.uima.ducc.transport.event.ProcessPurgeDuccEvent;
import org.apache.uima.ducc.transport.event.ProcessStartDuccEvent;
import org.apache.uima.ducc.transport.event.ProcessStateUpdateDuccEvent;
import org.apache.uima.ducc.transport.event.ProcessStopDuccEvent;
import org.apache.uima.ducc.transport.event.common.IDuccJobDeployment;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessType;
import org.apache.uima.ducc.transport.event.delegate.DuccEventDelegateListener;
import org.springframework.beans.factory.annotation.Qualifier;

@Qualifier(value="ael")
public class AgentEventListener
implements DuccEventDelegateListener {
    DuccLogger logger = DuccLogger.getLogger(this.getClass(), (String)"Agent");
    ProcessLifecycleController lifecycleController = null;
    private boolean cleanupPhase = true;
    private AtomicLong lastSequence = new AtomicLong();
    private volatile boolean forceInventoryUpdateDueToSequence = false;
    private NodeAgent agent;

    public AgentEventListener(NodeAgent agent, ProcessLifecycleController lifecycleController) {
        this.agent = agent;
        this.lifecycleController = lifecycleController;
    }

    public AgentEventListener(NodeAgent agent) {
        this.agent = agent;
    }

    public void setDuccEventDispatcher(DuccEventDispatcher eventDispatcher) {
    }

    private void reportIncomingStateForThisNode(DuccJobsStateEvent duccEvent) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (IDuccJobDeployment jobDeployment : duccEvent.getJobList()) {
            if (this.isTargetNodeForProcess(jobDeployment.getJdProcess())) {
                IDuccProcess process = jobDeployment.getJdProcess();
                sb.append("\nJD--> JobId:" + jobDeployment.getJobId() + " ProcessId:" + process.getDuccId() + " PID:" + process.getPID() + " Status:" + process.getProcessState() + " Resource State:" + process.getResourceState() + " isDeallocated:" + process.isDeallocated());
            }
            for (IDuccProcess process : jobDeployment.getJpProcessList()) {
                if (!this.isTargetNodeForProcess(process)) continue;
                sb.append("\n\tJob ID:" + jobDeployment.getJobId() + " ProcessId:" + process.getDuccId() + " PID:" + process.getPID() + " Status:" + process.getProcessState() + " Resource State:" + process.getResourceState() + " isDeallocated:" + process.isDeallocated());
            }
        }
        this.logger.info("reportIncomingStateForThisNode", null, new Object[]{sb.toString()});
    }

    public boolean forceInvotoryUpdate() {
        return this.forceInventoryUpdateDueToSequence;
    }

    public void resetForceInventoryUpdateFlag() {
        this.forceInventoryUpdateDueToSequence = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDuccJobsStateEvent(@Body DuccJobsStateEvent duccEvent) throws Exception {
        long sequence = duccEvent.getSequence();
        try {
            AgentEventListener agentEventListener = this;
            synchronized (agentEventListener) {
                if (sequence <= this.lastSequence.get()) {
                    this.logger.warn("reportIncomingStateForThisNode", null, new Object[]{"Received Out of Band Message. Expected Sequence Greater Than " + this.lastSequence + " Received " + sequence + " Instead"});
                    this.forceInventoryUpdateDueToSequence = true;
                    return;
                }
                this.lastSequence.set(sequence);
                this.logger.info("reportIncomingStateForThisNode", null, new Object[]{"Received OR Sequence:" + sequence + " Thread ID:" + Thread.currentThread().getId()});
                if (this.lifecycleController == null) {
                    this.lifecycleController = this.agent;
                }
                this.reportIncomingStateForThisNode(duccEvent);
                List reservations = duccEvent.getUserReservations();
                if (this.cleanupPhase) {
                    // empty if block
                }
                this.agent.setReservations(reservations);
                this.agent.takeDownProcessWithNoJob(this.agent, duccEvent.getJobList());
                for (IDuccJobDeployment jobDeployment : duccEvent.getJobList()) {
                    if (this.isTargetNodeForProcess(jobDeployment.getJdProcess())) {
                        this.agent.reconcileProcessStateAndTakeAction(this.lifecycleController, jobDeployment.getJdProcess(), jobDeployment.getJdCmdLine(), jobDeployment.getStandardInfo(), jobDeployment.getProcessMemoryAssignment(), jobDeployment.getJobId());
                    }
                    if (jobDeployment.getJpProcessList() != null) {
                        for (IDuccProcess process : jobDeployment.getJpProcessList()) {
                            if (!this.isTargetNodeForProcess(process)) continue;
                            this.agent.reconcileProcessStateAndTakeAction(this.lifecycleController, process, jobDeployment.getJpCmdLine(), jobDeployment.getStandardInfo(), jobDeployment.getProcessMemoryAssignment(), jobDeployment.getJobId());
                        }
                        continue;
                    }
                    this.logger.error("onDuccJobsStateEvent", jobDeployment.getJobId(), new Object[]{"Procss List is NULL"});
                }
            }
            if (!this.agent.receivedDuccState) {
                this.agent.receivedDuccState = true;
            }
        }
        catch (Exception e) {
            this.logger.error("onDuccJobsStateEvent", null, (Throwable)e, new Object[0]);
        }
    }

    private boolean isTargetNodeForProcess(IDuccProcess process) throws Exception {
        boolean retVal = false;
        if (process != null) {
            retVal = Utils.isTargetNodeForMessage((String)process.getNodeIdentity().getIp(), (String)this.agent.getIdentity().getIp());
        }
        return retVal;
    }

    public void onProcessStartEvent(@Body ProcessStartDuccEvent duccEvent) throws Exception {
        for (Map.Entry processEntry : duccEvent.getProcessMap().entrySet()) {
            if (!Utils.isTargetNodeForMessage((String)((IDuccProcess)processEntry.getValue()).getNodeIdentity().getIp(), (String)this.agent.getIdentity().getIp())) continue;
            this.logger.info(">>> onProcessStartEvent", null, new Object[]{"... Agent [" + this.agent.getIdentity().getIp() + "] Matches Target Node Assignment:" + ((IDuccProcess)processEntry.getValue()).getNodeIdentity().getIp() + " For Share Id:" + ((IDuccProcess)processEntry.getValue()).getDuccId()});
            this.agent.doStartProcess((IDuccProcess)processEntry.getValue(), duccEvent.getCommandLine(), duccEvent.getStandardInfo(), duccEvent.getDuccWorkId());
            if (!((IDuccProcess)processEntry.getValue()).getProcessType().equals((Object)IDuccProcessType.ProcessType.Pop)) continue;
            break;
        }
    }

    public void onProcessStopEvent(@Body ProcessStopDuccEvent duccEvent) throws Exception {
        for (Map.Entry processEntry : duccEvent.getProcessMap().entrySet()) {
            if (!Utils.isTargetNodeForMessage((String)((IDuccProcess)processEntry.getValue()).getNodeIdentity().getIp(), (String)this.agent.getIdentity().getIp())) continue;
            this.logger.info(">>> onProcessStopEvent", null, new Object[]{"... Agent Received StopProces Event - Process Ducc Id:" + ((IDuccProcess)processEntry.getValue()).getDuccId() + " PID:" + ((IDuccProcess)processEntry.getValue()).getPID()});
            this.agent.doStopProcess((IDuccProcess)processEntry.getValue());
        }
    }

    public void onProcessStateUpdate(@Body ProcessStateUpdateDuccEvent duccEvent) throws Exception {
        this.logger.info(">>> onProcessStateUpdate", null, new Object[]{"... Agent Received ProcessStateUpdateDuccEvent - Process State:" + duccEvent.getState() + " Process ID:" + duccEvent.getDuccProcessId()});
        this.agent.updateProcessStatus(duccEvent);
    }

    public void onProcessPurgeEvent(@Body ProcessPurgeDuccEvent duccEvent) throws Exception {
        this.logger.info(">>> onProcessPurgeEvent", null, new Object[]{"... Agent Received ProcessPurgeDuccEvent - Process ID:" + duccEvent.getProcess().getPID()});
        this.agent.purgeProcess(duccEvent.getProcess());
    }

    public long getLastSequence() {
        return this.lastSequence.get();
    }
}

